/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import org.netbeans.modules.profiler.heapwalk.HeapWalkerManager;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public class OpenHeapWalkerAction
extends SystemAction {
    private static final String ACTION_NAME = NbBundle.getMessage(OpenHeapWalkerAction.class, (String)"OpenHeapWalkerAction_ActionName");
    private static final String DIALOG_CAPTION = NbBundle.getMessage(OpenHeapWalkerAction.class, (String)"OpenHeapWalkerAction_DialogCaption");
    private static File importDir;

    public OpenHeapWalkerAction() {
        this.putValue("noIconInMenu", null);
        this.setIcon(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/resources/memory.png", (boolean)true)));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(OpenHeapWalkerAction.class);
    }

    public String getName() {
        return ACTION_NAME;
    }

    public void actionPerformed(ActionEvent e) {
        final File heapDumpFile = OpenHeapWalkerAction.getHeapDumpFile();
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                if (heapDumpFile != null) {
                    HeapWalkerManager.getDefault().openHeapWalker(heapDumpFile);
                }
            }
        });
    }

    private static File getHeapDumpFile() {
        JFileChooser chooser = new JFileChooser();
        if (importDir != null) {
            chooser.setCurrentDirectory(importDir);
        }
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogType(0);
        chooser.setDialogTitle(DIALOG_CAPTION);
        if (chooser.showOpenDialog(IDEUtils.getMainWindow()) == 0) {
            importDir = chooser.getCurrentDirectory();
            return chooser.getSelectedFile();
        }
        return null;
    }
}

