/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.memorylint.rules;

import java.util.HashMap;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.heapwalk.memorylint.FieldAccess;
import org.netbeans.modules.profiler.heapwalk.memorylint.Histogram;
import org.netbeans.modules.profiler.heapwalk.memorylint.IteratingRule;
import org.netbeans.modules.profiler.heapwalk.memorylint.MemoryLint;
import org.netbeans.modules.profiler.heapwalk.memorylint.StringHelper;
import org.netbeans.modules.profiler.heapwalk.memorylint.Utils;
import org.openide.util.NbBundle;

public class DuplicatedString
extends IteratingRule {
    private FieldAccess fldValue;
    private HashMap<String, Integer> map = new HashMap();
    private Histogram<Histogram.Entry> dupSources = new Histogram();
    private StringHelper helper;
    private int total;

    public DuplicatedString() {
        super(NbBundle.getMessage(DuplicatedString.class, (String)"LBL_DupStr_Name"), NbBundle.getMessage(DuplicatedString.class, (String)"LBL_DupStr_Desc"), "java.lang.String");
    }

    public String getHTMLDescription() {
        return NbBundle.getMessage(DuplicatedString.class, (String)"LBL_DupStr_LongDesc");
    }

    protected void perform(Instance in) {
        String str = this.helper.decodeString(in);
        Integer val = this.map.get(str);
        if (val != null) {
            int strSize = in.getSize();
            Instance arr = this.fldValue.getRefValue(in);
            if (arr != null) {
                strSize += str.length() * 2 + 14;
            }
            String incomming = this.getContext().getRootIncommingString(in);
            incomming = Utils.printClass(this.getContext(), incomming);
            this.dupSources.add(incomming, new Histogram.Entry(strSize));
            this.total += strSize;
        }
        val = val == null ? 1 : val + 1;
        this.map.put(str, val);
    }

    protected void prepareRule(MemoryLint context) {
        Heap heap = context.getHeap();
        this.helper = context.getStringHelper();
        JavaClass clsString = heap.getJavaClassByName("java.lang.String");
        this.fldValue = new FieldAccess(clsString, "value");
    }

    protected void summary() {
        this.getContext().appendResults(NbBundle.getMessage(DuplicatedString.class, (String)"FMT_DupStr_Result", (Object)this.total));
        this.getContext().appendResults(this.dupSources.toString(50000));
    }
}

