/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.TagBounds;

class StringSegment
extends TagBounds {
    final int UTF8CharsOffset;
    final int lengthOffset;
    final int stringIDOffset;
    final int timeOffset;
    Map stringIDMap;
    private HprofHeap hprofHeap;

    StringSegment(HprofHeap heap, long start, long end) {
        super(1, start, end);
        int idSize = heap.dumpBuffer.getIDSize();
        this.hprofHeap = heap;
        this.timeOffset = 1;
        this.lengthOffset = this.timeOffset + 4;
        this.stringIDOffset = this.lengthOffset + 4;
        this.UTF8CharsOffset = this.stringIDOffset + idSize;
    }

    String getString(long start) {
        HprofByteBuffer dumpBuffer = this.getDumpBuffer();
        if (start == -1L) {
            return "<unknown string>";
        }
        int len = dumpBuffer.getInt(start + (long)this.lengthOffset);
        byte[] chars = new byte[len - dumpBuffer.getIDSize()];
        dumpBuffer.get(start + (long)this.UTF8CharsOffset, chars);
        String s = "Error";
        try {
            s = new String(chars, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        return s;
    }

    String getStringByID(long stringID) {
        return this.getString(this.getStringOffsetByID(stringID));
    }

    long getStringOffsetByID(long stringID) {
        Long startLong;
        if (this.stringIDMap == null) {
            this.stringIDMap = new HashMap(8000);
            long[] offset = new long[]{this.startOffset};
            while (offset[0] < this.endOffset) {
                long start = offset[0];
                long sID = this.readStringTag(offset);
                this.stringIDMap.put(new Long(sID), new Long(start));
            }
        }
        if ((startLong = (Long)this.stringIDMap.get(new Long(stringID))) == null) {
            return -1L;
        }
        return startLong;
    }

    private HprofByteBuffer getDumpBuffer() {
        HprofByteBuffer dumpBuffer = this.hprofHeap.dumpBuffer;
        return dumpBuffer;
    }

    private long readStringTag(long[] offset) {
        long start = offset[0];
        if (this.hprofHeap.readTag(offset) != 1) {
            return 0L;
        }
        return this.getDumpBuffer().getID(start + (long)this.stringIDOffset);
    }
}

