/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import org.netbeans.lib.profiler.heap.ArrayItemValue;
import org.netbeans.lib.profiler.heap.ClassDump;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.ObjectArrayDump;

class HprofArrayValue
implements ArrayItemValue {
    final ClassDump dumpClass;
    final int index;
    final long instanceArrayOffset;

    HprofArrayValue(ClassDump cls, long offset, int number) {
        this.dumpClass = cls;
        this.instanceArrayOffset = offset;
        this.index = number;
    }

    public Instance getDefiningInstance() {
        return new ObjectArrayDump(this.dumpClass, this.instanceArrayOffset);
    }

    public int getIndex() {
        return this.index;
    }

    public Instance getInstance() {
        HprofHeap heap = this.dumpClass.getHprof();
        HprofByteBuffer dumpBuffer = heap.dumpBuffer;
        int idSize = dumpBuffer.getIDSize();
        long instaceId = dumpBuffer.getID(this.instanceArrayOffset + 1L + (long)idSize + 4L + 4L + (long)idSize + (long)(this.index * idSize));
        return heap.getInstanceByID(instaceId);
    }
}

