/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.jmx.application;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.application.jvm.Jvm;
import com.sun.tools.visualvm.core.datasource.Storage;
import com.sun.tools.visualvm.core.datasupport.Utils;
import com.sun.tools.visualvm.host.Host;
import com.sun.tools.visualvm.tools.jmx.JmxModel;
import com.sun.tools.visualvm.tools.jmx.JmxModelFactory;
import com.sun.tools.visualvm.tools.jmx.JvmMXBeans;
import com.sun.tools.visualvm.tools.jmx.JvmMXBeansFactory;
import java.io.File;
import java.lang.management.RuntimeMXBean;
import javax.management.remote.JMXServiceURL;

public final class JmxApplication
extends Application {
    private int pid = -1;
    private final JMXServiceURL url;
    private final String username;
    private final String password;
    private final boolean saveCredentials;
    private final Storage storage;
    Jvm jvm;

    public JmxApplication(Host host, JMXServiceURL url, String username, String password, boolean saveCredentials, Storage storage) {
        super(host, url.toString() + (username == null || username.isEmpty() ? "" : " (" + username + ")"));
        this.url = url;
        this.username = username;
        this.password = password;
        this.saveCredentials = saveCredentials;
        this.storage = storage;
    }

    void setStateImpl(int newState) {
        if (newState != 1) {
            this.pid = -1;
            this.jvm = null;
        }
        this.setState(newState);
    }

    public JMXServiceURL getJMXServiceURL() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean getSaveCredentialsFlag() {
        return this.saveCredentials;
    }

    public int getPid() {
        String name;
        RuntimeMXBean rt;
        JvmMXBeans mxbeans;
        JmxModel jmxModel;
        if (this.pid == -1 && (jmxModel = JmxModelFactory.getJmxModelFor((Application)this)) != null && jmxModel.getConnectionState() == JmxModel.ConnectionState.CONNECTED && (mxbeans = JvmMXBeansFactory.getJvmMXBeans((JmxModel)jmxModel)) != null && (rt = mxbeans.getRuntimeMXBean()) != null && (name = rt.getName()) != null && name.indexOf("@") != -1) {
            name = name.substring(0, name.indexOf("@"));
            this.pid = Integer.parseInt(name);
        }
        return this.pid;
    }

    public boolean supportsUserRemove() {
        return true;
    }

    protected Storage createStorage() {
        return this.storage;
    }

    protected void remove() {
        File appStorage = this.getStorage().getDirectory();
        if (appStorage.isDirectory()) {
            Utils.delete((File)appStorage, (boolean)true);
        }
    }

    public String toString() {
        return "JmxApplication [id: " + this.getId() + "]";
    }
}

