/***************************************************************************
* $Id: RangeControls.java 140519 2002-03-03 11:16:10Z rdale $
**
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/

import org.kde.qt.*;

class RangeControls  extends QVBox
{

private    QCheckBox notches, wrapping;



RangeControls( )
{
	this(null, null);
}

RangeControls( QWidget parent, String name )
{
    super( parent, name );
    QHBox row1 = new QHBox( this );

    QVBox cell2 = new QVBox( row1 );
    cell2.setMargin( 10 );
    cell2.setFrameStyle( QFrame.WinPanel | QFrame.Sunken );

    new QWidget( cell2 );

    QLabel label1 = new QLabel( "Enter a value between\n" + ( -Integer.MAX_VALUE ) + " and " + Integer.MAX_VALUE + ":", cell2 );
    label1.setMaximumHeight( label1.sizeHint().height() );
    QSpinBox sb1 = new QSpinBox( -Integer.MAX_VALUE, Integer.MAX_VALUE, 1, cell2 );
    sb1.setValue( 0 );

    QLabel label2 = new QLabel( "Enter a zoom value:", cell2 );
    label2.setMaximumHeight( label2.sizeHint().height() );
    QSpinBox sb2 = new QSpinBox( 0, 1000, 10, cell2 );
    sb2.setSuffix( " %" );
    sb2.setSpecialValueText( "Automatic" );

    QLabel label3 = new QLabel( "Enter a price:", cell2 );
    label3.setMaximumHeight( label3.sizeHint().height() );
    QSpinBox sb3 = new QSpinBox( 0, Integer.MAX_VALUE, 1, cell2 );
    sb3.setPrefix( "$" );
    sb3.setValue( 355 );

    new QWidget( cell2 );

    QHBox row2 = new QHBox( this );

    QVBox cell3 = new QVBox( row2 );
    cell3.setMargin( 10 );
    cell3.setFrameStyle( QFrame.WinPanel | QFrame.Sunken );
    QSlider hslider = new QSlider( 0, 64, 1, 33, Qt.Horizontal, cell3 );
    QLCDNumber lcd2 = new QLCDNumber( 2, cell3 );
    lcd2.display( 33 );
    lcd2.setSegmentStyle( QLCDNumber.Filled );
    connect( hslider, SIGNAL(" valueChanged( int )"), lcd2, SLOT(" display( int )") );

    QHBox cell4 = new QHBox( row2 );
    cell4.setFrameStyle( QFrame.WinPanel | QFrame.Sunken );
    cell4.setMargin( 10 );
    QSlider vslider = new QSlider( 0, 64, 1, 8, Qt.Vertical, cell4 );
    QLCDNumber lcd3 = new QLCDNumber( 3, cell4 );
    lcd3.display( 8 );
    connect( vslider, SIGNAL(" valueChanged( int )"), lcd3, SLOT(" display( int )") );
}
}
