#!/usr/bin/env kjscmd

function buildViewNode( node, parent )
{
    var l = new QLabel( parent, 'node' );
    l.text = '<center><table cellspacing=0>'
	+ '<tr><th bgcolor="#aaaaee"><b>' + node.text + '</b></th></tr>'
	+ '<tr><td bgcolor="#ccccee">' + node.text + '</td></tr>'
	+ '<tr><td bgcolor="#ccccee">' + node.text + '</td></tr>'
	+ '</table></center>';
    
    return l;
}

function buildView( node, parent )
{
    // No children
    if ( node.children.length == 0 ) {
	return buildViewNode( node, parent );
    }

    // Create container node
    var vbox = new QVBox( parent, 'subtree' );
    vbox.margin = 8;
    vbox.spacing = 6;

    var vnode = buildViewNode( node, vbox );

    // Create children
    var hbox = new QHBox( vbox, 'child_nodes' );
    hbox.spacing = 6;

    for ( var i = 0 ; i < node.children.length ; i++ ) {
	buildView( node.children[i], hbox );
    }

    return vbox;
}

function buildNode( ttl )
{
    var node = new Object();
    node.text = ttl;
    node.children = [];
    return node;
}

// Create Tree Model
var root = buildNode( 'Root' );

root.children = [ buildNode('One'), buildNode('Two'), buildNode('Three') ];
root.children[0].children = [ buildNode('One'), buildNode('Two') ];
root.children[0].children = [ buildNode('One'), buildNode('Two') ];
root.children[1].children = [ buildNode('One'), buildNode('Two') ];
root.children[1].children = [ buildNode('One'), buildNode('Two'), buildNode('Three') ];
root.children[2].children = [ buildNode('One') ];
root.children[2].children = [ buildNode('One'), buildNode('Two'), buildNode('Three') ];

// Create View
var box = new QVBox( 'tree_view' );
box.margin = 6;

var view = buildView( root, box );
var spacer = new QLabel( box );

box.show();


