//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QRect;
import org.kde.qt.QtSupport;
import java.util.ArrayList;

/**

 The <code>Node</code> interface is the primary datatype for the
 entire Document Object Model. It represents a single node in the
 document tree. While all objects implementing the <code>Node</code>
 interface expose methods for dealing with children, not all
 objects implementing the <code>Node</code> interface may have
 children. For example, <code>Text</code> nodes may not have
 children, and adding children to such nodes results in a
 <code>DOMException</code> being raised.
  The attributes <code>nodeName</code> , <code>nodeValue</code>
 and <code>attributes</code> are included as a mechanism to get at
 node information without casting down to the specific derived
 interface. In cases where there is no obvious mapping of these
 attributes for a specific <code>nodeType</code> (e.g.,
 <code>nodeValue</code> for an Element or <code>attributes</code> for a
 Comment), this returns <code>null</code> . Note that the
 specialized interfaces may contain additional and more convenient
 mechanisms to get and set the relevant information.
 		@short    The <code>Node</code> interface is the primary datatype for the  entire Document Object Model.

*/
public class Node implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;
	protected Node(Class dummy){}

	public Node() {
		newNode();
	}
	private native void newNode();
	public Node(Node other) {
		newNode(other);
	}
	private native void newNode(Node other);
	/**	
			     		@short
	*/
	// DOM::Node* Node(DOM::NodeImpl* arg1); >>>> NOT CONVERTED
	public native boolean op_equals(Node other);
	public native boolean op_not_equals(Node other);
	/**	
		 The name of this node, depending on its type; see the table
		 above.
			     		@short    The name of this node, depending on its type; see the table  above.
	*/
	public native String nodeName();
	/**	
		 The value of this node, depending on its type; see the table
		 above.
			     		@short    The value of this node, depending on its type; see the table  above.
	*/
	public native String nodeValue();
	/**	
		 see nodeValue
			     		@short    see nodeValue
	*/
	public native void setNodeValue(String arg1);
	/**	
		 A code representing the type of the underlying object, as
		 defined above.
			     		@short    A code representing the type of the underlying object, as  defined above.
	*/
	public native short nodeType();
	/**	
		 The parent of this node. All nodes, except <code>Document</code>
		 , <code>DocumentFragment</code> , and <code>Attr</code>
		 may have a parent. However, if a node has just been
		 created and not yet added to the tree, or if it has been
		 removed from the tree, this is <code>null</code> .
			     		@short    The parent of this node.
	*/
	public native Node parentNode();
	/**	
		 A <code>ArrayList</code> that contains all children of this
		 node. If there are no children, this is a <code>ArrayList</code>
		 containing no nodes. The content of the returned
		 <code>ArrayList</code> is &quot;live&quot; in the sense that, for
		 instance, changes to the children of the node object that it
		 was created from are immediately reflected in the nodes
		 returned by the <code>ArrayList</code> accessors; it is not a
		 static snapshot of the content of the node. This is true for
		 every <code>ArrayList</code> , including the ones returned by
		 the <code>getElementsByTagName</code> method.
			     		@short    A <code>NodeList</code> that contains all children of this  node.
	*/
	public native ArrayList childNodes();
	/**	
		 The first child of this node. If there is no such node, this
		 returns <code>null</code> .
			     		@short    The first child of this node.
	*/
	public native Node firstChild();
	/**	
		 The last child of this node. If there is no such node, this
		 returns <code>null</code> .
			     		@short    The last child of this node.
	*/
	public native Node lastChild();
	/**	
		 The node immediately preceding this node. If there is no such
		 node, this returns <code>null</code> .
			     		@short    The node immediately preceding this node.
	*/
	public native Node previousSibling();
	/**	
		 The node immediately following this node. If there is no such
		 node, this returns <code>null</code> .
			     		@short    The node immediately following this node.
	*/
	public native Node nextSibling();
	/**	
		 A <code>NamedNodeMap</code> containing the attributes of this
		 node (if it is an <code>Element</code> ) or <code>null</code>
		 otherwise.
			     		@short    A <code>NamedNodeMap</code> containing the attributes of this  node (if it is an <code>Element</code> ) or <code>null</code>  otherwise.
	*/
	public native NamedNodeMap attributes();
	/**	
		 The <code>Document</code> object associated with this node.
		 This is also the <code>Document</code> object used to create
		 new nodes. When this node is a <code>Document</code> this is
		 <code>null</code> .
			     		@short    The <code>Document</code> object associated with this node.
	*/
	public native Document ownerDocument();
	/**	
		 Inserts the node <code>newChild</code> before the existing
		 child node <code>refChild</code> . If <code>refChild</code>
		 is <code>null</code> , insert <code>newChild</code> at the
		 end of the list of children.
			  If <code>newChild</code> is a <code>DocumentFragment</code>
		 object, all of its children are inserted, in the same
		 order, before <code>refChild</code> . If the <code>newChild</code>
		 is already in the tree, it is first removed.
			@param newChild The node to insert.
			@param refChild The reference node, i.e., the node before which
		 the new node must be inserted.
			  WRONG_DOCUMENT_ERR: Raised if <code>newChild</code> was
		 created from a different document than the one that created
		 this node.
			  NO_MODIFICATION_ALLOWED_ERR: Raised if this node is readonly.
			  NOT_FOUND_ERR: Raised if <code>refChild</code> is not a
		 child of this node.
			     		@return The node being inserted.

		@short    Inserts the node <code>newChild</code> before the existing  child node <code>refChild</code> .
	*/
	public native Node insertBefore(Node newChild, Node refChild);
	/**	
		 Replaces the child node <code>oldChild</code> with
		 <code>newChild</code> in the list of children, and returns the
		 <code>oldChild</code> node. If the <code>newChild</code> is
		 already in the tree, it is first removed.
			@param newChild The new node to put in the child list.
			@param oldChild The node being replaced in the list.
			  WRONG_DOCUMENT_ERR: Raised if <code>newChild</code> was
		 created from a different document than the one that created
		 this node.
			  NO_MODIFICATION_ALLOWED_ERR: Raised if this node is readonly.
			  NOT_FOUND_ERR: Raised if <code>oldChild</code> is not a
		 child of this node.
			     		@return The node replaced.

		@short    Replaces the child node <code>oldChild</code> with  <code>newChild</code> in the list of children, and returns the  <code>oldChild</code> node.
	*/
	public native Node replaceChild(Node newChild, Node oldChild);
	/**	
		 Removes the child node indicated by <code>oldChild</code>
		 from the list of children, and returns it.
			@param oldChild The node being removed.
			  NOT_FOUND_ERR: Raised if <code>oldChild</code> is not a
		 child of this node.
			     		@return The node removed.

		@short    Removes the child node indicated by <code>oldChild</code>  from the list of children, and returns it.
	*/
	public native Node removeChild(Node oldChild);
	/**	
		 Adds the node <code>newChild</code> to the end of the list of
		 children of this node. If the <code>newChild</code> is
		 already in the tree, it is first removed.
			@param newChild The node to add.
			  If it is a <code>DocumentFragment</code> object, the entire
		 contents of the document fragment are moved into the child list
		 of this node
			  WRONG_DOCUMENT_ERR: Raised if <code>newChild</code> was
		 created from a different document than the one that created
		 this node.
			  NO_MODIFICATION_ALLOWED_ERR: Raised if this node is readonly.
			     		@return The node added.

		@short    Adds the node <code>newChild</code> to the end of the list of  children of this node.
	*/
	public native Node appendChild(Node newChild);
	/**	
		 This is a convenience method to allow easy determination of
		 whether a node has any children.
			     		@return <code>true</code> if the node has any children,
 <code>false</code> if the node has no children.

		@short    This is a convenience method to allow easy determination of  whether a node has any children.
	*/
	public native boolean hasChildNodes();
	/**	
		 Returns a duplicate of this node, i.e., serves as a generic
		 copy constructor for nodes. The duplicate node has no parent (
		 <code>parentNode</code> returns <code>null</code> .).
			  Cloning an <code>Element</code> copies all attributes and
		 their values, including those generated by the XML processor to
		 represent defaulted attributes, but this method does not copy
		 any text it contains unless it is a deep clone, since the text
		 is contained in a child <code>Text</code> node. Cloning any
		 other type of node simply returns a copy of this node.
			@param deep If <code>true</code> , recursively clone the
		 subtree under the specified node; if <code>false</code> ,
		 clone only the node itself (and its attributes, if it is an
		 <code>Element</code> ).
			     		@return The duplicate node.

		@short    Returns a duplicate of this node, i.
	*/
	public native Node cloneNode(boolean deep);
	/**	
		 Modified in DOM Level 2
			 Puts all Text nodes in the full depth of the sub-tree underneath this
		 Node, including attribute nodes, into a "normal" form where only
		 structure (e.g., elements, comments, processing instructions, CDATA
		 sections, and entity references) separates Text nodes, i.e., there are
		 neither adjacent Text nodes nor empty Text nodes. This can be used to
		 ensure that the DOM view of a document is the same as if it were saved
		 and re-loaded, and is useful when operations (such as XPointer
		 [XPointer] lookups) that depend on a particular document tree structure
		 are to be used.
			 Note: In cases where the document contains CDATASections, the normalize
		 operation alone may not be sufficient, since XPointers do not
		 differentiate between Text nodes and CDATASection nodes.
		     		@short    Modified in DOM Level 2
	*/
	public native void normalize();
	/**	
		 Introduced in DOM Level 2
			 Tests whether the DOM implementation implements a specific feature and
		 that feature is supported by this node.
			@param feature The name of the feature to test. This is the same name
		 which can be passed to the method hasFeature on DOMImplementation.
			@param version This is the version number of the feature to test. In
		 Level 2, version 1, this is the string "2.0". If the version is not
		 specified, supporting any version of the feature will cause the method
		 to return true.
				@return Returns true if the specified feature is supported on this node,
 false otherwise.
     
		@short    Introduced in DOM Level 2
	*/
	public native boolean isSupported(String feature, String version);
	/**	
		 Introduced in DOM Level 2
			 The namespace URI of this node, or null if it is unspecified.
		 This is not a computed value that is the result of a namespace lookup
		 based on an examination of the namespace declarations in scope. It is
		 merely the namespace URI given at creation time. For nodes of any type
		 other than ELEMENT_NODE and ATTRIBUTE_NODE and nodes created with a DOM
		 Level 1 method, such as createElement from the Document interface, this
		 is always null.
			 Note: Per the Namespaces in XML Specification [Namespaces] an attribute
		 does not inherit its namespace from the element it is attached to. If an
		 attribute is not explicitly given a namespace, it simply has no
		 namespace.
		     		@short    Introduced in DOM Level 2
	*/
	public native String namespaceURI();
	/**	
		 Introduced in DOM Level 2
			 The namespace prefix of this node, or null if it is unspecified.
		 Note that setting this attribute, when permitted, changes the nodeName
		 attribute, which holds the qualified name, as well as the tagName and
		 name attributes of the Element and Attr interfaces, when applicable.
		 Note also that changing the prefix of an attribute that is known to have
		 a default value, does not make a new attribute with the default value
		 and the original prefix appear, since the namespaceURI and localName do
		 not change.
		 For nodes of any type other than ELEMENT_NODE and ATTRIBUTE_NODE and
		 nodes created with a DOM Level 1 method, such as createElement from the
		 Document interface, this is always null.
		     		@short    Introduced in DOM Level 2
	*/
	public native String prefix();
	/**	
		 see prefix
			 NO_MODIFICATION_ALLOWED_ERR: Raised if this node is readonly.
			 NAMESPACE_ERR: Raised if the specified prefix is malformed, if the
		 namespaceURI of this node is null, if the specified prefix is "xml" and
		 the namespaceURI of this node is different from
		 "http://www.w3.org/XML/1998/namespace", if this node is an attribute and
		 the specified prefix is "xmlns" and the namespaceURI of this node is
		 different from "http://www.w3.org/2000/xmlns/", or if this node is an
		 attribute and the qualifiedName of this node is "xmlns" [Namespaces].
		     		@short    see prefix
	*/
	public native void setPrefix(String prefix);
	/**	
		 Introduced in DOM Level 2
			 Returns the local part of the qualified name of this node.
		 For nodes of any type other than ELEMENT_NODE and ATTRIBUTE_NODE and
		 nodes created with a DOM Level 1 method, such as createElement from the
		 Document interface, this is always null.
		     		@short    Introduced in DOM Level 2
	*/
	public native String localName();
	/**	
		 Returns whether this node (if it is an element) has any attributes.
				@return a boolean. True if this node has any attributes, false otherwise.
  Introduced in DOM Level 2
     
		@short    Returns whether this node (if it is an element) has any attributes.
	*/
	public native boolean hasAttributes();
	/**	
		 Introduced in DOM Level 2
		 This method is from the EventTarget interface
			 This method allows the registration of event listeners on the event
		 target. If an EventListener is added to an EventTarget while it is
		 processing an event, it will not be triggered by the current actions but
		 may be triggered during a later stage of event flow, such as the
		 bubbling phase.
			 If multiple identical EventListeners are registered on the same
		 EventTarget with the same parameters the duplicate instances are
		 discarded. They do not cause the EventListener to be called twice and
		 since they are discarded they do not need to be removed with the
		 removeEventListener method. Parameters
			@param type The event type for which the user is registering
			@param listener The listener parameter takes an interface implemented by
		 the user which contains the methods to be called when the event occurs.
			@param useCapture If true, useCapture indicates that the user wishes to
		 initiate capture. After initiating capture, all events of the specified
		 type will be dispatched to the registered EventListener before being
		 dispatched to any EventTargets beneath them in the tree. Events which
		 are bubbling upward through the tree will not trigger an EventListener
		 designated to use capture.
		     		@short    Introduced in DOM Level 2  This method is from the EventTarget interface
	*/
	public native void addEventListener(String type, EventListener listener, boolean useCapture);
	/**	
		 Introduced in DOM Level 2
		 This method is from the EventTarget interface
			 This method allows the removal of event listeners from the event target.
		 If an EventListener is removed from an EventTarget while it is
		 processing an event, it will not be triggered by the current actions.
			 EventListeners can never be invoked after being removed.
			 Calling removeEventListener with arguments which do not identify any
		 currently registered EventListener on the EventTarget has no effect.
			@param type Specifies the event type of the EventListener being removed.
			@param listener The EventListener parameter indicates the EventListener
		 to be removed.
			@param useCapture Specifies whether the EventListener being removed was
		 registered as a capturing listener or not. If a listener was registered
		 twice, one with capture and one without, each must be removed
		 separately. Removal of a capturing listener does not affect a
		 non-capturing version of the same listener, and vice versa.
		     		@short    Introduced in DOM Level 2  This method is from the EventTarget interface
	*/
	public native void removeEventListener(String type, EventListener listener, boolean useCapture);
	/**	
		 Introduced in DOM Level 2
		 This method is from the EventTarget interface
			 This method allows the dispatch of events into the implementations event
		 model. Events dispatched in this manner will have the same capturing and
		 bubbling behavior as events dispatched directly by the implementation.
		 The target of the event is the EventTarget on which dispatchEvent is
		 called.
			@param evt Specifies the event type, behavior, and contextual
		 information to be used in processing the event.
				@return The return value of dispatchEvent indicates whether any of the
 listeners which handled the event called preventDefault. If
 preventDefault was called the value is false, else the value is true.

		@short    Introduced in DOM Level 2  This method is from the EventTarget interface
	*/
	public native boolean dispatchEvent(Event evt);
	/**	
			 not part of the DOM.
				@return the element id, in case this is an element, 0 otherwise
     
		@short
	*/
	public native int elementId();
	/**	
		 tests if this Node is 0. Useful especially, if casting to a derived
		 class:
			 <pre>
		 Node n = .....;
		 // try to convert into an Element:
		 Element e = n;
		 if( e.isNull() )
		   kdDebug(300) << "node isn't an element node" << endl;
		 </pre>
		     		@short    tests if this Node is 0.
	*/
	public native boolean isNull();
	/**	
			     		@short
	*/
	// DOM::NodeImpl* handle(); >>>> NOT CONVERTED
	/**	
			     		@short
	*/
	public native long index();
	public native void applyChanges();
	/**	
		 not part of the DOM.
				@return the exact coordinates and size of this element.
     
		@short    not part of the DOM.
	*/
	public native QRect getRect();
}
