/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities;

import sun.jvm.hotspot.oops.HeapVisitor;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.utilities.HeapProgressThunk;

public class ProgressiveHeapVisitor
implements HeapVisitor {
    private HeapVisitor userHeapVisitor;
    private HeapProgressThunk thunk;
    private long usedSize;
    private long visitedSize;
    private double lastNotificationFraction;
    private static double MINIMUM_NOTIFICATION_FRACTION = 0.01;

    public ProgressiveHeapVisitor(HeapVisitor userHeapVisitor, HeapProgressThunk thunk) {
        this.userHeapVisitor = userHeapVisitor;
        this.thunk = thunk;
    }

    public void prologue(long usedSize) {
        this.usedSize = usedSize;
        this.visitedSize = 0L;
        this.userHeapVisitor.prologue(usedSize);
    }

    public boolean doObj(Oop obj) {
        this.userHeapVisitor.doObj(obj);
        this.visitedSize += obj.getObjectSize();
        double curFrac = (double)this.visitedSize / (double)this.usedSize;
        if (curFrac > this.lastNotificationFraction + MINIMUM_NOTIFICATION_FRACTION) {
            this.thunk.heapIterationFractionUpdate(curFrac);
            this.lastNotificationFraction = curFrac;
        }
        return false;
    }

    public void epilogue() {
        this.userHeapVisitor.epilogue();
        this.thunk.heapIterationComplete();
    }
}

