/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import java.io.PrintStream;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.memory.MemRegion;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public abstract class Space
extends VMObject {
    private static AddressField bottomField;
    private static AddressField endField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("Space");
        bottomField = type.getAddressField("_bottom");
        endField = type.getAddressField("_end");
    }

    public Space(Address addr) {
        super(addr);
    }

    public Address bottom() {
        return bottomField.getValue(this.addr);
    }

    public Address end() {
        return endField.getValue(this.addr);
    }

    public MemRegion usedRegion() {
        return new MemRegion(this.bottom(), this.end());
    }

    public OopHandle bottomAsOopHandle() {
        return bottomField.getOopHandle(this.addr);
    }

    public OopHandle nextOopHandle(OopHandle handle, long size) {
        return handle.addOffsetToAsOopHandle(size);
    }

    public abstract List getLiveRegions();

    public long capacity() {
        return this.end().minus(this.bottom());
    }

    public abstract long used();

    public abstract long free();

    public boolean contains(Address p) {
        return this.bottom().lessThanOrEqual(p) && this.end().greaterThan(p);
    }

    public void print() {
        this.printOn(System.out);
    }

    public void printOn(PrintStream tty) {
        tty.print(" space capacity = ");
        tty.print(this.capacity());
        tty.print(", ");
        tty.print((double)this.used() * 100.0 / (double)this.capacity());
        tty.print(" used");
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                Space.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

