/*
 *	The PCI Library -- Access to i386 I/O ports on Windows
 *
 *	Copyright (c) 2004 Alexander Stock <stock.alexander@gmx.de>
 *	Copyright (c) 2006 Martin Mares <mj@ucw.cz>
 *
 *	Can be freely distributed and used under the terms of the GNU GPL.
 */

#include <io.h>
#include <conio.h>
#include <windows.h>

#define outb(x,y) _outp(y,x)
#define outw(x,y) _outpw(y,x)
#define outl(x,y) _outpd(y,x)

#define inb(x) _inp(x)
#define inw(x) _inpw(x)
#define inl(x) _inpd(x)

static int
intel_setup_io(struct pci_access *a)
{
  typedef int (*MYPROC)(void);
  MYPROC InitializeWinIo;
  HMODULE lib;

  intel_iopl_set = 0;

  lib = LoadLibrary("WinIo.dll");
  if (!lib)
    {
      a->warning("i386-io-windows: Couldn't load WinIo.dll.");
      return 0;
    }
  /* XXX: Is this really needed? --mj */
  GetProcAddress(lib, "InitializeWinIo");

  InitializeWinIo = (MYPROC) GetProcAddress(lib, "InitializeWinIo");
  if (!InitializeWinIo)
    {
      a->warning("i386-io-windows: Couldn't find InitializeWinIo function.");
      return 0;
    }

  if (!InitializeWinIo())
    {
      a->warning("i386-io-windows: InitializeWinIo() failed.");
      return 0;
    }

  return 1;
}

static inline int
intel_cleanup_io(struct pci_access *a UNUSED)
{
  //TODO: DeInitializeWinIo!
  return 1;
}
