/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import java.net.SocketAddress;

public class InetSocketAddress
extends SocketAddress {
    private static final long serialVersionUID = 5076001401234631237L;
    private String hostname;
    private InetAddress addr;
    private int port;

    public InetSocketAddress(InetAddress addr, int port) throws IllegalArgumentException {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Bad port number: " + port);
        }
        if (addr == null) {
            addr = InetAddress.ANY_IF;
        }
        this.addr = addr;
        this.port = port;
        this.hostname = addr.getHostName();
    }

    public InetSocketAddress(int port) throws IllegalArgumentException {
        this((InetAddress)null, port);
    }

    public InetSocketAddress(String hostname, int port) throws IllegalArgumentException {
        if (hostname == null) {
            throw new IllegalArgumentException("Null host name value");
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Bad port number: " + port);
        }
        this.port = port;
        this.hostname = hostname;
        try {
            this.addr = InetAddress.getByName(hostname);
        }
        catch (Exception e) {
            this.addr = null;
        }
    }

    public final boolean equals(Object obj) {
        if (obj instanceof InetSocketAddress) {
            InetSocketAddress sa = (InetSocketAddress)obj;
            if (this.addr == null && sa.addr != null) {
                return false;
            }
            if (this.addr == null && sa.addr == null) {
                return this.hostname.equals(sa.hostname) && sa.port == this.port;
            }
            return this.addr.equals(sa.addr) && sa.port == this.port;
        }
        return false;
    }

    public final InetAddress getAddress() {
        return this.addr;
    }

    public final String getHostName() {
        return this.hostname;
    }

    public final int getPort() {
        return this.port;
    }

    public final int hashCode() {
        return this.port + this.addr.hashCode();
    }

    public final boolean isUnresolved() {
        return this.addr == null;
    }

    public String toString() {
        return (this.addr == null ? this.hostname : this.addr.getHostName()) + ":" + this.port;
    }
}

