/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.jar;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;

public final class Connection
extends JarURLConnection {
    private static Hashtable file_cache = new Hashtable();
    private JarFile jar_file;
    static HashMap connectionCache = new HashMap();
    private Hashtable hdrHash;
    private Vector hdrVec;
    private boolean gotHeaders;

    private /* synthetic */ void finit$() {
        this.hdrHash = new Hashtable();
        this.hdrVec = new Vector();
        this.gotHeaders = false;
    }

    protected Connection(URL url) throws MalformedURLException {
        super(url);
        this.finit$();
    }

    public synchronized void connect() throws IOException {
        if (this.connected) {
            return;
        }
        if (this.getUseCaches()) {
            this.jarFileURLConnection = (URLConnection)connectionCache.get(this.getJarFileURL());
            if (this.jarFileURLConnection == null) {
                this.jarFileURLConnection = this.getJarFileURL().openConnection();
                this.jarFileURLConnection.setUseCaches(true);
                this.jarFileURLConnection.connect();
                connectionCache.put(this.getJarFileURL(), this.jarFileURLConnection);
            }
        } else {
            this.jarFileURLConnection = this.getJarFileURL().openConnection();
            this.jarFileURLConnection.connect();
        }
        this.connected = true;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (!this.doInput) {
            throw new ProtocolException("Can't open InputStream if doInput is false");
        }
        if (this.getEntryName() == null) {
            BufferedInputStream in = new BufferedInputStream(this.jarFileURLConnection.getInputStream());
            return new JarInputStream(in);
        }
        JarFile jarfile = null;
        try {
            jarfile = this.getJarFile();
        }
        catch (IOException x) {
            // empty catch block
        }
        if (jarfile != null) {
            ZipEntry entry = jarfile.getEntry(this.getEntryName());
            if (entry != null) {
                return jarfile.getInputStream(entry);
            }
            return null;
        }
        JarInputStream zis = new JarInputStream(this.jarFileURLConnection.getInputStream());
        ZipEntry entry = zis.getNextEntry();
        while (entry != null) {
            if (this.getEntryName().equals(entry.getName())) {
                int size = (int)entry.getSize();
                byte[] data = new byte[size];
                zis.read(data, 0, size);
                return new ByteArrayInputStream(data);
            }
            entry = zis.getNextEntry();
        }
        return null;
    }

    public synchronized JarFile getJarFile() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (!this.doInput) {
            throw new ProtocolException("Can't open JarFile if doInput is false");
        }
        if (this.jar_file != null) {
            return this.jar_file;
        }
        URL jarFileURL = this.getJarFileURL();
        if (jarFileURL.getProtocol().equals("file") && jarFileURL.getHost().equals("")) {
            if (this.getUseCaches()) {
                this.jar_file = (JarFile)file_cache.get(jarFileURL);
                if (this.jar_file == null) {
                    this.jar_file = new JarFile(jarFileURL.getFile());
                    file_cache.put(jarFileURL, this.jar_file);
                }
            } else {
                this.jar_file = new JarFile(jarFileURL.getFile());
            }
        } else {
            URLConnection urlconn = jarFileURL.openConnection();
            InputStream is = urlconn.getInputStream();
            byte[] buf = new byte[4096];
            File f = File.createTempFile("cache", "jar");
            FileOutputStream fos = new FileOutputStream(f);
            int len = 0;
            while ((len = is.read(buf)) != -1) {
                fos.write(buf, 0, len);
            }
            fos.close();
            this.jar_file = new JarFile(f, true, 1);
        }
        return this.jar_file;
    }

    public String getHeaderField(String name) {
        try {
            this.getHeaders();
        }
        catch (IOException x) {
            return null;
        }
        return (String)this.hdrHash.get(name.toLowerCase());
    }

    public Map getHeaderFields() {
        try {
            this.getHeaders();
        }
        catch (IOException x) {
            return null;
        }
        return this.hdrHash;
    }

    public String getHeaderField(int n) {
        try {
            this.getHeaders();
        }
        catch (IOException x) {
            return null;
        }
        if (n < this.hdrVec.size()) {
            return this.getField((String)this.hdrVec.elementAt(n));
        }
        return null;
    }

    public String getHeaderFieldKey(int n) {
        try {
            this.getHeaders();
        }
        catch (IOException x) {
            return null;
        }
        if (n < this.hdrVec.size()) {
            return this.getKey((String)this.hdrVec.elementAt(n));
        }
        return null;
    }

    private String getKey(String str) {
        if (str == null) {
            return null;
        }
        int index = str.indexOf(58);
        if (index >= 0) {
            return str.substring(0, index);
        }
        return null;
    }

    private String getField(String str) {
        if (str == null) {
            return null;
        }
        int index = str.indexOf(58);
        if (index >= 0) {
            return str.substring(index + 1).trim();
        }
        return str;
    }

    private void getHeaders() throws IOException {
        if (this.gotHeaders) {
            return;
        }
        this.gotHeaders = true;
        this.connect();
        long len = -1;
        if (this.getEntryName() == null) {
            if (this.jarFileURLConnection != null) {
                len = this.jarFileURLConnection.getContentLength();
            } else {
                JarEntry entry = this.getJarEntry();
                if (entry != null) {
                    len = entry.getSize();
                }
            }
        }
        String line = "Content-length: " + len;
        this.hdrVec.addElement(line);
        String key = this.getKey(line);
        this.hdrHash.put(key.toLowerCase(), Long.toString(len));
    }
}

