/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.oops.OopVisitor;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class CompiledICHolder
extends Oop {
    private static long headerSize;
    private static OopField holderMethod;
    private static OopField holderKlass;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("compiledICHolderOopDesc");
        holderMethod = new OopField(type.getOopField("_holder_method"), 0L);
        holderKlass = new OopField(type.getOopField("_holder_klass"), 0L);
        headerSize = type.getSize();
    }

    CompiledICHolder(OopHandle handle, ObjectHeap heap) {
        super(handle, heap);
    }

    public boolean isCompiledICHolder() {
        return true;
    }

    public Method getHolderMethod() {
        return (Method)holderMethod.getValue(this);
    }

    public Klass getHolderKlass() {
        return (Klass)holderKlass.getValue(this);
    }

    public void printValueOn(PrintStream tty) {
        tty.print("CompiledICHolder");
    }

    public long getObjectSize() {
        return CompiledICHolder.alignObjectSize(headerSize);
    }

    void iterateFields(OopVisitor visitor, boolean doVMFields) {
        super.iterateFields(visitor, doVMFields);
        if (doVMFields) {
            visitor.doOop(holderMethod, true);
            visitor.doOop(holderKlass, true);
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                CompiledICHolder.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

