/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.rmi.server.LogStream;
import java.rmi.server.RMIFailureHandler;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UID;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.WeakHashMap;
import sun.rmi.runtime.Log;
import sun.rmi.runtime.NewThreadAction;
import sun.rmi.transport.Channel;
import sun.rmi.transport.Connection;
import sun.rmi.transport.DGCAckHandler;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.StreamRemoteCall;
import sun.rmi.transport.Target;
import sun.rmi.transport.Transport;
import sun.rmi.transport.proxy.HttpReceiveSocket;
import sun.rmi.transport.tcp.ConnectionMultiplexer;
import sun.rmi.transport.tcp.TCPChannel;
import sun.rmi.transport.tcp.TCPConnection;
import sun.rmi.transport.tcp.TCPEndpoint;
import sun.security.action.GetIntegerAction;
import sun.security.action.GetPropertyAction;

public class TCPTransport
extends Transport
implements Runnable {
    static final int logLevel = LogStream.parseLevel(TCPTransport.getLogLevel());
    static final Log tcpLog = Log.getLog("sun.rmi.transport.tcp", "tcp", logLevel);
    private static int threadNum = 0;
    private static final ThreadLocal threadConnectionHandler = new ThreadLocal();
    private final LinkedList epList;
    private ServerSocket server = null;
    private final Map<TCPEndpoint, Reference<TCPChannel>> channelTable = new WeakHashMap<TCPEndpoint, Reference<TCPChannel>>();
    static final RMISocketFactory defaultSocketFactory = RMISocketFactory.getDefaultSocketFactory();
    private static final int connectionReadTimeout = (Integer)AccessController.doPrivileged(new GetIntegerAction("sun.rmi.transport.tcp.readTimeout", 0x6DDD00));
    private transient long acceptFailureTime = 0L;
    private transient int acceptFailureCount;

    private static String getLogLevel() {
        return (String)AccessController.doPrivileged(new GetPropertyAction("sun.rmi.transport.tcp.logLevel"));
    }

    TCPTransport(LinkedList linkedList) {
        this.epList = linkedList;
        if (tcpLog.isLoggable(Log.BRIEF)) {
            tcpLog.log(Log.BRIEF, "Version = 2, ep = " + this.getEndpoint());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shedConnectionCaches() {
        ArrayList<TCPChannel> arrayList;
        Map<TCPEndpoint, Reference<TCPChannel>> map = this.channelTable;
        synchronized (map) {
            arrayList = new ArrayList<TCPChannel>(this.channelTable.values().size());
            for (Reference<TCPChannel> reference : this.channelTable.values()) {
                TCPChannel tCPChannel = reference.get();
                if (tCPChannel == null) continue;
                arrayList.add(tCPChannel);
            }
        }
        for (TCPChannel tCPChannel : arrayList) {
            tCPChannel.shedCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel getChannel(Endpoint endpoint) {
        TCPChannel tCPChannel = null;
        if (endpoint instanceof TCPEndpoint) {
            Map<TCPEndpoint, Reference<TCPChannel>> map = this.channelTable;
            synchronized (map) {
                Reference<TCPChannel> reference = this.channelTable.get(endpoint);
                if (reference != null) {
                    tCPChannel = reference.get();
                }
                if (tCPChannel == null) {
                    TCPEndpoint tCPEndpoint = (TCPEndpoint)endpoint;
                    tCPChannel = new TCPChannel(this, tCPEndpoint);
                    this.channelTable.put(tCPEndpoint, new WeakReference<TCPChannel>(tCPChannel));
                }
            }
        }
        return tCPChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free(Endpoint endpoint) {
        if (endpoint instanceof TCPEndpoint) {
            Map<TCPEndpoint, Reference<TCPChannel>> map = this.channelTable;
            synchronized (map) {
                TCPChannel tCPChannel;
                Reference<TCPChannel> reference = this.channelTable.remove(endpoint);
                if (reference != null && (tCPChannel = reference.get()) != null) {
                    tCPChannel.shedCache();
                }
            }
        }
    }

    public void exportObject(Target target) throws RemoteException {
        this.listen();
        target.setExportedTransport(this);
        super.exportObject(target);
    }

    protected void checkAcceptPermission(AccessControlContext accessControlContext) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        ConnectionHandler connectionHandler = (ConnectionHandler)threadConnectionHandler.get();
        if (connectionHandler == null) {
            throw new Error("checkAcceptPermission not in ConnectionHandler thread");
        }
        connectionHandler.checkAcceptPermission(securityManager, accessControlContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TCPEndpoint getEndpoint() {
        LinkedList linkedList = this.epList;
        synchronized (linkedList) {
            return (TCPEndpoint)this.epList.getLast();
        }
    }

    private synchronized void listen() throws RemoteException {
        TCPEndpoint tCPEndpoint = this.getEndpoint();
        int n = tCPEndpoint.getPort();
        if (this.server == null) {
            if (tcpLog.isLoggable(Log.BRIEF)) {
                tcpLog.log(Log.BRIEF, "(port " + n + ") create server socket");
            }
            try {
                this.server = tCPEndpoint.newServerSocket();
                Thread thread = (Thread)AccessController.doPrivileged(new NewThreadAction(this, "TCP Accept-" + n, true));
                thread.start();
            }
            catch (BindException bindException) {
                throw new ExportException("Port already in use: " + n, bindException);
            }
            catch (IOException iOException) {
                throw new ExportException("Listen failed on port: " + n, iOException);
            }
        } else {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkListen(n);
            }
        }
    }

    private synchronized boolean continueAfterAcceptFailure(Throwable throwable) {
        boolean bl;
        RMIFailureHandler rMIFailureHandler = RMISocketFactory.getFailureHandler();
        if (rMIFailureHandler != null) {
            bl = throwable instanceof Exception ? rMIFailureHandler.failure((Exception)throwable) : rMIFailureHandler.failure(new InvocationTargetException(throwable));
        } else {
            long l = System.currentTimeMillis();
            if (this.acceptFailureTime == 0L || l - this.acceptFailureTime > 5000L) {
                this.acceptFailureTime = l;
                this.acceptFailureCount = 0;
            } else {
                ++this.acceptFailureCount;
                if (this.acceptFailureCount >= 10) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void run() {
        if (TCPTransport.tcpLog.isLoggable(Log.BRIEF)) {
            TCPTransport.tcpLog.log(Log.BRIEF, "listening on port " + this.getEndpoint().getPort());
        }
        while (true) {
            if ((var1_1 = this.server) == null) {
                return;
            }
            var2_2 /* !! */  = null;
            try {
                var3_3 = var1_1.accept();
                var4_4 = var3_3.getInetAddress();
                var5_16 = var4_4 != null ? var4_4.getHostAddress() : "0.0.0.0";
                var6_17 = (Thread)AccessController.doPrivileged(new NewThreadAction(new ConnectionHandler(var3_3, var5_16), "TCP Connection(" + ++TCPTransport.threadNum + ")-" + var5_16, true, true));
                var6_17.start();
                continue;
            }
            catch (IOException var4_7) {
                var2_2 /* !! */  = var4_7;
            }
            catch (RuntimeException var4_10) {
                var2_2 /* !! */  = var4_10;
            }
            catch (Error var4_13) {
                var2_2 /* !! */  = var4_13;
            }
            finally {
                if (var2_2 /* !! */  == null) continue;
                if (!(var2_2 /* !! */  instanceof SecurityException)) {
                    try {
                        TCPEndpoint.shedConnectionCaches();
                    }
                    catch (OutOfMemoryError var4_8) {
                    }
                    catch (Exception var4_9) {}
                }
                if (var2_2 /* !! */  instanceof IOException || var2_2 /* !! */  instanceof OutOfMemoryError || var2_2 /* !! */  instanceof NoClassDefFoundError || var2_2 /* !! */  instanceof MissingResourceException || var2_2 /* !! */  instanceof SecurityException) {
                    if (!this.continueAfterAcceptFailure(var2_2 /* !! */ )) ** break;
                    continue;
                    return;
                }
                if (var2_2 /* !! */  instanceof RuntimeException) {
                    throw (RuntimeException)var2_2 /* !! */ ;
                }
                throw (Error)var2_2 /* !! */ ;
            }
            break;
        }
    }

    private static void closeSocket(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleMessages(Connection connection, boolean bl) {
        int n = this.getEndpoint().getPort();
        try {
            DataInputStream dataInputStream = new DataInputStream(connection.getInputStream());
            block19: do {
                int n2;
                if ((n2 = dataInputStream.read()) == -1) {
                    if (tcpLog.isLoggable(Log.BRIEF)) {
                        tcpLog.log(Log.BRIEF, "(port " + n + ") connection closed");
                    }
                    break;
                }
                if (tcpLog.isLoggable(Log.BRIEF)) {
                    tcpLog.log(Log.BRIEF, "(port " + n + ") op = " + n2);
                }
                switch (n2) {
                    case 80: {
                        StreamRemoteCall streamRemoteCall = new StreamRemoteCall(connection);
                        if (this.serviceCall(streamRemoteCall)) continue block19;
                        return;
                    }
                    case 82: {
                        DataOutputStream dataOutputStream = new DataOutputStream(connection.getOutputStream());
                        dataOutputStream.writeByte(83);
                        connection.releaseOutputStream();
                        break;
                    }
                    case 84: {
                        DGCAckHandler.received(UID.read(dataInputStream));
                        break;
                    }
                    default: {
                        throw new IOException("unknown transport op " + n2);
                    }
                }
            } while (bl);
        }
        catch (IOException iOException) {
            if (tcpLog.isLoggable(Log.BRIEF)) {
                tcpLog.log(Log.BRIEF, "(port " + n + ") exception: ", iOException);
            }
        }
        finally {
            try {
                connection.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String getClientHost() throws ServerNotActiveException {
        ConnectionHandler connectionHandler = (ConnectionHandler)threadConnectionHandler.get();
        if (connectionHandler != null) {
            return connectionHandler.getClientHost();
        }
        throw new ServerNotActiveException("not in a remote call");
    }

    private class ConnectionHandler
    implements Runnable {
        private static final int POST = 1347375956;
        private AccessControlContext okContext;
        private WeakHashMap authCache;
        private SecurityManager cacheSecurityManager = null;
        private Socket socket;
        private String remoteHost;

        ConnectionHandler(Socket socket, String string) {
            this.socket = socket;
            this.remoteHost = string;
        }

        String getClientHost() {
            return this.remoteHost;
        }

        void checkAcceptPermission(SecurityManager securityManager, AccessControlContext accessControlContext) {
            if (securityManager != this.cacheSecurityManager) {
                this.okContext = null;
                this.authCache = new WeakHashMap();
                this.cacheSecurityManager = securityManager;
            }
            if (accessControlContext.equals(this.okContext) || this.authCache.containsKey(accessControlContext)) {
                return;
            }
            InetAddress inetAddress = this.socket.getInetAddress();
            String string = inetAddress != null ? inetAddress.getHostAddress() : "*";
            securityManager.checkAccept(string, this.socket.getPort());
            this.authCache.put(accessControlContext, new SoftReference<AccessControlContext>(accessControlContext));
            this.okContext = accessControlContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            TCPEndpoint tCPEndpoint = TCPTransport.this.getEndpoint();
            int n = tCPEndpoint.getPort();
            threadConnectionHandler.set(this);
            try {
                this.socket.setTcpNoDelay(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (connectionReadTimeout > 0) {
                    this.socket.setSoTimeout(connectionReadTimeout);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                InputStream inputStream = this.socket.getInputStream();
                InputStream inputStream2 = inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream);
                inputStream2.mark(4);
                DataInputStream dataInputStream = new DataInputStream(inputStream2);
                int n2 = dataInputStream.readInt();
                if (n2 == 1347375956) {
                    tcpLog.log(Log.BRIEF, "decoding HTTP-wrapped call");
                    inputStream2.reset();
                    try {
                        this.socket = new HttpReceiveSocket(this.socket, inputStream2, null);
                        this.remoteHost = "0.0.0.0";
                        inputStream = this.socket.getInputStream();
                        inputStream2 = new BufferedInputStream(inputStream);
                        dataInputStream = new DataInputStream(inputStream2);
                        n2 = dataInputStream.readInt();
                    }
                    catch (IOException iOException) {
                        throw new RemoteException("Error HTTP-unwrapping call", iOException);
                    }
                }
                short s = dataInputStream.readShort();
                if (n2 != 1246907721 || s != 2) {
                    TCPTransport.closeSocket(this.socket);
                    return;
                }
                OutputStream outputStream = this.socket.getOutputStream();
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
                DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
                int n3 = this.socket.getPort();
                if (tcpLog.isLoggable(Log.BRIEF)) {
                    tcpLog.log(Log.BRIEF, "accepted socket from [" + this.remoteHost + ":" + n3 + "]");
                }
                byte by = dataInputStream.readByte();
                switch (by) {
                    case 76: {
                        TCPEndpoint tCPEndpoint2 = new TCPEndpoint(this.remoteHost, this.socket.getLocalPort(), tCPEndpoint.getClientSocketFactory(), tCPEndpoint.getServerSocketFactory());
                        TCPChannel tCPChannel = new TCPChannel(TCPTransport.this, tCPEndpoint2);
                        TCPConnection tCPConnection = new TCPConnection(tCPChannel, this.socket, inputStream2, bufferedOutputStream);
                        TCPTransport.this.handleMessages(tCPConnection, false);
                        return;
                    }
                    case 75: {
                        dataOutputStream.writeByte(78);
                        if (tcpLog.isLoggable(Log.VERBOSE)) {
                            tcpLog.log(Log.VERBOSE, "(port " + n + ") " + "suggesting " + this.remoteHost + ":" + n3);
                        }
                        dataOutputStream.writeUTF(this.remoteHost);
                        dataOutputStream.writeInt(n3);
                        dataOutputStream.flush();
                        String string = dataInputStream.readUTF();
                        int n4 = dataInputStream.readInt();
                        if (tcpLog.isLoggable(Log.VERBOSE)) {
                            tcpLog.log(Log.VERBOSE, "(port " + n + ") client using " + string + ":" + n4);
                        }
                        TCPEndpoint tCPEndpoint3 = new TCPEndpoint(this.remoteHost, this.socket.getLocalPort(), tCPEndpoint.getClientSocketFactory(), tCPEndpoint.getServerSocketFactory());
                        TCPChannel tCPChannel = new TCPChannel(TCPTransport.this, tCPEndpoint3);
                        TCPConnection tCPConnection = new TCPConnection(tCPChannel, this.socket, inputStream2, bufferedOutputStream);
                        TCPTransport.this.handleMessages(tCPConnection, true);
                        return;
                    }
                    case 77: {
                        ConnectionMultiplexer connectionMultiplexer;
                        if (tcpLog.isLoggable(Log.VERBOSE)) {
                            tcpLog.log(Log.VERBOSE, "(port " + n + ") accepting multiplex protocol");
                        }
                        dataOutputStream.writeByte(78);
                        if (tcpLog.isLoggable(Log.VERBOSE)) {
                            tcpLog.log(Log.VERBOSE, "(port " + n + ") suggesting " + this.remoteHost + ":" + n3);
                        }
                        dataOutputStream.writeUTF(this.remoteHost);
                        dataOutputStream.writeInt(n3);
                        dataOutputStream.flush();
                        TCPEndpoint tCPEndpoint4 = new TCPEndpoint(dataInputStream.readUTF(), dataInputStream.readInt(), tCPEndpoint.getClientSocketFactory(), tCPEndpoint.getServerSocketFactory());
                        if (tcpLog.isLoggable(Log.VERBOSE)) {
                            tcpLog.log(Log.VERBOSE, "(port " + n + ") client using " + tCPEndpoint4.getHost() + ":" + tCPEndpoint4.getPort());
                        }
                        Map map = TCPTransport.this.channelTable;
                        synchronized (map) {
                            TCPChannel tCPChannel = (TCPChannel)TCPTransport.this.getChannel(tCPEndpoint4);
                            connectionMultiplexer = new ConnectionMultiplexer(tCPChannel, inputStream2, outputStream, false);
                            tCPChannel.useMultiplexer(connectionMultiplexer);
                        }
                        connectionMultiplexer.run();
                        return;
                    }
                    default: {
                        dataOutputStream.writeByte(79);
                        dataOutputStream.flush();
                        return;
                    }
                }
            }
            catch (IOException iOException) {
                tcpLog.log(Log.BRIEF, "terminated with exception:", iOException);
                return;
            }
            finally {
                TCPTransport.closeSocket(this.socket);
            }
        }
    }
}

