/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.gopher;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.AccessController;
import sun.net.NetworkClient;
import sun.net.www.MessageHeader;
import sun.net.www.URLConnection;
import sun.net.www.protocol.gopher.GopherInputStream;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetIntegerAction;
import sun.security.action.GetPropertyAction;

public class GopherClient
extends NetworkClient
implements Runnable {
    @Deprecated
    public static boolean useGopherProxy;
    @Deprecated
    public static String gopherProxyHost;
    @Deprecated
    public static int gopherProxyPort;
    PipedOutputStream os;
    URL u;
    int gtype;
    String gkey;
    URLConnection connection;

    GopherClient(URLConnection uRLConnection) {
        this.connection = uRLConnection;
    }

    public static boolean getUseGopherProxy() {
        return (Boolean)AccessController.doPrivileged(new GetBooleanAction("gopherProxySet"));
    }

    public static String getGopherProxyHost() {
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("gopherProxyHost"));
        if ("".equals(string)) {
            string = null;
        }
        return string;
    }

    public static int getGopherProxyPort() {
        return (Integer)AccessController.doPrivileged(new GetIntegerAction("gopherProxyPort", 80));
    }

    InputStream openStream(URL uRL) throws IOException {
        int n;
        this.u = uRL;
        this.os = this.os;
        String string = uRL.getFile();
        int n2 = string.length();
        int n3 = 49;
        for (n = 0; n < n2; ++n) {
            char c = string.charAt(n);
            n3 = c;
            if (c != '/') break;
        }
        int n4 = this.gtype = n3 == 47 ? 49 : n3;
        if (n < n2) {
            ++n;
        }
        this.gkey = string.substring(n);
        this.openServer(uRL.getHost(), uRL.getPort() <= 0 ? 70 : uRL.getPort());
        MessageHeader messageHeader = new MessageHeader();
        switch (this.gtype) {
            case 48: 
            case 55: {
                messageHeader.add("content-type", "text/plain");
                break;
            }
            case 49: {
                messageHeader.add("content-type", "text/html");
                break;
            }
            case 73: 
            case 103: {
                messageHeader.add("content-type", "image/gif");
                break;
            }
            default: {
                messageHeader.add("content-type", "content/unknown");
            }
        }
        if (this.gtype != 55) {
            this.serverOutput.print(this.decodePercent(this.gkey) + "\r\n");
            this.serverOutput.flush();
        } else {
            n = this.gkey.indexOf(63);
            if (n >= 0) {
                this.serverOutput.print(this.decodePercent(this.gkey.substring(0, n) + "\t" + this.gkey.substring(n + 1) + "\r\n"));
                this.serverOutput.flush();
                messageHeader.add("content-type", "text/html");
            } else {
                messageHeader.add("content-type", "text/html");
            }
        }
        this.connection.setProperties(messageHeader);
        if (messageHeader.findValue("content-type") == "text/html") {
            this.os = new PipedOutputStream();
            PipedInputStream pipedInputStream = new PipedInputStream();
            pipedInputStream.connect(this.os);
            new Thread(this).start();
            return pipedInputStream;
        }
        return new GopherInputStream(this, this.serverInput);
    }

    private String decodePercent(String string) {
        if (string == null || string.indexOf(37) < 0) {
            return string;
        }
        int n = string.length();
        char[] cArray = new char[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = string.charAt(i);
            if (n3 == 37 && i + 2 < n) {
                int n4 = string.charAt(i + 1);
                int n5 = string.charAt(i + 2);
                n4 = 48 <= n4 && n4 <= 57 ? (n4 -= 48) : (97 <= n4 && n4 <= 102 ? n4 - 97 + 10 : (65 <= n4 && n4 <= 70 ? n4 - 65 + 10 : -1));
                n5 = 48 <= n5 && n5 <= 57 ? (n5 -= 48) : (97 <= n5 && n5 <= 102 ? n5 - 97 + 10 : (65 <= n5 && n5 <= 70 ? n5 - 65 + 10 : -1));
                if (n4 >= 0 && n5 >= 0) {
                    n3 = n4 << 4 | n5;
                    i += 2;
                }
            }
            cArray[n2++] = (char)n3;
        }
        return new String(cArray, 0, n2);
    }

    private String encodePercent(String string) {
        if (string == null) {
            return string;
        }
        int n = string.length();
        char[] cArray = null;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c <= ' ' || c == '\"' || c == '%') {
                if (cArray == null) {
                    cArray = string.toCharArray();
                }
                if (n2 + 3 >= cArray.length) {
                    char[] cArray2 = new char[n2 + 10];
                    System.arraycopy(cArray, 0, cArray2, 0, n2);
                    cArray = cArray2;
                }
                cArray[n2] = 37;
                int n3 = c >> 4 & 0xF;
                cArray[n2 + 1] = (char)(n3 < 10 ? 48 + n3 : 55 + n3);
                n3 = c & 0xF;
                cArray[n2 + 2] = (char)(n3 < 10 ? 48 + n3 : 55 + n3);
                n2 += 3;
                continue;
            }
            if (cArray != null) {
                if (n2 >= cArray.length) {
                    char[] cArray3 = new char[n2 + 10];
                    System.arraycopy(cArray, 0, cArray3, 0, n2);
                    cArray = cArray3;
                }
                cArray[n2] = c;
            }
            ++n2;
        }
        return cArray == null ? string : new String(cArray, 0, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block24: {
            int n = -1;
            try {
                String string;
                if (this.gtype == 55 && (n = this.gkey.indexOf(63)) < 0) {
                    PrintStream printStream = new PrintStream(this.os, false, encoding);
                    printStream.print("<html><head><title>Searchable Gopher Index</title></head>\n<body><h1>Searchable Gopher Index</h1><isindex>\n</body></html>\n");
                    break block24;
                }
                if (this.gtype != 49 && this.gtype != 55) {
                    byte[] byArray = new byte[2048];
                    try {
                        int n2;
                        while ((n2 = this.serverInput.read(byArray)) >= 0) {
                            this.os.write(byArray, 0, n2);
                        }
                        break block24;
                    }
                    catch (Exception exception) {
                        break block24;
                    }
                }
                PrintStream printStream = new PrintStream(this.os, false, encoding);
                String string2 = null;
                string2 = this.gtype == 55 ? "Results of searching for \"" + this.gkey.substring(n + 1) + "\" on " + this.u.getHost() : "Gopher directory " + this.gkey + " from " + this.u.getHost();
                printStream.print("<html><head><title>");
                printStream.print(string2);
                printStream.print("</title></head>\n<body>\n<H1>");
                printStream.print(string2);
                printStream.print("</h1><dl compact>\n");
                DataInputStream dataInputStream = new DataInputStream(this.serverInput);
                while ((string = dataInputStream.readLine()) != null) {
                    int n3;
                    for (n3 = string.length(); n3 > 0 && string.charAt(n3 - 1) <= ' '; --n3) {
                    }
                    if (n3 <= 0) continue;
                    char c = string.charAt(0);
                    int n4 = string.indexOf(9);
                    int n5 = n4 > 0 ? string.indexOf(9, n4 + 1) : -1;
                    int n6 = n5 > 0 ? string.indexOf(9, n5 + 1) : -1;
                    if (n6 < 0) continue;
                    String string3 = n6 + 1 < n3 ? ":" + string.substring(n6 + 1, n3) : "";
                    String string4 = n5 + 1 < n6 ? string.substring(n5 + 1, n6) : this.u.getHost();
                    printStream.print("<dt><a href=\"gopher://" + string4 + string3 + "/" + string.substring(0, 1) + this.encodePercent(string.substring(n4 + 1, n5)) + "\">\n");
                    printStream.print("<img align=middle border=0 width=25 height=32 src=");
                    switch (c) {
                        default: {
                            printStream.print(System.getProperty("java.net.ftp.imagepath.file"));
                            break;
                        }
                        case '0': {
                            printStream.print(System.getProperty("java.net.ftp.imagepath.text"));
                            break;
                        }
                        case '1': {
                            printStream.print(System.getProperty("java.net.ftp.imagepath.directory"));
                            break;
                        }
                        case 'g': {
                            printStream.print(System.getProperty("java.net.ftp.imagepath.gif"));
                        }
                    }
                    printStream.print(".gif align=middle><dd>\n");
                    printStream.print(string.substring(1, n4) + "</a>\n");
                }
                printStream.print("</dl></body>\n");
                printStream.close();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new InternalError(encoding + " encoding not found");
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    this.closeServer();
                    this.os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static {
        Boolean bl = (Boolean)AccessController.doPrivileged(new GetBooleanAction("gopherProxySet"));
        useGopherProxy = bl;
        gopherProxyHost = (String)AccessController.doPrivileged(new GetPropertyAction("gopherProxyHost"));
        gopherProxyPort = (Integer)AccessController.doPrivileged(new GetIntegerAction("gopherProxyPort", 80));
    }
}

