/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;

public class RepaintArea {
    private static final int MAX_BENEFIT_RATIO = 4;
    private static final int HORIZONTAL = 0;
    private static final int VERTICAL = 1;
    private static final int UPDATE = 2;
    private static final int RECT_COUNT = 3;
    private Rectangle[] paintRects = new Rectangle[3];

    public RepaintArea() {
    }

    private RepaintArea(RepaintArea repaintArea) {
        for (int i = 0; i < 3; ++i) {
            this.paintRects[i] = repaintArea.paintRects[i];
        }
    }

    public synchronized void add(Rectangle rectangle, int n) {
        if (rectangle.isEmpty()) {
            return;
        }
        int n2 = 2;
        if (n == 800) {
            int n3 = n2 = rectangle.width > rectangle.height ? 0 : 1;
        }
        if (this.paintRects[n2] != null) {
            this.paintRects[n2].add(rectangle);
        } else {
            this.paintRects[n2] = new Rectangle(rectangle);
        }
    }

    private synchronized RepaintArea cloneAndReset() {
        RepaintArea repaintArea = new RepaintArea(this);
        for (int i = 0; i < 3; ++i) {
            this.paintRects[i] = null;
        }
        return repaintArea;
    }

    public boolean isEmpty() {
        for (int i = 0; i < 3; ++i) {
            if (this.paintRects[i] == null) continue;
            return false;
        }
        return true;
    }

    public synchronized void constrain(int n, int n2, int n3, int n4) {
        for (int i = 0; i < 3; ++i) {
            int n5;
            int n6;
            Rectangle rectangle = this.paintRects[i];
            if (rectangle == null) continue;
            if (rectangle.x < n) {
                rectangle.width -= n - rectangle.x;
                rectangle.x = n;
            }
            if (rectangle.y < n2) {
                rectangle.height -= n2 - rectangle.y;
                rectangle.y = n2;
            }
            if ((n6 = rectangle.x + rectangle.width - n - n3) > 0) {
                rectangle.width -= n6;
            }
            if ((n5 = rectangle.y + rectangle.height - n2 - n4) > 0) {
                rectangle.height -= n5;
            }
            if (rectangle.width > 0 && rectangle.height > 0) continue;
            this.paintRects[i] = null;
        }
    }

    public synchronized void subtract(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        for (int i = 0; i < 3; ++i) {
            if (!RepaintArea.subtract(this.paintRects[i], rectangle) || this.paintRects[i] == null || !this.paintRects[i].isEmpty()) continue;
            this.paintRects[i] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Object object, boolean bl) {
        Component component = (Component)object;
        if (this.isEmpty()) {
            return;
        }
        if (!component.isVisible()) {
            return;
        }
        RepaintArea repaintArea = this.cloneAndReset();
        if (!RepaintArea.subtract(repaintArea.paintRects[1], repaintArea.paintRects[0])) {
            RepaintArea.subtract(repaintArea.paintRects[0], repaintArea.paintRects[1]);
        }
        if (repaintArea.paintRects[0] != null && repaintArea.paintRects[1] != null) {
            Rectangle rectangle = repaintArea.paintRects[0].union(repaintArea.paintRects[1]);
            int n = rectangle.width * rectangle.height;
            int n2 = n - repaintArea.paintRects[0].width * repaintArea.paintRects[0].height - repaintArea.paintRects[1].width * repaintArea.paintRects[1].height;
            if (4 * n2 < n) {
                repaintArea.paintRects[0] = rectangle;
                repaintArea.paintRects[1] = null;
            }
        }
        for (int i = 0; i < this.paintRects.length; ++i) {
            Graphics graphics;
            if (repaintArea.paintRects[i] == null || repaintArea.paintRects[i].isEmpty() || (graphics = component.getGraphics()) == null) continue;
            try {
                graphics.setClip(repaintArea.paintRects[i]);
                if (i == 2) {
                    this.updateComponent(component, graphics);
                    continue;
                }
                if (bl) {
                    graphics.clearRect(repaintArea.paintRects[i].x, repaintArea.paintRects[i].y, repaintArea.paintRects[i].width, repaintArea.paintRects[i].height);
                }
                this.paintComponent(component, graphics);
                continue;
            }
            finally {
                graphics.dispose();
            }
        }
    }

    protected void updateComponent(Component component, Graphics graphics) {
        if (component != null) {
            component.update(graphics);
        }
    }

    protected void paintComponent(Component component, Graphics graphics) {
        if (component != null) {
            component.paint(graphics);
        }
    }

    static boolean subtract(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle == null || rectangle2 == null) {
            return true;
        }
        Rectangle rectangle3 = rectangle.intersection(rectangle2);
        if (rectangle3.isEmpty()) {
            return true;
        }
        if (rectangle.x == rectangle3.x && rectangle.y == rectangle3.y) {
            if (rectangle.width == rectangle3.width) {
                rectangle.y += rectangle3.height;
                rectangle.height -= rectangle3.height;
                return true;
            }
            if (rectangle.height == rectangle3.height) {
                rectangle.x += rectangle3.width;
                rectangle.width -= rectangle3.width;
                return true;
            }
        } else if (rectangle.x + rectangle.width == rectangle3.x + rectangle3.width && rectangle.y + rectangle.height == rectangle3.y + rectangle3.height) {
            if (rectangle.width == rectangle3.width) {
                rectangle.height -= rectangle3.height;
                return true;
            }
            if (rectangle.height == rectangle3.height) {
                rectangle.width -= rectangle3.width;
                return true;
            }
        }
        return false;
    }
}

