/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.colorchooser.RecentSwatchPanel;

class SwatchPanel
extends JPanel {
    protected Color[] colors;
    protected Dimension swatchSize;
    protected Dimension numSwatches;
    protected Dimension gap;

    public SwatchPanel() {
        this.initValues();
        this.initColors();
        this.setToolTipText("");
        this.setOpaque(true);
        this.setBackground(Color.white);
        this.setRequestFocusEnabled(false);
    }

    public boolean isFocusTraversable() {
        return false;
    }

    protected void initValues() {
    }

    public void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (int i = 0; i < this.numSwatches.height; ++i) {
            for (int j = 0; j < this.numSwatches.width; ++j) {
                graphics.setColor(this.getColorForCell(j, i));
                int n = !this.getComponentOrientation().isLeftToRight() && this instanceof RecentSwatchPanel ? (this.numSwatches.width - j - 1) * (this.swatchSize.width + this.gap.width) : j * (this.swatchSize.width + this.gap.width);
                int n2 = i * (this.swatchSize.height + this.gap.height);
                graphics.fillRect(n, n2, this.swatchSize.width, this.swatchSize.height);
                graphics.setColor(Color.black);
                graphics.drawLine(n + this.swatchSize.width - 1, n2, n + this.swatchSize.width - 1, n2 + this.swatchSize.height - 1);
                graphics.drawLine(n, n2 + this.swatchSize.height - 1, n + this.swatchSize.width - 1, n2 + this.swatchSize.height - 1);
            }
        }
    }

    public Dimension getPreferredSize() {
        int n = this.numSwatches.width * (this.swatchSize.width + this.gap.width) - 1;
        int n2 = this.numSwatches.height * (this.swatchSize.height + this.gap.height) - 1;
        return new Dimension(n, n2);
    }

    protected void initColors() {
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        Color color = this.getColorForLocation(mouseEvent.getX(), mouseEvent.getY());
        return color.getRed() + ", " + color.getGreen() + ", " + color.getBlue();
    }

    public Color getColorForLocation(int n, int n2) {
        int n3 = !this.getComponentOrientation().isLeftToRight() && this instanceof RecentSwatchPanel ? this.numSwatches.width - n / (this.swatchSize.width + this.gap.width) - 1 : n / (this.swatchSize.width + this.gap.width);
        int n4 = n2 / (this.swatchSize.height + this.gap.height);
        return this.getColorForCell(n3, n4);
    }

    private Color getColorForCell(int n, int n2) {
        return this.colors[n2 * this.numSwatches.width + n];
    }
}

