/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.ArrayPersistenceDelegate;
import java.beans.BeanInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.Introspector;
import java.beans.NullPersistenceDelegate;
import java.beans.PersistenceDelegate;
import java.beans.PrimitivePersistenceDelegate;
import java.beans.PropertyDescriptor;
import java.beans.ProxyPersistenceDelegate;
import java.beans.ReflectionUtils;
import java.lang.reflect.Proxy;
import java.util.Hashtable;
import java.util.Vector;

class MetaData {
    private static Hashtable internalPersistenceDelegates = new Hashtable();
    private static Hashtable transientProperties = new Hashtable();
    private static PersistenceDelegate nullPersistenceDelegate = new NullPersistenceDelegate();
    private static PersistenceDelegate primitivePersistenceDelegate = new PrimitivePersistenceDelegate();
    private static PersistenceDelegate defaultPersistenceDelegate = new DefaultPersistenceDelegate();
    private static PersistenceDelegate arrayPersistenceDelegate;
    private static PersistenceDelegate proxyPersistenceDelegate;

    MetaData() {
    }

    static boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public static synchronized void setPersistenceDelegate(Class clazz, PersistenceDelegate persistenceDelegate) {
        MetaData.setBeanAttribute(clazz, "persistenceDelegate", persistenceDelegate);
    }

    public static synchronized PersistenceDelegate getPersistenceDelegate(Class clazz) {
        Object object;
        if (clazz == null) {
            return nullPersistenceDelegate;
        }
        if (ReflectionUtils.isPrimitive(clazz)) {
            return primitivePersistenceDelegate;
        }
        if (clazz.isArray()) {
            if (arrayPersistenceDelegate == null) {
                arrayPersistenceDelegate = new ArrayPersistenceDelegate();
            }
            return arrayPersistenceDelegate;
        }
        try {
            if (Proxy.isProxyClass(clazz)) {
                if (proxyPersistenceDelegate == null) {
                    proxyPersistenceDelegate = new ProxyPersistenceDelegate();
                }
                return proxyPersistenceDelegate;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = clazz.getName();
        if (MetaData.getBeanAttribute(clazz, "transient_init") == null) {
            object = (Vector)transientProperties.get(string);
            if (object != null) {
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    MetaData.setPropertyAttribute(clazz, (String)((Vector)object).get(i), "transient", Boolean.TRUE);
                }
            }
            MetaData.setBeanAttribute(clazz, "transient_init", Boolean.TRUE);
        }
        if ((object = (PersistenceDelegate)MetaData.getBeanAttribute(clazz, "persistenceDelegate")) == null) {
            object = (PersistenceDelegate)internalPersistenceDelegates.get(string);
            if (object != null) {
                return object;
            }
            internalPersistenceDelegates.put(string, defaultPersistenceDelegate);
            try {
                String string2 = clazz.getName();
                Class<?> clazz2 = Class.forName("java.beans." + string2.replace('.', '_') + "_PersistenceDelegate");
                object = (PersistenceDelegate)clazz2.newInstance();
                internalPersistenceDelegates.put(string, object);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Exception exception) {
                System.err.println("Internal error: " + exception);
            }
        }
        return object != null ? object : defaultPersistenceDelegate;
    }

    public static BeanInfo getBeanInfo(Class clazz) {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return beanInfo;
    }

    private static PropertyDescriptor getPropertyDescriptor(Class clazz, String string) {
        BeanInfo beanInfo = MetaData.getBeanInfo(clazz);
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
            if (!string.equals(propertyDescriptor.getName())) continue;
            return propertyDescriptor;
        }
        return null;
    }

    private static void setPropertyAttribute(Class clazz, String string, String string2, Object object) {
        PropertyDescriptor propertyDescriptor = MetaData.getPropertyDescriptor(clazz, string);
        if (propertyDescriptor == null) {
            System.err.println("Warning: property " + string + " is not defined on " + clazz);
            return;
        }
        propertyDescriptor.setValue(string2, object);
    }

    private static void setBeanAttribute(Class clazz, String string, Object object) {
        MetaData.getBeanInfo(clazz).getBeanDescriptor().setValue(string, object);
    }

    private static Object getBeanAttribute(Class clazz, String string) {
        return MetaData.getBeanInfo(clazz).getBeanDescriptor().getValue(string);
    }

    private static synchronized void registerConstructor(String string, String[] stringArray) {
        internalPersistenceDelegates.put(string, new DefaultPersistenceDelegate(stringArray));
    }

    private static void removeProperty(String string, String string2) {
        Vector<String> vector = (Vector<String>)transientProperties.get(string);
        if (vector == null) {
            vector = new Vector<String>();
            transientProperties.put(string, vector);
        }
        vector.add(string2);
    }

    static {
        MetaData.registerConstructor("java.util.Date", new String[]{"time"});
        MetaData.registerConstructor("java.beans.Statement", new String[]{"target", "methodName", "arguments"});
        MetaData.registerConstructor("java.beans.Expression", new String[]{"target", "methodName", "arguments"});
        MetaData.registerConstructor("java.beans.EventHandler", new String[]{"target", "action", "eventPropertyName", "listenerMethodName"});
        MetaData.registerConstructor("java.awt.Point", new String[]{"x", "y"});
        MetaData.registerConstructor("java.awt.Dimension", new String[]{"width", "height"});
        MetaData.registerConstructor("java.awt.Rectangle", new String[]{"x", "y", "width", "height"});
        MetaData.registerConstructor("java.awt.Insets", new String[]{"top", "left", "bottom", "right"});
        MetaData.registerConstructor("java.awt.Color", new String[]{"red", "green", "blue", "alpha"});
        MetaData.registerConstructor("java.awt.Font", new String[]{"name", "style", "size"});
        MetaData.registerConstructor("java.awt.Cursor", new String[]{"type"});
        MetaData.registerConstructor("java.awt.GridBagConstraints", new String[]{"gridx", "gridy", "gridwidth", "gridheight", "weightx", "weighty", "anchor", "fill", "insets", "ipadx", "ipady"});
        MetaData.registerConstructor("java.awt.ScrollPane", new String[]{"scrollbarDisplayPolicy"});
        MetaData.registerConstructor("javax.swing.plaf.FontUIResource", new String[]{"name", "style", "size"});
        MetaData.registerConstructor("javax.swing.plaf.ColorUIResource", new String[]{"red", "green", "blue"});
        MetaData.registerConstructor("javax.swing.tree.DefaultTreeModel", new String[]{"root"});
        MetaData.registerConstructor("javax.swing.JTree", new String[]{"model"});
        MetaData.registerConstructor("javax.swing.tree.TreePath", new String[]{"path"});
        MetaData.registerConstructor("javax.swing.OverlayLayout", new String[]{"target"});
        MetaData.registerConstructor("javax.swing.BoxLayout", new String[]{"target", "axis"});
        MetaData.registerConstructor("javax.swing.Box$Filler", new String[]{"minimumSize", "preferredSize", "maximumSize"});
        MetaData.registerConstructor("javax.swing.DefaultCellEditor", new String[]{"component"});
        MetaData.registerConstructor("javax.swing.JSplitPane", new String[]{"orientation"});
        MetaData.registerConstructor("javax.swing.ImageIcon", new String[]{"description"});
        MetaData.registerConstructor("javax.swing.JButton", new String[]{"label"});
        MetaData.registerConstructor("javax.swing.border.BevelBorder", new String[]{"bevelType", "highlightOuter", "highlightInner", "shadowOuter", "shadowInner"});
        MetaData.registerConstructor("javax.swing.plaf.BorderUIResource$BevelBorderUIResource", new String[]{"bevelType", "highlightOuter", "highlightInner", "shadowOuter", "shadowInner"});
        MetaData.registerConstructor("javax.swing.border.CompoundBorder", new String[]{"outsideBorder", "insideBorder"});
        MetaData.registerConstructor("javax.swing.plaf.BorderUIResource$CompoundBorderUIResource", new String[]{"outsideBorder", "insideBorder"});
        MetaData.registerConstructor("javax.swing.border.EmptyBorder", new String[]{"top", "left", "bottom", "right"});
        MetaData.registerConstructor("javax.swing.plaf.BorderUIResource$EmptyBorderUIResource", new String[]{"top", "left", "bottom", "right"});
        MetaData.registerConstructor("javax.swing.border.EtchedBorder", new String[]{"etchType", "highlight", "shadow"});
        MetaData.registerConstructor("javax.swing.plaf.BorderUIResource$EtchedBorderUIResource", new String[]{"etchType", "highlight", "shadow"});
        MetaData.registerConstructor("javax.swing.border.LineBorder", new String[]{"lineColor", "thickness"});
        MetaData.registerConstructor("javax.swing.plaf.BorderUIResource$LineBorderUIResource", new String[]{"lineColor", "thickness"});
        MetaData.registerConstructor("javax.swing.border.MatteBorder", new String[]{"top", "left", "bottom", "right", "tileIcon"});
        MetaData.registerConstructor("javax.swing.plaf.BorderUIResource$MatteBorderUIResource", new String[]{"top", "left", "bottom", "right", "tileIcon"});
        MetaData.registerConstructor("javax.swing.border.SoftBevelBorder", new String[]{"bevelType", "highlightOuter", "highlightInner", "shadowOuter", "shadowInner"});
        MetaData.registerConstructor("javax.swing.border.TitledBorder", new String[]{"border", "title", "titleJustification", "titlePosition", "titleFont", "titleColor"});
        MetaData.registerConstructor("javax.swing.plaf.BorderUIResource$TitledBorderUIResource", new String[]{"border", "title", "titleJustification", "titlePosition", "titleFont", "titleColor"});
        MetaData.removeProperty("java.awt.geom.RectangularShape", "frame");
        MetaData.removeProperty("java.awt.Rectangle", "bounds");
        MetaData.removeProperty("java.awt.Dimension", "size");
        MetaData.removeProperty("java.awt.Point", "location");
        MetaData.removeProperty("java.awt.Component", "foreground");
        MetaData.removeProperty("java.awt.Component", "background");
        MetaData.removeProperty("java.awt.Component", "font");
        MetaData.removeProperty("java.awt.Component", "visible");
        MetaData.removeProperty("java.awt.ScrollPane", "scrollPosition");
        MetaData.removeProperty("java.awt.im.InputContext", "compositionEnabled");
        MetaData.removeProperty("javax.swing.JComponent", "minimumSize");
        MetaData.removeProperty("javax.swing.JComponent", "preferredSize");
        MetaData.removeProperty("javax.swing.JComponent", "maximumSize");
        MetaData.removeProperty("javax.swing.ImageIcon", "image");
        MetaData.removeProperty("javax.swing.ImageIcon", "imageObserver");
        MetaData.removeProperty("javax.swing.JMenu", "accelerator");
        MetaData.removeProperty("javax.swing.JMenuItem", "accelerator");
        MetaData.removeProperty("javax.swing.JMenuBar", "helpMenu");
        MetaData.removeProperty("javax.swing.JScrollPane", "verticalScrollBar");
        MetaData.removeProperty("javax.swing.JScrollPane", "horizontalScrollBar");
        MetaData.removeProperty("javax.swing.JScrollPane", "rowHeader");
        MetaData.removeProperty("javax.swing.JScrollPane", "columnHeader");
        MetaData.removeProperty("javax.swing.JViewport", "extentSize");
        MetaData.removeProperty("javax.swing.table.JTableHeader", "defaultRenderer");
        MetaData.removeProperty("javax.swing.JList", "cellRenderer");
        MetaData.removeProperty("javax.swing.JList", "selectedIndices");
        MetaData.removeProperty("javax.swing.DefaultListSelectionModel", "leadSelectionIndex");
        MetaData.removeProperty("javax.swing.DefaultListSelectionModel", "anchorSelectionIndex");
        MetaData.removeProperty("javax.swing.JComboBox", "selectedIndex");
        MetaData.removeProperty("javax.swing.JTabbedPane", "selectedIndex");
        MetaData.removeProperty("javax.swing.JTabbedPane", "selectedComponent");
        MetaData.removeProperty("javax.swing.AbstractButton", "disabledIcon");
        MetaData.removeProperty("javax.swing.JLabel", "disabledIcon");
        MetaData.removeProperty("javax.swing.text.JTextComponent", "caret");
        MetaData.removeProperty("javax.swing.text.JTextComponent", "caretPosition");
        MetaData.removeProperty("javax.swing.text.JTextComponent", "selectionStart");
        MetaData.removeProperty("javax.swing.text.JTextComponent", "selectionEnd");
    }
}

