/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.MenuContainer;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.awt.peer.MenuComponentPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleStateSet;
import sun.awt.AppContext;

public abstract class MenuComponent
implements Serializable {
    transient MenuComponentPeer peer;
    transient MenuContainer parent;
    transient AppContext appContext;
    Font font;
    private String name;
    private boolean nameExplicitlySet = false;
    boolean newEventsOnly = false;
    static final String actionListenerK = "actionL";
    static final String itemListenerK = "itemL";
    private static final long serialVersionUID = -4536902356223894379L;
    private transient Object privateKey = new Object();
    AccessibleContext accessibleContext = null;

    public MenuComponent() throws HeadlessException {
        GraphicsEnvironment.checkHeadless();
        this.appContext = AppContext.getAppContext();
    }

    String constructComponentName() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        if (this.name == null && !this.nameExplicitlySet) {
            MenuComponent menuComponent = this;
            synchronized (menuComponent) {
                if (this.name == null && !this.nameExplicitlySet) {
                    this.name = this.constructComponentName();
                }
            }
        }
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String string) {
        MenuComponent menuComponent = this;
        synchronized (menuComponent) {
            this.name = string;
            this.nameExplicitlySet = true;
        }
    }

    public MenuContainer getParent() {
        return this.getParent_NoClientCode();
    }

    final MenuContainer getParent_NoClientCode() {
        return this.parent;
    }

    @Deprecated
    public MenuComponentPeer getPeer() {
        return this.peer;
    }

    public Font getFont() {
        Font font = this.font;
        if (font != null) {
            return font;
        }
        MenuContainer menuContainer = this.parent;
        if (menuContainer != null) {
            return menuContainer.getFont();
        }
        return null;
    }

    final Font getFont_NoClientCode() {
        Font font = this.font;
        if (font != null) {
            return font;
        }
        MenuContainer menuContainer = this.parent;
        if (menuContainer != null) {
            if (menuContainer instanceof Component) {
                font = ((Component)menuContainer).getFont_NoClientCode();
            } else if (menuContainer instanceof MenuComponent) {
                font = ((MenuComponent)((Object)menuContainer)).getFont_NoClientCode();
            }
        }
        return font;
    }

    public void setFont(Font font) {
        this.font = font;
        if (this.peer != null) {
            this.peer.setFont(font);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            MenuComponentPeer menuComponentPeer = this.peer;
            if (menuComponentPeer != null) {
                Toolkit.getEventQueue().removeSourceEvents(this, true);
                this.peer = null;
                menuComponentPeer.dispose();
            }
        }
    }

    @Deprecated
    public boolean postEvent(Event event) {
        MenuContainer menuContainer = this.parent;
        if (menuContainer != null) {
            menuContainer.postEvent(event);
        }
        return false;
    }

    public final void dispatchEvent(AWTEvent aWTEvent) {
        this.dispatchEventImpl(aWTEvent);
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        EventQueue.setCurrentEventAndMostRecentTime(aWTEvent);
        Toolkit.getDefaultToolkit().notifyAWTEventListeners(aWTEvent);
        if (this.newEventsOnly || this.parent != null && this.parent instanceof MenuComponent && ((MenuComponent)((Object)this.parent)).newEventsOnly) {
            if (this.eventEnabled(aWTEvent)) {
                this.processEvent(aWTEvent);
            } else if (aWTEvent instanceof ActionEvent && this.parent != null) {
                aWTEvent.setSource(this.parent);
                ((MenuComponent)((Object)this.parent)).dispatchEvent(aWTEvent);
            }
        } else {
            Event event = aWTEvent.convertToOld();
            if (event != null) {
                this.postEvent(event);
            }
        }
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        return false;
    }

    protected void processEvent(AWTEvent aWTEvent) {
    }

    protected String paramString() {
        String string = this.getName();
        return string != null ? string : "";
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.paramString() + "]";
    }

    protected final Object getTreeLock() {
        return Component.LOCK;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, HeadlessException {
        GraphicsEnvironment.checkHeadless();
        objectInputStream.defaultReadObject();
        this.privateKey = new Object();
        this.appContext = AppContext.getAppContext();
    }

    private static native void initIDs();

    public AccessibleContext getAccessibleContext() {
        return this.accessibleContext;
    }

    int getAccessibleIndexInParent() {
        MenuContainer menuContainer = this.parent;
        if (!(menuContainer instanceof MenuComponent)) {
            return -1;
        }
        MenuComponent menuComponent = (MenuComponent)((Object)menuContainer);
        return menuComponent.getAccessibleChildIndex(this);
    }

    int getAccessibleChildIndex(MenuComponent menuComponent) {
        return -1;
    }

    AccessibleStateSet getAccessibleStateSet() {
        AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
        return accessibleStateSet;
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            MenuComponent.initIDs();
        }
    }

    protected abstract class AccessibleAWTMenuComponent
    extends AccessibleContext
    implements Serializable,
    AccessibleComponent,
    AccessibleSelection {
        private static final long serialVersionUID = -4269533416223798698L;

        protected AccessibleAWTMenuComponent() {
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public String getAccessibleName() {
            return this.accessibleName;
        }

        public String getAccessibleDescription() {
            return this.accessibleDescription;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.AWT_COMPONENT;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return MenuComponent.this.getAccessibleStateSet();
        }

        public Accessible getAccessibleParent() {
            if (this.accessibleParent != null) {
                return this.accessibleParent;
            }
            MenuContainer menuContainer = MenuComponent.this.getParent();
            if (menuContainer instanceof Accessible) {
                return (Accessible)((Object)menuContainer);
            }
            return null;
        }

        public int getAccessibleIndexInParent() {
            return MenuComponent.this.getAccessibleIndexInParent();
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int n) {
            return null;
        }

        public Locale getLocale() {
            MenuContainer menuContainer = MenuComponent.this.getParent();
            if (menuContainer instanceof Component) {
                return ((Component)menuContainer).getLocale();
            }
            return Locale.getDefault();
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public Color getBackground() {
            return null;
        }

        public void setBackground(Color color) {
        }

        public Color getForeground() {
            return null;
        }

        public void setForeground(Color color) {
        }

        public Cursor getCursor() {
            return null;
        }

        public void setCursor(Cursor cursor) {
        }

        public Font getFont() {
            return MenuComponent.this.getFont();
        }

        public void setFont(Font font) {
            MenuComponent.this.setFont(font);
        }

        public FontMetrics getFontMetrics(Font font) {
            return null;
        }

        public boolean isEnabled() {
            return true;
        }

        public void setEnabled(boolean bl) {
        }

        public boolean isVisible() {
            return true;
        }

        public void setVisible(boolean bl) {
        }

        public boolean isShowing() {
            return true;
        }

        public boolean contains(Point point) {
            return false;
        }

        public Point getLocationOnScreen() {
            return null;
        }

        public Point getLocation() {
            return null;
        }

        public void setLocation(Point point) {
        }

        public Rectangle getBounds() {
            return null;
        }

        public void setBounds(Rectangle rectangle) {
        }

        public Dimension getSize() {
            return null;
        }

        public void setSize(Dimension dimension) {
        }

        public Accessible getAccessibleAt(Point point) {
            return null;
        }

        public boolean isFocusTraversable() {
            return true;
        }

        public void requestFocus() {
        }

        public void addFocusListener(FocusListener focusListener) {
        }

        public void removeFocusListener(FocusListener focusListener) {
        }

        public int getAccessibleSelectionCount() {
            return 0;
        }

        public Accessible getAccessibleSelection(int n) {
            return null;
        }

        public boolean isAccessibleChildSelected(int n) {
            return false;
        }

        public void addAccessibleSelection(int n) {
        }

        public void removeAccessibleSelection(int n) {
        }

        public void clearAccessibleSelection() {
        }

        public void selectAllAccessibleSelection() {
        }
    }
}

