/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.proc.x86;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.ThreadContext;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.proc.ProcDebugger;
import sun.jvm.hotspot.debugger.proc.x86.ProcX86ThreadContext;
import sun.jvm.hotspot.utilities.Assert;

public class ProcX86Thread
implements ThreadProxy {
    private ProcDebugger debugger;
    private int id;

    public ProcX86Thread(ProcDebugger debugger, Address addr) {
        this.debugger = debugger;
        this.id = (int)addr.getCIntegerAt(0L, 4L, true);
    }

    public ProcX86Thread(ProcDebugger debugger, long id) {
        this.debugger = debugger;
        this.id = (int)id;
    }

    public ThreadContext getContext() throws IllegalThreadStateException {
        ProcX86ThreadContext context = new ProcX86ThreadContext(this.debugger);
        long[] regs = this.debugger.getThreadIntegerRegisterSet(this.id);
        Assert.that(regs.length <= 25, "size of register set is greater than 25");
        for (int i = 0; i < regs.length; ++i) {
            context.setRegister(i, regs[i]);
        }
        return context;
    }

    public boolean canSetContext() throws DebuggerException {
        return false;
    }

    public void setContext(ThreadContext context) throws IllegalThreadStateException, DebuggerException {
        throw new DebuggerException("Unimplemented");
    }

    public String toString() {
        return "t@" + this.id;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ProcX86Thread)) {
            return false;
        }
        return ((ProcX86Thread)obj).id == this.id;
    }

    public int hashCode() {
        return this.id;
    }
}

