/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.util.Iterator;
import java.util.Map;
import sun.awt.X11.ComponentAccessor;
import sun.awt.X11.Native;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XAnyEvent;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XButtonEvent;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XDestroyWindowEvent;
import sun.awt.X11.XDragAndDropProtocols;
import sun.awt.X11.XDragSourceProtocol;
import sun.awt.X11.XDragSourceProtocolListener;
import sun.awt.X11.XException;
import sun.awt.X11.XGlobalCursorManager;
import sun.awt.X11.XKeyEvent;
import sun.awt.X11.XMotionEvent;
import sun.awt.X11.XQueryTree;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWM;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibWrapper;
import sun.awt.dnd.SunDragSourceContextPeer;
import sun.awt.dnd.SunDropTargetContextPeer;

public final class XDragSourceContextPeer
extends SunDragSourceContextPeer
implements XDragSourceProtocolListener {
    private static final int ROOT_EVENT_MASK = 8195;
    private static final int GRAB_EVENT_MASK = 8204;
    private long rootEventMask = 0L;
    private boolean dndInProgress = false;
    private boolean dragInProgress = false;
    private long dragRootWindow = 0L;
    private XDragSourceProtocol dragProtocol = null;
    private int targetAction = 0;
    private int sourceActions = 0;
    private int sourceAction = 0;
    private long[] sourceFormats = null;
    private long targetRootSubwindow = 0L;
    private int xRoot = 0;
    private int yRoot = 0;
    private int eventState = 0;
    private static final XDragSourceContextPeer theInstance = new XDragSourceContextPeer(null);

    private XDragSourceContextPeer(DragGestureEvent dragGestureEvent) {
        super(dragGestureEvent);
    }

    static XDragSourceProtocolListener getXDragSourceProtocolListener() {
        return theInstance;
    }

    static XDragSourceContextPeer createDragSourceContextPeer(DragGestureEvent dragGestureEvent) throws InvalidDnDOperationException {
        theInstance.setTrigger(dragGestureEvent);
        return theInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startDrag(Transferable transferable, long[] lArray, Map map) {
        Component component = this.getTrigger().getComponent();
        Component component2 = null;
        XWindowPeer xWindowPeer = null;
        component2 = component;
        while (component2 != null && !(component2 instanceof Window)) {
            component2 = ComponentAccessor.getParent_NoClientCode(component2);
        }
        if (component2 instanceof Window) {
            xWindowPeer = (XWindowPeer)component2.getPeer();
        }
        if (xWindowPeer == null) {
            throw new InvalidDnDOperationException("Cannot find top-level for the drag source component");
        }
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        Object object = this.getCursor();
        if (object != null) {
            l2 = XGlobalCursorManager.getCursor((Cursor)object);
        }
        object = XToolkit.getAWTLock();
        synchronized (object) {
            int n2;
            long l6 = XlibWrapper.XScreenNumberOfScreen(xWindowPeer.getScreen());
            l3 = XlibWrapper.RootWindow(XToolkit.getDisplay(), l6);
            l4 = XWindow.getXAWTRootWindow().getWindow();
            l5 = XToolkit.getCurrentServerTime();
            int n3 = this.getDragSourceContext().getSourceActions();
            Iterator iterator = XDragAndDropProtocols.getDragSourceProtocols();
            while (iterator.hasNext()) {
                XDragSourceProtocol xDragSourceProtocol = (XDragSourceProtocol)iterator.next();
                try {
                    xDragSourceProtocol.initializeDrag(n3, transferable, map, lArray);
                }
                catch (XException xException) {
                    throw (InvalidDnDOperationException)new InvalidDnDOperationException().initCause(xException);
                }
            }
            XWindowAttributes xWindowAttributes = new XWindowAttributes();
            try {
                n2 = XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), l3, xWindowAttributes.pData);
                if (n2 == 0) {
                    throw new InvalidDnDOperationException("XGetWindowAttributes failed");
                }
                this.rootEventMask = xWindowAttributes.get_your_event_mask();
                XlibWrapper.XSelectInput(XToolkit.getDisplay(), l3, this.rootEventMask | 0x2003L);
            }
            finally {
                xWindowAttributes.dispose();
            }
            XBaseWindow.ungrabInput();
            n2 = XlibWrapper.XGrabPointer(XToolkit.getDisplay(), l3, 0, 8204, 1, 1, l3, l2, l5);
            if (n2 != 0) {
                this.cleanup(l5);
                this.throwGrabFailureException("Cannot grab pointer", n2);
                return;
            }
            n2 = XlibWrapper.XGrabKeyboard(XToolkit.getDisplay(), l3, 0, 1, 1, l5);
            if (n2 != 0) {
                this.cleanup(l5);
                this.throwGrabFailureException("Cannot grab keyboard", n2);
                return;
            }
            this.dndInProgress = true;
            this.dragInProgress = true;
            this.dragRootWindow = l3;
            this.sourceActions = n3;
            this.sourceFormats = lArray;
        }
        this.setNativeContext(0L);
        SunDropTargetContextPeer.setCurrentJVMLocalSourceTransferable(transferable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCursor(Cursor cursor) throws InvalidDnDOperationException {
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            super.setCursor(cursor);
        }
    }

    protected void setNativeCursor(long l2, Cursor cursor, int n2) {
        assert (Thread.holdsLock(XToolkit.getAWTLock()));
        if (cursor == null) {
            return;
        }
        long l3 = XGlobalCursorManager.getCursor(cursor);
        if (l3 == 0L) {
            return;
        }
        XlibWrapper.XChangeActivePointerGrab(XToolkit.getDisplay(), 8204, l3, 0L);
    }

    protected boolean needsBogusExitBeforeDrop() {
        return false;
    }

    private void throwGrabFailureException(String string, int n2) throws InvalidDnDOperationException {
        String string2 = "";
        switch (n2) {
            case 3: {
                string2 = "not viewable";
                break;
            }
            case 1: {
                string2 = "already grabbed";
                break;
            }
            case 2: {
                string2 = "invalid time";
                break;
            }
            case 4: {
                string2 = "grab frozen";
                break;
            }
            default: {
                string2 = "unknown failure";
            }
        }
        throw new InvalidDnDOperationException(string + ": " + string2);
    }

    public void cleanup(long l2) {
        if (this.dndInProgress) {
            if (this.dragProtocol != null) {
                this.dragProtocol.sendLeaveMessage(l2);
            }
            if (this.targetAction != 0) {
                this.dragExit(this.xRoot, this.yRoot);
            }
            this.dragDropFinished(false, 0, this.xRoot, this.yRoot);
        }
        Iterator iterator = XDragAndDropProtocols.getDragSourceProtocols();
        while (iterator.hasNext()) {
            XDragSourceProtocol xDragSourceProtocol = (XDragSourceProtocol)iterator.next();
            try {
                xDragSourceProtocol.cleanup();
            }
            catch (XException xException) {}
        }
        this.dndInProgress = false;
        this.dragInProgress = false;
        this.dragRootWindow = 0L;
        this.sourceFormats = null;
        this.sourceActions = 0;
        this.sourceAction = 0;
        this.eventState = 0;
        this.xRoot = 0;
        this.yRoot = 0;
        this.cleanupTargetInfo();
        this.removeDnDGrab(l2);
    }

    private void cleanupTargetInfo() {
        this.targetAction = 0;
        this.dragProtocol = null;
        this.targetRootSubwindow = 0L;
    }

    private void removeDnDGrab(long l2) {
        assert (Thread.holdsLock(XToolkit.getAWTLock()));
        XlibWrapper.XUngrabPointer(XToolkit.getDisplay(), l2);
        XlibWrapper.XUngrabKeyboard(XToolkit.getDisplay(), l2);
        if ((this.rootEventMask | 0x2003L) != this.rootEventMask && this.dragRootWindow != 0L) {
            XlibWrapper.XSelectInput(XToolkit.getDisplay(), this.dragRootWindow, this.rootEventMask);
        }
        this.rootEventMask = 0L;
        this.dragRootWindow = 0L;
    }

    private boolean processClientMessage(XClientMessageEvent xClientMessageEvent) {
        if (this.dragProtocol != null) {
            return this.dragProtocol.processClientMessage(xClientMessageEvent);
        }
        return false;
    }

    private boolean updateSourceAction(int n2) {
        int n3 = SunDragSourceContextPeer.convertModifiersToDropAction(XWindow.getModifiers(n2, 0, 0), this.sourceActions);
        if (this.sourceAction == n3) {
            return false;
        }
        this.sourceAction = n3;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long findClientWindow(long l2) {
        WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(l2, XWM.XA_WM_STATE, 0L, 1L, false, XWM.XA_WM_STATE);
        try {
            windowPropertyGetter.execute(XToolkit.IgnoreBadWindowHandler);
            if (windowPropertyGetter.getActualType() == XWM.XA_WM_STATE.getAtom()) {
                long l3 = l2;
                return l3;
            }
        }
        finally {
            windowPropertyGetter.dispose();
        }
        XQueryTree xQueryTree = new XQueryTree(l2);
        try {
            int n2 = xQueryTree.execute(null);
            if (n2 == 0) {
                long l4 = 0L;
                return l4;
            }
            long l5 = xQueryTree.get_children();
            if (l5 == 0L) {
                long l6 = 0L;
                return l6;
            }
            int n3 = xQueryTree.get_nchildren();
            for (int i2 = 0; i2 < n3; ++i2) {
                long l7 = XDragSourceContextPeer.findClientWindow(Native.getLong(l5, i2));
                if (l7 == 0L) continue;
                long l8 = l7;
                return l8;
            }
            long l9 = 0L;
            return l9;
        }
        finally {
            xQueryTree.dispose();
        }
    }

    private void doUpdateTargetWindow(long l2, long l3) {
        long l4 = 0L;
        long l5 = 0L;
        XDragSourceProtocol xDragSourceProtocol = null;
        boolean bl2 = false;
        if (l2 != 0L) {
            l4 = XDragSourceContextPeer.findClientWindow(l2);
        }
        if (l4 != 0L) {
            Iterator iterator = XDragAndDropProtocols.getDragSourceProtocols();
            while (iterator.hasNext()) {
                XDragSourceProtocol xDragSourceProtocol2 = (XDragSourceProtocol)iterator.next();
                if (!xDragSourceProtocol2.attachTargetWindow(l4, l3)) continue;
                xDragSourceProtocol = xDragSourceProtocol2;
                break;
            }
        }
        this.dragProtocol = xDragSourceProtocol;
        this.targetAction = 0;
        this.targetRootSubwindow = l2;
    }

    private void updateTargetWindow(XMotionEvent xMotionEvent) {
        assert (Thread.holdsLock(XToolkit.getAWTLock()));
        int n2 = xMotionEvent.get_x_root();
        int n3 = xMotionEvent.get_y_root();
        long l2 = xMotionEvent.get_time();
        long l3 = xMotionEvent.get_subwindow();
        if (xMotionEvent.get_window() != xMotionEvent.get_root()) {
            XlibWrapper.XQueryPointer(XToolkit.getDisplay(), xMotionEvent.get_root(), XlibWrapper.larg1, XlibWrapper.larg2, XlibWrapper.larg3, XlibWrapper.larg4, XlibWrapper.larg5, XlibWrapper.larg6, XlibWrapper.larg7);
            l3 = Native.getLong(XlibWrapper.larg2);
        }
        if (this.targetRootSubwindow != l3) {
            if (this.dragProtocol != null) {
                this.dragProtocol.sendLeaveMessage(l2);
                if (this.targetAction != 0) {
                    this.dragExit(n2, n3);
                }
            }
            this.doUpdateTargetWindow(l3, l2);
            if (this.dragProtocol != null) {
                this.dragProtocol.sendEnterMessage(this.sourceFormats, this.sourceAction, this.sourceActions, l2);
            }
        }
    }

    private void processMouseMove(XMotionEvent xMotionEvent) {
        if (!this.dragInProgress) {
            return;
        }
        if (this.xRoot != xMotionEvent.get_x_root() || this.yRoot != xMotionEvent.get_y_root()) {
            this.xRoot = xMotionEvent.get_x_root();
            this.yRoot = xMotionEvent.get_y_root();
            this.postDragSourceDragEvent(this.targetAction, XWindow.getModifiers(xMotionEvent.get_state(), 0, 0), this.xRoot, this.yRoot, 6);
        }
        if (this.eventState != xMotionEvent.get_state()) {
            if (this.updateSourceAction(xMotionEvent.get_state()) && this.dragProtocol != null) {
                this.postDragSourceDragEvent(this.targetAction, XWindow.getModifiers(xMotionEvent.get_state(), 0, 0), this.xRoot, this.yRoot, 3);
            }
            this.eventState = xMotionEvent.get_state();
        }
        this.updateTargetWindow(xMotionEvent);
        if (this.dragProtocol != null) {
            this.dragProtocol.sendMoveMessage(xMotionEvent.get_x_root(), xMotionEvent.get_y_root(), this.sourceAction, this.sourceActions, xMotionEvent.get_time());
        }
    }

    private void processDrop(XButtonEvent xButtonEvent) {
        try {
            this.dragProtocol.initiateDrop(xButtonEvent.get_x_root(), xButtonEvent.get_y_root(), this.sourceAction, this.sourceActions, xButtonEvent.get_time());
        }
        catch (XException xException) {
            this.cleanup(xButtonEvent.get_time());
        }
    }

    private boolean doProcessEvent(XAnyEvent xAnyEvent) {
        assert (Thread.holdsLock(XToolkit.getAWTLock()));
        if (!this.dndInProgress) {
            return false;
        }
        switch (xAnyEvent.get_type()) {
            case 33: {
                XClientMessageEvent xClientMessageEvent = new XClientMessageEvent(xAnyEvent.pData);
                return this.processClientMessage(xClientMessageEvent);
            }
            case 17: {
                XDestroyWindowEvent xDestroyWindowEvent = new XDestroyWindowEvent(xAnyEvent.pData);
                if (!this.dragInProgress && this.dragProtocol != null && xDestroyWindowEvent.get_window() == this.dragProtocol.getTargetWindow()) {
                    this.cleanup(0L);
                    return true;
                }
                return false;
            }
        }
        if (!this.dragInProgress) {
            return false;
        }
        switch (xAnyEvent.get_type()) {
            case 2: 
            case 3: {
                XKeyEvent xKeyEvent = new XKeyEvent(xAnyEvent.pData);
                long l2 = XlibWrapper.XKeycodeToKeysym(XToolkit.getDisplay(), xKeyEvent.get_keycode(), 0);
                switch ((int)l2) {
                    case 65307: {
                        if (xAnyEvent.get_type() != 3) break;
                        this.cleanup(xKeyEvent.get_time());
                        break;
                    }
                    case 65505: 
                    case 65506: 
                    case 65507: 
                    case 65508: {
                        XlibWrapper.XQueryPointer(XToolkit.getDisplay(), xKeyEvent.get_root(), XlibWrapper.larg1, XlibWrapper.larg2, XlibWrapper.larg3, XlibWrapper.larg4, XlibWrapper.larg5, XlibWrapper.larg6, XlibWrapper.larg7);
                        int n2 = (int)Native.getLong(XlibWrapper.larg7);
                        xKeyEvent.set_state(n2);
                        this.processMouseMove(new XMotionEvent(xKeyEvent.pData));
                        break;
                    }
                }
                return true;
            }
            case 4: {
                return true;
            }
            case 6: {
                this.processMouseMove(new XMotionEvent(xAnyEvent.pData));
                return true;
            }
            case 5: {
                XButtonEvent xButtonEvent = new XButtonEvent(xAnyEvent.pData);
                this.processMouseMove(new XMotionEvent(xAnyEvent.pData));
                if (xButtonEvent.get_button() == 1) {
                    this.removeDnDGrab(xButtonEvent.get_time());
                    this.dragInProgress = false;
                    if (this.dragProtocol != null && this.targetAction != 0) {
                        this.processDrop(xButtonEvent);
                    } else {
                        this.cleanup(xButtonEvent.get_time());
                    }
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean processEvent(XAnyEvent xAnyEvent) {
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            try {
                return theInstance.doProcessEvent(xAnyEvent);
            }
            catch (XException xException) {
                xException.printStackTrace();
                return false;
            }
        }
    }

    public void handleDragReply(int n2) {
        this.handleDragReply(n2, this.xRoot, this.yRoot);
    }

    public void handleDragReply(int n2, int n3, int n4) {
        this.handleDragReply(n2, this.xRoot, this.yRoot, XWindow.getModifiers(this.eventState, 0, 0));
    }

    public void handleDragReply(int n2, int n3, int n4, int n5) {
        if (n2 == 0 && this.targetAction != 0) {
            this.dragExit(n3, n4);
        } else if (n2 != 0) {
            int n6 = 0;
            n6 = this.targetAction == 0 ? 1 : 2;
            this.postDragSourceDragEvent(n2, n5, n3, n4, n6);
        }
        this.targetAction = n2;
    }

    public void handleDragFinished() {
        this.handleDragFinished(true);
    }

    public void handleDragFinished(boolean bl2) {
        this.handleDragFinished(true, this.targetAction);
    }

    public void handleDragFinished(boolean bl2, int n2) {
        this.handleDragFinished(bl2, n2, this.xRoot, this.yRoot);
    }

    public void handleDragFinished(boolean bl2, int n2, int n3, int n4) {
        this.dragDropFinished(bl2, n2, n3, n4);
        this.dndInProgress = false;
        this.cleanup(0L);
    }
}

