/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPanelUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.plaf.synth.SynthUI;

class SynthPanelUI
extends BasicPanelUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;

    SynthPanelUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthPanelUI();
    }

    public void installUI(JComponent jComponent) {
        JPanel jPanel = (JPanel)jComponent;
        super.installUI(jComponent);
        this.installListeners(jPanel);
    }

    public void uninstallUI(JComponent jComponent) {
        JPanel jPanel = (JPanel)jComponent;
        this.uninstallListeners(jPanel);
        super.uninstallUI(jComponent);
    }

    protected void installListeners(JPanel jPanel) {
        jPanel.addPropertyChangeListener(this);
    }

    protected void uninstallListeners(JPanel jPanel) {
        jPanel.removePropertyChangeListener(this);
    }

    protected void installDefaults(JPanel jPanel) {
        this.updateStyle(jPanel);
    }

    protected void uninstallDefaults(JPanel jPanel) {
        SynthContext synthContext = this.getContext(jPanel, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    private void updateStyle(JPanel jPanel) {
        SynthContext synthContext = this.getContext(jPanel, 1);
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n2);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintPanelBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
    }

    public void paintBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        synthContext.getPainter().paintPanelBorder(synthContext, graphics, n2, n3, n4, n5);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle((JPanel)propertyChangeEvent.getSource());
        }
    }
}

