/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthPainter;
import javax.swing.plaf.synth.SynthStyle;

public class SynthContext {
    private static final Map contextMap = new HashMap();
    private JComponent component;
    private Region region;
    private SynthStyle style;
    private int state;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SynthContext getContext(Class clazz, JComponent jComponent, Region region, SynthStyle synthStyle, int n2) {
        SynthContext synthContext = null;
        Map map = contextMap;
        synchronized (map) {
            int n3;
            List list = (List)contextMap.get(clazz);
            if (list != null && (n3 = list.size()) > 0) {
                synthContext = (SynthContext)list.remove(n3 - 1);
            }
        }
        if (synthContext == null) {
            try {
                synthContext = (SynthContext)clazz.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        synthContext.reset(jComponent, region, synthStyle, n2);
        return synthContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void releaseContext(SynthContext synthContext) {
        Map map = contextMap;
        synchronized (map) {
            ArrayList<SynthContext> arrayList = (ArrayList<SynthContext>)contextMap.get(synthContext.getClass());
            if (arrayList == null) {
                arrayList = new ArrayList<SynthContext>(5);
                contextMap.put(synthContext.getClass(), arrayList);
            }
            arrayList.add(synthContext);
        }
    }

    SynthContext() {
    }

    public SynthContext(JComponent jComponent, Region region, SynthStyle synthStyle, int n2) {
        if (jComponent == null || region == null || synthStyle == null) {
            throw new NullPointerException("You must supply a non-null component, region and style");
        }
        this.reset(jComponent, region, synthStyle, n2);
    }

    public JComponent getComponent() {
        return this.component;
    }

    public Region getRegion() {
        return this.region;
    }

    boolean isSubregion() {
        return this.getRegion().isSubregion();
    }

    void setStyle(SynthStyle synthStyle) {
        this.style = synthStyle;
    }

    public SynthStyle getStyle() {
        return this.style;
    }

    void setComponentState(int n2) {
        this.state = n2;
    }

    public int getComponentState() {
        return this.state;
    }

    void reset(JComponent jComponent, Region region, SynthStyle synthStyle, int n2) {
        this.component = jComponent;
        this.region = region;
        this.style = synthStyle;
        this.state = n2;
    }

    void dispose() {
        this.component = null;
        this.style = null;
        SynthContext.releaseContext(this);
    }

    SynthPainter getPainter() {
        SynthPainter synthPainter = this.getStyle().getPainter(this);
        if (synthPainter != null) {
            return synthPainter;
        }
        return SynthPainter.NULL_PAINTER;
    }
}

