/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import com.sun.java.swing.SwingUtilities2;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalBumps;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalRootPaneUI;
import javax.swing.plaf.metal.MetalUtils;

class MetalTitlePane
extends JComponent {
    private static final Border handyEmptyBorder = new EmptyBorder(0, 0, 0, 0);
    private static final int IMAGE_HEIGHT = 16;
    private static final int IMAGE_WIDTH = 16;
    private PropertyChangeListener propertyChangeListener;
    private JMenuBar menuBar;
    private Action closeAction;
    private Action iconifyAction;
    private Action restoreAction;
    private Action maximizeAction;
    private JButton toggleButton;
    private JButton iconifyButton;
    private JButton closeButton;
    private Icon maximizeIcon;
    private Icon minimizeIcon;
    private WindowListener windowListener;
    private Window window;
    private JRootPane rootPane;
    private int buttonsWidth;
    private int state;
    private MetalRootPaneUI rootPaneUI;
    private Color inactiveBackground = UIManager.getColor("inactiveCaption");
    private Color inactiveForeground = UIManager.getColor("inactiveCaptionText");
    private Color inactiveShadow = UIManager.getColor("inactiveCaptionBorder");
    private Color activeBumpsHighlight = MetalLookAndFeel.getPrimaryControlHighlight();
    private Color activeBumpsShadow = MetalLookAndFeel.getPrimaryControlDarkShadow();
    private Color activeBackground = null;
    private Color activeForeground = null;
    private Color activeShadow = null;
    private MetalBumps activeBumps = new MetalBumps(0, 0, this.activeBumpsHighlight, this.activeBumpsShadow, MetalLookAndFeel.getPrimaryControl());
    private MetalBumps inactiveBumps = new MetalBumps(0, 0, MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlDarkShadow(), MetalLookAndFeel.getControl());

    public MetalTitlePane(JRootPane jRootPane, MetalRootPaneUI metalRootPaneUI) {
        this.rootPane = jRootPane;
        this.rootPaneUI = metalRootPaneUI;
        this.state = -1;
        this.installSubcomponents();
        this.determineColors();
        this.installDefaults();
        this.setLayout(this.createLayout());
    }

    private void uninstall() {
        this.uninstallListeners();
        this.window = null;
        this.removeAll();
    }

    private void installListeners() {
        if (this.window != null) {
            this.windowListener = this.createWindowListener();
            this.window.addWindowListener(this.windowListener);
            this.propertyChangeListener = this.createWindowPropertyChangeListener();
            this.window.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    private void uninstallListeners() {
        if (this.window != null) {
            this.window.removeWindowListener(this.windowListener);
            this.window.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    private WindowListener createWindowListener() {
        return new WindowHandler();
    }

    private PropertyChangeListener createWindowPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    private int getWindowDecorationStyle() {
        return this.getRootPane().getWindowDecorationStyle();
    }

    public void addNotify() {
        super.addNotify();
        this.uninstallListeners();
        this.window = SwingUtilities.getWindowAncestor(this);
        if (this.window != null) {
            if (this.window instanceof Frame) {
                this.setState(((Frame)this.window).getExtendedState());
            } else {
                this.setState(0);
            }
            this.setActive(this.window.isActive());
            this.installListeners();
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.uninstallListeners();
        this.window = null;
    }

    private void installSubcomponents() {
        int n2 = this.getWindowDecorationStyle();
        if (n2 == 1) {
            this.createActions();
            this.menuBar = this.createMenuBar();
            this.add(this.menuBar);
            this.createButtons();
            this.add(this.iconifyButton);
            this.add(this.toggleButton);
            this.add(this.closeButton);
        } else if (n2 == 2 || n2 == 3 || n2 == 4 || n2 == 5 || n2 == 6 || n2 == 7 || n2 == 8) {
            this.createActions();
            this.createButtons();
            this.add(this.closeButton);
        }
    }

    private void determineColors() {
        switch (this.getWindowDecorationStyle()) {
            case 1: {
                this.activeBackground = UIManager.getColor("activeCaption");
                this.activeForeground = UIManager.getColor("activeCaptionText");
                this.activeShadow = UIManager.getColor("activeCaptionBorder");
                break;
            }
            case 4: {
                this.activeBackground = UIManager.getColor("OptionPane.errorDialog.titlePane.background");
                this.activeForeground = UIManager.getColor("OptionPane.errorDialog.titlePane.foreground");
                this.activeShadow = UIManager.getColor("OptionPane.errorDialog.titlePane.shadow");
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                this.activeBackground = UIManager.getColor("OptionPane.questionDialog.titlePane.background");
                this.activeForeground = UIManager.getColor("OptionPane.questionDialog.titlePane.foreground");
                this.activeShadow = UIManager.getColor("OptionPane.questionDialog.titlePane.shadow");
                break;
            }
            case 8: {
                this.activeBackground = UIManager.getColor("OptionPane.warningDialog.titlePane.background");
                this.activeForeground = UIManager.getColor("OptionPane.warningDialog.titlePane.foreground");
                this.activeShadow = UIManager.getColor("OptionPane.warningDialog.titlePane.shadow");
                break;
            }
            default: {
                this.activeBackground = UIManager.getColor("activeCaption");
                this.activeForeground = UIManager.getColor("activeCaptionText");
                this.activeShadow = UIManager.getColor("activeCaptionBorder");
            }
        }
        this.activeBumps.setBumpColors(this.activeBumpsHighlight, this.activeBumpsShadow, this.activeBackground);
    }

    private void installDefaults() {
        this.setFont(UIManager.getFont("InternalFrame.titleFont", this.getLocale()));
    }

    private void uninstallDefaults() {
    }

    protected JMenuBar createMenuBar() {
        this.menuBar = new SystemMenuBar();
        this.menuBar.setFocusable(false);
        this.menuBar.setBorderPainted(true);
        this.menuBar.add(this.createMenu());
        return this.menuBar;
    }

    private void close() {
        Window window = this.getWindow();
        if (window != null) {
            window.dispatchEvent(new WindowEvent(window, 201));
        }
    }

    private void iconify() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(this.state | 1);
        }
    }

    private void maximize() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(this.state | 6);
        }
    }

    private void restore() {
        Frame frame = this.getFrame();
        if (frame == null) {
            return;
        }
        if ((this.state & 1) != 0) {
            frame.setExtendedState(this.state & 0xFFFFFFFE);
        } else {
            frame.setExtendedState(this.state & 0xFFFFFFF9);
        }
    }

    private void createActions() {
        this.closeAction = new CloseAction();
        if (this.getWindowDecorationStyle() == 1) {
            this.iconifyAction = new IconifyAction();
            this.restoreAction = new RestoreAction();
            this.maximizeAction = new MaximizeAction();
        }
    }

    private JMenu createMenu() {
        JMenu jMenu = new JMenu("");
        if (this.getWindowDecorationStyle() == 1) {
            this.addMenuItems(jMenu);
        }
        return jMenu;
    }

    private void addMenuItems(JMenu jMenu) {
        Locale locale = this.getRootPane().getLocale();
        JMenuItem jMenuItem = jMenu.add(this.restoreAction);
        int n2 = MetalUtils.getInt("MetalTitlePane.restoreMnemonic", -1);
        if (n2 != -1) {
            jMenuItem.setMnemonic(n2);
        }
        jMenuItem = jMenu.add(this.iconifyAction);
        n2 = MetalUtils.getInt("MetalTitlePane.iconifyMnemonic", -1);
        if (n2 != -1) {
            jMenuItem.setMnemonic(n2);
        }
        if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            jMenuItem = jMenu.add(this.maximizeAction);
            n2 = MetalUtils.getInt("MetalTitlePane.maximizeMnemonic", -1);
            if (n2 != -1) {
                jMenuItem.setMnemonic(n2);
            }
        }
        jMenu.add(new JSeparator());
        jMenuItem = jMenu.add(this.closeAction);
        n2 = MetalUtils.getInt("MetalTitlePane.closeMnemonic", -1);
        if (n2 != -1) {
            jMenuItem.setMnemonic(n2);
        }
    }

    private JButton createTitleButton() {
        JButton jButton = new JButton();
        jButton.setFocusPainted(false);
        jButton.setFocusable(false);
        jButton.setOpaque(true);
        return jButton;
    }

    private void createButtons() {
        this.closeButton = this.createTitleButton();
        this.closeButton.setAction(this.closeAction);
        this.closeButton.setText(null);
        this.closeButton.putClientProperty("paintActive", Boolean.TRUE);
        this.closeButton.setBorder(handyEmptyBorder);
        this.closeButton.getAccessibleContext().setAccessibleName("Close");
        this.closeButton.setIcon(UIManager.getIcon("InternalFrame.closeIcon"));
        if (this.getWindowDecorationStyle() == 1) {
            this.maximizeIcon = UIManager.getIcon("InternalFrame.maximizeIcon");
            this.minimizeIcon = UIManager.getIcon("InternalFrame.minimizeIcon");
            this.iconifyButton = this.createTitleButton();
            this.iconifyButton.setAction(this.iconifyAction);
            this.iconifyButton.setText(null);
            this.iconifyButton.putClientProperty("paintActive", Boolean.TRUE);
            this.iconifyButton.setBorder(handyEmptyBorder);
            this.iconifyButton.getAccessibleContext().setAccessibleName("Iconify");
            this.iconifyButton.setIcon(UIManager.getIcon("InternalFrame.iconifyIcon"));
            this.toggleButton = this.createTitleButton();
            this.toggleButton.setAction(this.restoreAction);
            this.toggleButton.putClientProperty("paintActive", Boolean.TRUE);
            this.toggleButton.setBorder(handyEmptyBorder);
            this.toggleButton.getAccessibleContext().setAccessibleName("Maximize");
            this.toggleButton.setIcon(this.maximizeIcon);
        }
    }

    private LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    private void setActive(boolean bl2) {
        Boolean bl3 = bl2 ? Boolean.TRUE : Boolean.FALSE;
        this.closeButton.putClientProperty("paintActive", bl3);
        if (this.getWindowDecorationStyle() == 1) {
            this.iconifyButton.putClientProperty("paintActive", bl3);
            this.toggleButton.putClientProperty("paintActive", bl3);
        }
        this.getRootPane().repaint();
    }

    private void setState(int n2) {
        this.setState(n2, false);
    }

    private void setState(int n2, boolean bl2) {
        Window window = this.getWindow();
        if (window != null && this.getWindowDecorationStyle() == 1) {
            if (this.state == n2 && !bl2) {
                return;
            }
            Frame frame = this.getFrame();
            if (frame != null) {
                JRootPane jRootPane = this.getRootPane();
                if ((n2 & 6) != 0 && (jRootPane.getBorder() == null || jRootPane.getBorder() instanceof UIResource) && frame.isShowing()) {
                    jRootPane.setBorder(null);
                } else if ((n2 & 6) == 0) {
                    this.rootPaneUI.installBorder(jRootPane);
                }
                if (frame.isResizable()) {
                    if ((n2 & 6) != 0) {
                        this.updateToggleButton(this.restoreAction, this.minimizeIcon);
                        this.maximizeAction.setEnabled(false);
                        this.restoreAction.setEnabled(true);
                    } else {
                        this.updateToggleButton(this.maximizeAction, this.maximizeIcon);
                        this.maximizeAction.setEnabled(true);
                        this.restoreAction.setEnabled(false);
                    }
                    if (this.toggleButton.getParent() == null || this.iconifyButton.getParent() == null) {
                        this.add(this.toggleButton);
                        this.add(this.iconifyButton);
                        this.revalidate();
                        this.repaint();
                    }
                    this.toggleButton.setText(null);
                } else {
                    this.maximizeAction.setEnabled(false);
                    this.restoreAction.setEnabled(false);
                    if (this.toggleButton.getParent() != null) {
                        this.remove(this.toggleButton);
                        this.revalidate();
                        this.repaint();
                    }
                }
            } else {
                this.maximizeAction.setEnabled(false);
                this.restoreAction.setEnabled(false);
                this.iconifyAction.setEnabled(false);
                this.remove(this.toggleButton);
                this.remove(this.iconifyButton);
                this.revalidate();
                this.repaint();
            }
            this.closeAction.setEnabled(true);
            this.state = n2;
        }
    }

    private void updateToggleButton(Action action, Icon icon) {
        this.toggleButton.setAction(action);
        this.toggleButton.setIcon(icon);
        this.toggleButton.setText(null);
    }

    private Frame getFrame() {
        Window window = this.getWindow();
        if (window instanceof Frame) {
            return (Frame)window;
        }
        return null;
    }

    private Window getWindow() {
        return this.window;
    }

    private String getTitle() {
        Window window = this.getWindow();
        if (window instanceof Frame) {
            return ((Frame)window).getTitle();
        }
        if (window instanceof Dialog) {
            return ((Dialog)window).getTitle();
        }
        return null;
    }

    public void paintComponent(Graphics graphics) {
        int n2;
        int n3;
        int n4;
        String string;
        int n5;
        MetalBumps metalBumps;
        Color color;
        Color color2;
        Color color3;
        if (this.getFrame() != null) {
            this.setState(this.getFrame().getExtendedState());
        }
        JRootPane jRootPane = this.getRootPane();
        Window window = this.getWindow();
        boolean bl2 = window == null ? jRootPane.getComponentOrientation().isLeftToRight() : window.getComponentOrientation().isLeftToRight();
        boolean bl3 = window == null ? true : window.isActive();
        int n6 = this.getWidth();
        int n7 = this.getHeight();
        if (bl3) {
            color3 = this.activeBackground;
            color2 = this.activeForeground;
            color = this.activeShadow;
            metalBumps = this.activeBumps;
        } else {
            color3 = this.inactiveBackground;
            color2 = this.inactiveForeground;
            color = this.inactiveShadow;
            metalBumps = this.inactiveBumps;
        }
        graphics.setColor(color3);
        graphics.fillRect(0, 0, n6, n7);
        graphics.setColor(color);
        graphics.drawLine(0, n7 - 1, n6, n7 - 1);
        graphics.drawLine(0, 0, 0, 0);
        graphics.drawLine(n6 - 1, 0, n6 - 1, 0);
        int n8 = n5 = bl2 ? 5 : n6 - 5;
        if (this.getWindowDecorationStyle() == 1) {
            n5 += bl2 ? 21 : -21;
        }
        if ((string = this.getTitle()) != null) {
            FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(jRootPane, graphics);
            graphics.setColor(color2);
            n4 = (n7 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
            Rectangle rectangle = new Rectangle(0, 0, 0, 0);
            if (this.iconifyButton != null && this.iconifyButton.getParent() != null) {
                rectangle = this.iconifyButton.getBounds();
            }
            if (bl2) {
                if (rectangle.x == 0) {
                    rectangle.x = window.getWidth() - window.getInsets().right - 2;
                }
                n3 = rectangle.x - n5 - 4;
                string = SwingUtilities2.clipStringIfNecessary(jRootPane, fontMetrics, string, n3);
            } else {
                n3 = n5 - rectangle.x - rectangle.width - 4;
                string = SwingUtilities2.clipStringIfNecessary(jRootPane, fontMetrics, string, n3);
                n5 -= SwingUtilities2.stringWidth(jRootPane, fontMetrics, string);
            }
            int n9 = SwingUtilities2.stringWidth(jRootPane, fontMetrics, string);
            SwingUtilities2.drawString((JComponent)jRootPane, graphics, string, n5, n4);
            n5 += bl2 ? n9 + 5 : -5;
        }
        if (bl2) {
            n4 = n6 - this.buttonsWidth - n5 - 5;
            n2 = n5;
        } else {
            n4 = n5 - this.buttonsWidth - 5;
            n2 = this.buttonsWidth + 5;
        }
        int n10 = 3;
        n3 = this.getHeight() - 2 * n10;
        metalBumps.setBumpArea(n4, n3);
        metalBumps.paintIcon(this, graphics, n2, n10);
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(UIManager.getString((Object)"MetalTitlePane.closeTitle", MetalTitlePane.this.getLocale()));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MetalTitlePane.this.close();
        }
    }

    private class IconifyAction
    extends AbstractAction {
        public IconifyAction() {
            super(UIManager.getString((Object)"MetalTitlePane.iconifyTitle", MetalTitlePane.this.getLocale()));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MetalTitlePane.this.iconify();
        }
    }

    private class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            super(UIManager.getString((Object)"MetalTitlePane.maximizeTitle", MetalTitlePane.this.getLocale()));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MetalTitlePane.this.maximize();
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("resizable".equals(string) || "state".equals(string)) {
                Frame frame = MetalTitlePane.this.getFrame();
                if (frame != null) {
                    MetalTitlePane.this.setState(frame.getExtendedState(), true);
                }
                if ("resizable".equals(string)) {
                    MetalTitlePane.this.getRootPane().repaint();
                }
            } else if ("title".equals(string)) {
                MetalTitlePane.this.repaint();
            } else if ("componentOrientation".equals(string) || "iconImage".equals(string)) {
                MetalTitlePane.this.revalidate();
                MetalTitlePane.this.repaint();
            }
        }
    }

    private class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            super(UIManager.getString((Object)"MetalTitlePane.restoreTitle", MetalTitlePane.this.getLocale()));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MetalTitlePane.this.restore();
        }
    }

    private class SystemMenuBar
    extends JMenuBar {
        private SystemMenuBar() {
        }

        public void paint(Graphics graphics) {
            Image image;
            Frame frame = MetalTitlePane.this.getFrame();
            if (this.isOpaque()) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            Image image2 = image = frame != null ? frame.getIconImage() : null;
            if (image != null) {
                graphics.drawImage(image, 0, 0, 16, 16, null);
            } else {
                Icon icon = UIManager.getIcon("InternalFrame.icon");
                if (icon != null) {
                    icon.paintIcon(this, graphics, 0, 0);
                }
            }
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(Math.max(16, dimension.width), Math.max(dimension.height, 16));
        }
    }

    private class TitlePaneLayout
    implements LayoutManager {
        private TitlePaneLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            int n2 = this.computeHeight();
            return new Dimension(n2, n2);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        private int computeHeight() {
            FontMetrics fontMetrics = MetalTitlePane.this.rootPane.getFontMetrics(MetalTitlePane.this.getFont());
            int n2 = fontMetrics.getHeight();
            n2 += 7;
            int n3 = 0;
            if (MetalTitlePane.this.getWindowDecorationStyle() == 1) {
                n3 = 16;
            }
            int n4 = Math.max(n2, n3);
            return n4;
        }

        public void layoutContainer(Container container) {
            int n2;
            int n3;
            boolean bl2 = MetalTitlePane.this.window == null ? MetalTitlePane.this.getRootPane().getComponentOrientation().isLeftToRight() : MetalTitlePane.this.window.getComponentOrientation().isLeftToRight();
            int n4 = MetalTitlePane.this.getWidth();
            int n5 = 3;
            if (MetalTitlePane.this.closeButton != null && MetalTitlePane.this.closeButton.getIcon() != null) {
                n3 = MetalTitlePane.this.closeButton.getIcon().getIconHeight();
                n2 = MetalTitlePane.this.closeButton.getIcon().getIconWidth();
            } else {
                n3 = 16;
                n2 = 16;
            }
            int n6 = bl2 ? n4 : 0;
            int n7 = 5;
            int n8 = n6 = bl2 ? n7 : n4 - n2 - n7;
            if (MetalTitlePane.this.menuBar != null) {
                MetalTitlePane.this.menuBar.setBounds(n6, n5, n2, n3);
            }
            n6 = bl2 ? n4 : 0;
            n7 = 4;
            n6 += bl2 ? -n7 - n2 : n7;
            if (MetalTitlePane.this.closeButton != null) {
                MetalTitlePane.this.closeButton.setBounds(n6, n5, n2, n3);
            }
            if (!bl2) {
                n6 += n2;
            }
            if (MetalTitlePane.this.getWindowDecorationStyle() == 1) {
                if (Toolkit.getDefaultToolkit().isFrameStateSupported(6) && MetalTitlePane.this.toggleButton.getParent() != null) {
                    n7 = 10;
                    MetalTitlePane.this.toggleButton.setBounds(n6 += bl2 ? -n7 - n2 : n7, n5, n2, n3);
                    if (!bl2) {
                        n6 += n2;
                    }
                }
                if (MetalTitlePane.this.iconifyButton != null && MetalTitlePane.this.iconifyButton.getParent() != null) {
                    n7 = 2;
                    MetalTitlePane.this.iconifyButton.setBounds(n6 += bl2 ? -n7 - n2 : n7, n5, n2, n3);
                    if (!bl2) {
                        n6 += n2;
                    }
                }
            }
            MetalTitlePane.this.buttonsWidth = bl2 ? n4 - n6 : n6;
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        public void windowActivated(WindowEvent windowEvent) {
            MetalTitlePane.this.setActive(true);
        }

        public void windowDeactivated(WindowEvent windowEvent) {
            MetalTitlePane.this.setActive(false);
        }
    }
}

