/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Types;
import javax.sql.RowSetMetaData;

public class RowSetMetaDataImpl
implements RowSetMetaData,
Serializable {
    private int colCount;
    private ColInfo[] colInfo;
    static final long serialVersionUID = 6893806403181801867L;

    private void checkColRange(int n2) throws SQLException {
        if (n2 <= 0 || n2 > this.colCount) {
            throw new SQLException("Invalid column index :" + n2);
        }
    }

    private void checkColType(int n2) throws SQLException {
        try {
            Class<Types> clazz = Types.class;
            Field[] fieldArray = clazz.getFields();
            int n3 = 0;
            for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                n3 = fieldArray[i2].getInt(clazz);
                if (n3 != n2) continue;
                return;
            }
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
        throw new SQLException("Invalid SQL type for column");
    }

    public void setColumnCount(int n2) throws SQLException {
        if (n2 <= 0) {
            throw new SQLException("Invalid column count. Cannot be less or equal to zero");
        }
        this.colCount = n2;
        if (this.colCount != Integer.MAX_VALUE) {
            this.colInfo = new ColInfo[this.colCount + 1];
            for (int i2 = 1; i2 <= this.colCount; ++i2) {
                this.colInfo[i2] = new ColInfo();
            }
        }
    }

    public void setAutoIncrement(int n2, boolean bl2) throws SQLException {
        this.checkColRange(n2);
        this.colInfo[n2].autoIncrement = bl2;
    }

    public void setCaseSensitive(int n2, boolean bl2) throws SQLException {
        this.checkColRange(n2);
        this.colInfo[n2].caseSensitive = bl2;
    }

    public void setSearchable(int n2, boolean bl2) throws SQLException {
        this.checkColRange(n2);
        this.colInfo[n2].searchable = bl2;
    }

    public void setCurrency(int n2, boolean bl2) throws SQLException {
        this.checkColRange(n2);
        this.colInfo[n2].currency = bl2;
    }

    public void setNullable(int n2, int n3) throws SQLException {
        if (n3 < 0 || n3 > 2) {
            throw new SQLException("Invalid nullable constant set. Must be either columnNoNulls, columnNullable or columnNullableUnknown");
        }
        this.checkColRange(n2);
        this.colInfo[n2].nullable = n3;
    }

    public void setSigned(int n2, boolean bl2) throws SQLException {
        this.checkColRange(n2);
        this.colInfo[n2].signed = bl2;
    }

    public void setColumnDisplaySize(int n2, int n3) throws SQLException {
        if (n3 < 0) {
            throw new SQLException("Invalid column display size. Cannot be less than zero");
        }
        this.checkColRange(n2);
        this.colInfo[n2].columnDisplaySize = n3;
    }

    public void setColumnLabel(int n2, String string) throws SQLException {
        this.checkColRange(n2);
        this.colInfo[n2].columnLabel = string != null ? new String(string) : new String("");
    }

    public void setColumnName(int n2, String string) throws SQLException {
        this.checkColRange(n2);
        this.colInfo[n2].columnName = string != null ? new String(string) : new String("");
    }

    public void setSchemaName(int n2, String string) throws SQLException {
        this.checkColRange(n2);
        this.colInfo[n2].schemaName = string != null ? new String(string) : new String("");
    }

    public void setPrecision(int n2, int n3) throws SQLException {
        if (n3 < 0) {
            throw new SQLException("Invalid precision value. Cannot be less than zero");
        }
        this.checkColRange(n2);
        this.colInfo[n2].colPrecision = n3;
    }

    public void setScale(int n2, int n3) throws SQLException {
        if (n3 < 0) {
            throw new SQLException("Invalid scale size. Cannot be less than zero");
        }
        this.checkColRange(n2);
        this.colInfo[n2].colScale = n3;
    }

    public void setTableName(int n2, String string) throws SQLException {
        this.checkColRange(n2);
        this.colInfo[n2].tableName = string != null ? new String(string) : new String("");
    }

    public void setCatalogName(int n2, String string) throws SQLException {
        this.checkColRange(n2);
        this.colInfo[n2].catName = string != null ? new String(string) : new String("");
    }

    public void setColumnType(int n2, int n3) throws SQLException {
        this.checkColType(n3);
        this.checkColRange(n2);
        this.colInfo[n2].colType = n3;
    }

    public void setColumnTypeName(int n2, String string) throws SQLException {
        this.checkColRange(n2);
        this.colInfo[n2].colTypeName = string != null ? new String(string) : new String("");
    }

    public int getColumnCount() throws SQLException {
        return this.colCount;
    }

    public boolean isAutoIncrement(int n2) throws SQLException {
        this.checkColRange(n2);
        return this.colInfo[n2].autoIncrement;
    }

    public boolean isCaseSensitive(int n2) throws SQLException {
        this.checkColRange(n2);
        return this.colInfo[n2].caseSensitive;
    }

    public boolean isSearchable(int n2) throws SQLException {
        this.checkColRange(n2);
        return this.colInfo[n2].searchable;
    }

    public boolean isCurrency(int n2) throws SQLException {
        this.checkColRange(n2);
        return this.colInfo[n2].currency;
    }

    public int isNullable(int n2) throws SQLException {
        this.checkColRange(n2);
        return this.colInfo[n2].nullable;
    }

    public boolean isSigned(int n2) throws SQLException {
        this.checkColRange(n2);
        return this.colInfo[n2].signed;
    }

    public int getColumnDisplaySize(int n2) throws SQLException {
        this.checkColRange(n2);
        return this.colInfo[n2].columnDisplaySize;
    }

    public String getColumnLabel(int n2) throws SQLException {
        this.checkColRange(n2);
        return this.colInfo[n2].columnLabel;
    }

    public String getColumnName(int n2) throws SQLException {
        this.checkColRange(n2);
        return this.colInfo[n2].columnName;
    }

    public String getSchemaName(int n2) throws SQLException {
        this.checkColRange(n2);
        String string = "";
        if (this.colInfo[n2].schemaName != null) {
            string = this.colInfo[n2].schemaName;
        }
        return string;
    }

    public int getPrecision(int n2) throws SQLException {
        this.checkColRange(n2);
        return this.colInfo[n2].colPrecision;
    }

    public int getScale(int n2) throws SQLException {
        this.checkColRange(n2);
        return this.colInfo[n2].colScale;
    }

    public String getTableName(int n2) throws SQLException {
        this.checkColRange(n2);
        return this.colInfo[n2].tableName;
    }

    public String getCatalogName(int n2) throws SQLException {
        this.checkColRange(n2);
        String string = "";
        if (this.colInfo[n2].catName != null) {
            string = this.colInfo[n2].catName;
        }
        return string;
    }

    public int getColumnType(int n2) throws SQLException {
        this.checkColRange(n2);
        return this.colInfo[n2].colType;
    }

    public String getColumnTypeName(int n2) throws SQLException {
        this.checkColRange(n2);
        return this.colInfo[n2].colTypeName;
    }

    public boolean isReadOnly(int n2) throws SQLException {
        this.checkColRange(n2);
        return this.colInfo[n2].readOnly;
    }

    public boolean isWritable(int n2) throws SQLException {
        this.checkColRange(n2);
        return this.colInfo[n2].writable;
    }

    public boolean isDefinitelyWritable(int n2) throws SQLException {
        return true;
    }

    public String getColumnClassName(int n2) throws SQLException {
        String string = new String().getClass().getName();
        int n3 = this.getColumnType(n2);
        switch (n3) {
            case 2: 
            case 3: {
                string = new BigDecimal(0).getClass().getName();
                break;
            }
            case -7: {
                string = new Boolean(false).getClass().getName();
                break;
            }
            case -6: {
                string = new Byte("0").getClass().getName();
                break;
            }
            case 5: {
                string = new Short("0").getClass().getName();
                break;
            }
            case 4: {
                string = new Integer(0).getClass().getName();
                break;
            }
            case -5: {
                string = new Long(0L).getClass().getName();
                break;
            }
            case 7: {
                string = new Float(0.0f).getClass().getName();
                break;
            }
            case 6: 
            case 8: {
                string = new Double(0.0).getClass().getName();
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                byte[] byArray = new byte[]{};
                string = byArray.getClass().getName();
                break;
            }
            case 91: {
                string = new Date(123456L).getClass().getName();
                break;
            }
            case 92: {
                string = new Time(123456L).getClass().getName();
                break;
            }
            case 93: {
                string = new Timestamp(123456L).getClass().getName();
                break;
            }
            case 2004: {
                byte[] byArray = new byte[]{};
                string = byArray.getClass().getName();
                break;
            }
            case 2005: {
                char[] cArray = new char[]{};
                string = cArray.getClass().getName();
            }
        }
        return string;
    }

    private class ColInfo
    implements Serializable {
        public boolean autoIncrement;
        public boolean caseSensitive;
        public boolean currency;
        public int nullable;
        public boolean signed;
        public boolean searchable;
        public int columnDisplaySize;
        public String columnLabel;
        public String columnName;
        public String schemaName;
        public int colPrecision;
        public int colScale;
        public String tableName = "";
        public String catName;
        public int colType;
        public String colTypeName;
        public boolean readOnly = false;
        public boolean writable = true;

        private ColInfo() {
        }
    }
}

