/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.ldap;

import java.util.ArrayList;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.ldap.Rdn;

final class Rfc2253Parser {
    private final String name;
    private final char[] chars;
    private final int len;
    private int cur = 0;

    Rfc2253Parser(String string) {
        this.name = string;
        this.len = string.length();
        this.chars = string.toCharArray();
    }

    List parseDn() throws InvalidNameException {
        this.cur = 0;
        ArrayList<Rdn> arrayList = new ArrayList<Rdn>(this.len / 3 + 10);
        if (this.len == 0) {
            return arrayList;
        }
        arrayList.add(this.doParse(new Rdn()));
        while (this.cur < this.len) {
            if (this.chars[this.cur] == ',' || this.chars[this.cur] == ';') {
                ++this.cur;
                arrayList.add(0, this.doParse(new Rdn()));
                continue;
            }
            throw new InvalidNameException("Invalid name: " + this.name);
        }
        return arrayList;
    }

    Rdn parseRdn() throws InvalidNameException {
        return this.parseRdn(new Rdn());
    }

    Rdn parseRdn(Rdn rdn) throws InvalidNameException {
        rdn = this.doParse(rdn);
        if (this.cur < this.len) {
            throw new InvalidNameException("Invalid RDN: " + this.name);
        }
        return rdn;
    }

    private Rdn doParse(Rdn rdn) throws InvalidNameException {
        while (this.cur < this.len) {
            this.consumeWhitespace();
            String string = this.parseAttrType();
            this.consumeWhitespace();
            if (this.cur >= this.len || this.chars[this.cur] != '=') {
                throw new InvalidNameException("Invalid name: " + this.name);
            }
            ++this.cur;
            this.consumeWhitespace();
            String string2 = this.parseAttrValue();
            this.consumeWhitespace();
            rdn.put(string, Rdn.unescapeValue(string2));
            if (this.cur >= this.len || this.chars[this.cur] != '+') break;
            ++this.cur;
        }
        rdn.sort();
        return rdn;
    }

    private String parseAttrType() throws InvalidNameException {
        char c2;
        int n2 = this.cur;
        while (this.cur < this.len && (Character.isLetterOrDigit(c2 = this.chars[this.cur]) || c2 == '.' || c2 == '-' || c2 == ' ')) {
            ++this.cur;
        }
        while (this.cur > n2 && this.chars[this.cur - 1] == ' ') {
            --this.cur;
        }
        if (n2 == this.cur) {
            throw new InvalidNameException("Invalid name: " + this.name);
        }
        return new String(this.chars, n2, this.cur - n2);
    }

    private String parseAttrValue() throws InvalidNameException {
        if (this.cur < this.len && this.chars[this.cur] == '#') {
            return this.parseBinaryAttrValue();
        }
        if (this.cur < this.len && this.chars[this.cur] == '\"') {
            return this.parseQuotedAttrValue();
        }
        return this.parseStringAttrValue();
    }

    private String parseBinaryAttrValue() throws InvalidNameException {
        int n2 = this.cur++;
        while (this.cur < this.len && Character.isLetterOrDigit(this.chars[this.cur])) {
            ++this.cur;
        }
        return new String(this.chars, n2, this.cur - n2);
    }

    private String parseQuotedAttrValue() throws InvalidNameException {
        int n2 = this.cur++;
        while (this.cur < this.len && this.chars[this.cur] != '\"') {
            if (this.chars[this.cur] == '\\') {
                ++this.cur;
            }
            ++this.cur;
        }
        if (this.cur >= this.len) {
            throw new InvalidNameException("Invalid name: " + this.name);
        }
        ++this.cur;
        return new String(this.chars, n2, this.cur - n2);
    }

    private String parseStringAttrValue() throws InvalidNameException {
        int n2;
        int n3 = this.cur;
        int n4 = -1;
        while (this.cur < this.len && !this.atTerminator()) {
            if (this.chars[this.cur] == '\\') {
                n4 = ++this.cur;
            }
            ++this.cur;
        }
        if (this.cur > this.len) {
            throw new InvalidNameException("Invalid name: " + this.name);
        }
        for (n2 = this.cur; n2 > n3 && Rfc2253Parser.isWhitespace(this.chars[n2 - 1]) && n4 != n2 - 1; --n2) {
        }
        return new String(this.chars, n3, n2 - n3);
    }

    private void consumeWhitespace() {
        while (this.cur < this.len && Rfc2253Parser.isWhitespace(this.chars[this.cur])) {
            ++this.cur;
        }
    }

    private boolean atTerminator() {
        return this.cur < this.len && (this.chars[this.cur] == ',' || this.chars[this.cur] == ';' || this.chars[this.cur] == '+');
    }

    private static boolean isWhitespace(char c2) {
        return c2 == ' ' || c2 == '\r';
    }
}

