/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedHashMap<K, V>
extends HashMap<K, V>
implements Map<K, V> {
    private static final long serialVersionUID = 3801124242820219131L;
    private transient Entry<K, V> header;
    private final boolean accessOrder;

    public LinkedHashMap(int n2, float f2) {
        super(n2, f2);
        this.accessOrder = false;
    }

    public LinkedHashMap(int n2) {
        super(n2);
        this.accessOrder = false;
    }

    public LinkedHashMap() {
        this.accessOrder = false;
    }

    public LinkedHashMap(Map<? extends K, ? extends V> map) {
        super(map);
        this.accessOrder = false;
    }

    public LinkedHashMap(int n2, float f2, boolean bl2) {
        super(n2, f2);
        this.accessOrder = bl2;
    }

    @Override
    void init() {
        this.header = new Entry<Object, Object>(-1, null, null, null);
        this.header.after = this.header;
        this.header.before = this.header.after;
    }

    @Override
    void transfer(HashMap.Entry[] entryArray) {
        int n2 = entryArray.length;
        Entry entry = this.header.after;
        while (entry != this.header) {
            int n3 = LinkedHashMap.indexFor(entry.hash, n2);
            entry.next = entryArray[n3];
            entryArray[n3] = entry;
            entry = entry.after;
        }
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            Entry entry = this.header.after;
            while (entry != this.header) {
                if (entry.value == null) {
                    return true;
                }
                entry = entry.after;
            }
        } else {
            Entry entry = this.header.after;
            while (entry != this.header) {
                if (object.equals(entry.value)) {
                    return true;
                }
                entry = entry.after;
            }
        }
        return false;
    }

    @Override
    public V get(Object object) {
        Entry entry = (Entry)this.getEntry(object);
        if (entry == null) {
            return null;
        }
        entry.recordAccess(this);
        return (V)entry.value;
    }

    @Override
    public void clear() {
        super.clear();
        this.header.after = this.header;
        this.header.before = this.header.after;
    }

    @Override
    Iterator<K> newKeyIterator() {
        return new KeyIterator();
    }

    @Override
    Iterator<V> newValueIterator() {
        return new ValueIterator();
    }

    @Override
    Iterator<Map.Entry<K, V>> newEntryIterator() {
        return new EntryIterator();
    }

    @Override
    void addEntry(int n2, K k2, V v2, int n3) {
        this.createEntry(n2, k2, v2, n3);
        Entry entry = this.header.after;
        if (this.removeEldestEntry(entry)) {
            this.removeEntryForKey(entry.key);
        } else if (this.size >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    @Override
    void createEntry(int n2, K k2, V v2, int n3) {
        Entry<K, V> entry;
        HashMap.Entry entry2 = this.table[n3];
        this.table[n3] = entry = new Entry<K, V>(n2, k2, v2, entry2);
        ((Entry)entry).addBefore((Entry)this.header);
        ++this.size;
    }

    protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<K, V>
    extends HashMap.Entry<K, V> {
        Entry<K, V> before;
        Entry<K, V> after;

        Entry(int n2, K k2, V v2, HashMap.Entry<K, V> entry) {
            super(n2, k2, v2, entry);
        }

        private void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        private void addBefore(Entry<K, V> entry) {
            this.after = entry;
            this.before = entry.before;
            this.before.after = this;
            this.after.before = this;
        }

        @Override
        void recordAccess(HashMap<K, V> hashMap) {
            LinkedHashMap linkedHashMap = (LinkedHashMap)hashMap;
            if (linkedHashMap.accessOrder) {
                ++linkedHashMap.modCount;
                this.remove();
                this.addBefore(linkedHashMap.header);
            }
        }

        @Override
        void recordRemoval(HashMap<K, V> hashMap) {
            this.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends LinkedHashIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyIterator
    extends LinkedHashIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class LinkedHashIterator<T>
    implements Iterator<T> {
        Entry<K, V> nextEntry;
        Entry<K, V> lastReturned;
        int expectedModCount;

        private LinkedHashIterator() {
            this.nextEntry = ((LinkedHashMap)LinkedHashMap.this).header.after;
            this.lastReturned = null;
            this.expectedModCount = LinkedHashMap.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry != LinkedHashMap.this.header;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (LinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            LinkedHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
            this.expectedModCount = LinkedHashMap.this.modCount;
        }

        Entry<K, V> nextEntry() {
            if (LinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextEntry == LinkedHashMap.this.header) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextEntry;
            Entry entry = this.lastReturned;
            this.nextEntry = entry.after;
            return entry;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueIterator
    extends LinkedHashIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }
}

