/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceEvent;

public class DragSourceDragEvent
extends DragSourceEvent {
    private static final long serialVersionUID = 481346297933902471L;
    private static final int JDK_1_3_MODIFIERS = 63;
    private static final int JDK_1_4_MODIFIERS = 16320;
    private int targetActions = 0;
    private int dropAction = 0;
    private int gestureModifiers = 0;
    private boolean invalidModifiers;

    public DragSourceDragEvent(DragSourceContext dragSourceContext, int n2, int n3, int n4) {
        super(dragSourceContext);
        this.targetActions = n3;
        this.gestureModifiers = n4;
        this.dropAction = n2;
        if ((n4 & 0xFFFFC000) != 0) {
            this.invalidModifiers = true;
        } else if (this.getGestureModifiers() != 0 && this.getGestureModifiersEx() == 0) {
            this.setNewModifiers();
        } else if (this.getGestureModifiers() == 0 && this.getGestureModifiersEx() != 0) {
            this.setOldModifiers();
        } else {
            this.invalidModifiers = true;
        }
    }

    public DragSourceDragEvent(DragSourceContext dragSourceContext, int n2, int n3, int n4, int n5, int n6) {
        super(dragSourceContext, n5, n6);
        this.targetActions = n3;
        this.gestureModifiers = n4;
        this.dropAction = n2;
        if ((n4 & 0xFFFFC000) != 0) {
            this.invalidModifiers = true;
        } else if (this.getGestureModifiers() != 0 && this.getGestureModifiersEx() == 0) {
            this.setNewModifiers();
        } else if (this.getGestureModifiers() == 0 && this.getGestureModifiersEx() != 0) {
            this.setOldModifiers();
        } else {
            this.invalidModifiers = true;
        }
    }

    public int getTargetActions() {
        return this.targetActions;
    }

    public int getGestureModifiers() {
        return this.invalidModifiers ? this.gestureModifiers : this.gestureModifiers & 0x3F;
    }

    public int getGestureModifiersEx() {
        return this.invalidModifiers ? this.gestureModifiers : this.gestureModifiers & 0x3FC0;
    }

    public int getUserAction() {
        return this.dropAction;
    }

    public int getDropAction() {
        return this.dropAction & this.targetActions & this.getDragSourceContext().getSourceActions();
    }

    private void setNewModifiers() {
        if ((this.gestureModifiers & 0x10) != 0) {
            this.gestureModifiers |= 0x400;
        }
        if ((this.gestureModifiers & 8) != 0) {
            this.gestureModifiers |= 0x800;
        }
        if ((this.gestureModifiers & 4) != 0) {
            this.gestureModifiers |= 0x1000;
        }
        if ((this.gestureModifiers & 1) != 0) {
            this.gestureModifiers |= 0x40;
        }
        if ((this.gestureModifiers & 2) != 0) {
            this.gestureModifiers |= 0x80;
        }
        if ((this.gestureModifiers & 0x20) != 0) {
            this.gestureModifiers |= 0x2000;
        }
    }

    private void setOldModifiers() {
        if ((this.gestureModifiers & 0x400) != 0) {
            this.gestureModifiers |= 0x10;
        }
        if ((this.gestureModifiers & 0x800) != 0) {
            this.gestureModifiers |= 8;
        }
        if ((this.gestureModifiers & 0x1000) != 0) {
            this.gestureModifiers |= 4;
        }
        if ((this.gestureModifiers & 0x40) != 0) {
            this.gestureModifiers |= 1;
        }
        if ((this.gestureModifiers & 0x80) != 0) {
            this.gestureModifiers |= 2;
        }
        if ((this.gestureModifiers & 0x2000) != 0) {
            this.gestureModifiers |= 0x20;
        }
    }
}

