/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.ImageCapabilities;
import java.awt.Toolkit;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.ReplicateScaleFilter;

public abstract class Image {
    private static ImageCapabilities defaultImageCaps = new ImageCapabilities(false);
    protected float accelerationPriority = 0.5f;
    public static final Object UndefinedProperty = new Object();
    public static final int SCALE_DEFAULT = 1;
    public static final int SCALE_FAST = 2;
    public static final int SCALE_SMOOTH = 4;
    public static final int SCALE_REPLICATE = 8;
    public static final int SCALE_AREA_AVERAGING = 16;

    public abstract int getWidth(ImageObserver var1);

    public abstract int getHeight(ImageObserver var1);

    public abstract ImageProducer getSource();

    public abstract Graphics getGraphics();

    public abstract Object getProperty(String var1, ImageObserver var2);

    public Image getScaledInstance(int n2, int n3, int n4) {
        ReplicateScaleFilter replicateScaleFilter = (n4 & 0x14) != 0 ? new AreaAveragingScaleFilter(n2, n3) : new ReplicateScaleFilter(n2, n3);
        FilteredImageSource filteredImageSource = new FilteredImageSource(this.getSource(), replicateScaleFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    public abstract void flush();

    public ImageCapabilities getCapabilities(GraphicsConfiguration graphicsConfiguration) {
        return defaultImageCaps;
    }

    public void setAccelerationPriority(float f2) {
        if (f2 < 0.0f || f2 > 1.0f) {
            throw new IllegalArgumentException("Priority must be a value between 0 and 1, inclusive");
        }
        this.accelerationPriority = f2;
    }

    public float getAccelerationPriority() {
        return this.accelerationPriority;
    }
}

