/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertSelector;
import java.security.cert.PKIXParameters;
import java.util.Set;

public class PKIXBuilderParameters
extends PKIXParameters {
    private int maxPathLength;

    public PKIXBuilderParameters(KeyStore keystore, CertSelector targetConstraints) throws KeyStoreException, InvalidAlgorithmParameterException {
        super(keystore);
        this.setTargetCertConstraints(targetConstraints);
        this.maxPathLength = 5;
    }

    public PKIXBuilderParameters(Set trustAnchors, CertSelector targetConstraints) throws InvalidAlgorithmParameterException {
        super(trustAnchors);
        this.setTargetCertConstraints(targetConstraints);
        this.maxPathLength = 5;
    }

    public int getMaxPathLength() {
        return this.maxPathLength;
    }

    public void setMaxPathLength(int maxPathLength) {
        if (maxPathLength < -1) {
            throw new IllegalArgumentException();
        }
        this.maxPathLength = maxPathLength;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        buf.insert(buf.length() - 2, "; Max Path Length=" + this.maxPathLength);
        return buf.toString();
    }
}

