// -*- Mode: C++; c-basic-offset: 2; indent-tabs-mode: nil; tab-width: 8; -*-

/***************************************************************************
    nspanel.cpp
    Marcus Camen  <mcamen@mcamen.de>
***************************************************************************/

/*
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this library; see the file COPYING.LIB.  If not, write to
  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
*/

#include <klistbox.h>
#include <kpushbutton.h>
#include <klineedit.h>
#include <qstringlist.h>
#include "sidebarsettings.h"
#include "configfeeds.h"


namespace KSB_News {

ConfigFeeds::ConfigFeeds( QWidget* parent, const char* name ) : ConfigFeedsBase( parent, name )
{
  // read confguration from disk
  m_feedlist = SidebarSettings::sources();
  feedListbox->insertStringList( m_feedlist );

  connect( addButton, SIGNAL( clicked() ), SLOT( slotAdd() ) );
  connect( editButton, SIGNAL( clicked() ), SLOT( slotEdit() ) );
  connect( removeButton, SIGNAL( clicked() ), SLOT( slotRemove() ) );
  connect( feedListbox, SIGNAL( selectionChanged( QListBoxItem *) ),
           SLOT( slotCurrentChanged( QListBoxItem *) ) );
  connect( feedURL, SIGNAL( textChanged( const QString & ) ),
           SLOT( slotUrlChanged( const QString & ) ) );
}


void ConfigFeeds::slotAdd()
{
  feedListbox->insertItem( feedURL->text() );
  QListBoxItem *item = feedListbox->findItem( feedURL->text() );
  feedListbox->setCurrentItem( item );

  feedListbox->ensureCurrentVisible();
  m_feedlist.append( feedURL->text() );

  if ( ! removeButton->isEnabled() ) {
    removeButton->setEnabled( TRUE );
    editButton->setEnabled( TRUE );
  }
}


void ConfigFeeds::slotEdit()
{
  feedListbox->changeItem( feedURL->text(), feedListbox->currentItem() );

  m_feedlist.clear();
  for ( uint i = 0; i < feedListbox->count(); i++ ) {
    m_feedlist.append( feedListbox->text(i) );
  }
}


void ConfigFeeds::slotRemove()
{
  feedListbox->removeItem( feedListbox->currentItem() );

  m_feedlist.clear();
  for ( uint i = 0; i < feedListbox->count(); i++ ) {
    m_feedlist.append( feedListbox->text(i) );
  }

  if ( feedListbox->count() == 0 ) {
    removeButton->setEnabled( FALSE );
    editButton->setEnabled( FALSE );
  }
}


void ConfigFeeds::slotCurrentChanged( QListBoxItem *item )
{
  if ( item ) {
    feedURL->setText( item->text() );
    addButton->setEnabled( TRUE );
    editButton->setEnabled( TRUE );
    removeButton->setEnabled( TRUE );
  } else {
    feedURL->clear();
    addButton->setEnabled( FALSE );
    editButton->setEnabled( FALSE );
    removeButton->setEnabled( FALSE );
  }
}


void ConfigFeeds::slotUrlChanged( const QString & text )
{
  if ( text.isEmpty() ) {
    addButton->setEnabled( FALSE );
    editButton->setEnabled( FALSE );
  } else {
    addButton->setEnabled( TRUE );
    editButton->setEnabled( TRUE );
  }
}


QStringList ConfigFeeds::getFeedlist()
{
  return m_feedlist;
}


} // namespace KSB_News

#include "configfeeds.moc"
