/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import sun.security.action.GetPropertyAction;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Config;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbAsRep;
import sun.security.krb5.KrbAsReq;
import sun.security.krb5.KrbException;
import sun.security.krb5.KrbTgsRep;
import sun.security.krb5.KrbTgsReq;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.RealmException;
import sun.security.krb5.ServiceName;
import sun.security.krb5.internal.HostAddresses;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Ticket;
import sun.security.krb5.internal.TicketFlags;
import sun.security.krb5.internal.a1;
import sun.security.krb5.internal.bs;
import sun.security.krb5.internal.ccache.an;
import sun.security.krb5.internal.ccache.as;
import sun.security.krb5.internal.crypto.k;
import sun.security.krb5.internal.ktab.ax;
import sun.security.krb5.internal.o;

public class Credentials {
    Ticket a;
    PrincipalName b;
    PrincipalName c;
    EncryptionKey d;
    TicketFlags e;
    KerberosTime f;
    KerberosTime g;
    KerberosTime h;
    KerberosTime i;
    HostAddresses j;
    EncryptionKey k;
    private static boolean l = bs.ed;
    private static an m;
    private static boolean n;
    private static boolean o;

    private static native Credentials acquireDefaultNativeCreds();

    public Credentials(Ticket ticket, PrincipalName principalName, PrincipalName principalName2, EncryptionKey encryptionKey, TicketFlags ticketFlags, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, KerberosTime kerberosTime4, HostAddresses hostAddresses) {
        this.a = ticket;
        this.b = principalName;
        this.c = principalName2;
        this.d = encryptionKey;
        this.e = ticketFlags;
        this.f = kerberosTime;
        this.g = kerberosTime2;
        this.h = kerberosTime3;
        this.i = kerberosTime4;
        this.j = hostAddresses;
    }

    public Credentials(byte[] byArray, String string, String string2, byte[] byArray2, int n2, boolean[] blArray, Date date, Date date2, Date date3, Date date4, InetAddress[] inetAddressArray) throws KrbException, IOException {
        this(new Ticket(byArray), new PrincipalName(string), new PrincipalName(string2), new EncryptionKey(n2, byArray2), blArray == null ? null : new TicketFlags(blArray), date == null ? null : new KerberosTime(date), date2 == null ? null : new KerberosTime(date2), date3 == null ? null : new KerberosTime(date3), date4 == null ? null : new KerberosTime(date4), null);
    }

    public boolean isValid() {
        boolean bl2 = true;
        if (this.h.getTime() < System.currentTimeMillis()) {
            bl2 = false;
        } else if (this.g.getTime() > System.currentTimeMillis() || this.g == null && this.f.getTime() > System.currentTimeMillis()) {
            bl2 = false;
        }
        return bl2;
    }

    public final PrincipalName getClient() {
        return this.b;
    }

    public final PrincipalName getServer() {
        return this.c;
    }

    public final EncryptionKey getSessionKey() {
        return this.d;
    }

    public final Date getAuthTime() {
        if (this.f != null) {
            return this.f.toDate();
        }
        return null;
    }

    public final Date getStartTime() {
        if (this.g != null) {
            return this.g.toDate();
        }
        return null;
    }

    public final Date getEndTime() {
        if (this.h != null) {
            return this.h.toDate();
        }
        return null;
    }

    public final Date getRenewTill() {
        if (this.i != null) {
            return this.i.toDate();
        }
        return null;
    }

    public final boolean[] getFlags() {
        if (this.e == null) {
            return null;
        }
        return this.e.a();
    }

    public final InetAddress[] getClientAddresses() {
        if (this.j == null) {
            return null;
        }
        return this.j.getInetAddresses();
    }

    public final byte[] getEncoded() {
        byte[] byArray;
        block4: {
            byArray = null;
            try {
                byArray = this.a.asn1Encode();
            }
            catch (Asn1Exception asn1Exception) {
                if (l) {
                    System.out.println(asn1Exception);
                }
            }
            catch (IOException iOException) {
                if (!l) break block4;
                System.out.println(iOException);
            }
        }
        return byArray;
    }

    public boolean isForwardable() {
        return this.e.a(1);
    }

    public boolean isRenewable() {
        return this.e.a(8);
    }

    public Ticket getTicket() {
        return this.a;
    }

    public TicketFlags getTicketFlags() {
        return this.e;
    }

    public boolean checkDelegate() {
        return this.e.a(13);
    }

    public Credentials renew() throws KrbException, IOException {
        o o2 = new o();
        o2.a(30, true);
        o2.a(8, true);
        KrbTgsReq krbTgsReq = new KrbTgsReq(o2, this, this.c, null, null, null, null, this.j, null, null, null);
        String string = null;
        KrbTgsRep krbTgsRep = null;
        try {
            string = krbTgsReq.send();
            krbTgsRep = krbTgsReq.getReply();
        }
        catch (KrbException krbException) {
            if (krbException.returnCode() == 52) {
                krbTgsReq.send(this.c.getRealmString(), string, true);
                krbTgsRep = krbTgsReq.getReply();
            }
            throw krbException;
        }
        return krbTgsRep.getCreds();
    }

    public static Credentials acquireTGTFromCache(PrincipalName principalName, String string) throws KrbException, IOException {
        Object object;
        if (string == null && ((String)(object = (String)AccessController.doPrivileged(new GetPropertyAction("os.name")))).toUpperCase().startsWith("WINDOWS")) {
            Credentials credentials = Credentials.acquireDefaultCreds();
            if (credentials == null) {
                if (l) {
                    System.out.println(">>> Found no TGT's in LSA");
                }
                return null;
            }
            if (principalName != null) {
                if (credentials.getClient().equals(principalName)) {
                    if (l) {
                        System.out.println(">>> Obtained TGT from LSA: " + credentials);
                    }
                    return credentials;
                }
                if (l) {
                    System.out.println(">>> LSA contains TGT for " + credentials.getClient() + " not " + principalName);
                }
                return null;
            }
            if (l) {
                System.out.println(">>> Obtained TGT from LSA: " + credentials);
            }
            return credentials;
        }
        object = an.a(principalName, string);
        if (object == null) {
            return null;
        }
        as as2 = ((an)object).c();
        if (sun.security.krb5.internal.crypto.k.b(as2.g())) {
            return as2.c();
        }
        if (l) {
            System.out.println(">>> unsupported key type found the default TGT: " + as2.g());
        }
        return null;
    }

    public static Credentials acquireTGT(PrincipalName principalName, EncryptionKey[] encryptionKeyArray) throws KrbException, IOException {
        if (principalName == null) {
            throw new IllegalArgumentException("Cannot have null principal to do AS-Exchange");
        }
        if (encryptionKeyArray == null) {
            throw new IllegalArgumentException("Cannot have null secretKey to do AS-Exchange");
        }
        KrbAsReq krbAsReq = new KrbAsReq(principalName, encryptionKeyArray);
        String string = null;
        KrbAsRep krbAsRep = null;
        try {
            string = krbAsReq.send();
            krbAsRep = krbAsReq.getReply(encryptionKeyArray);
        }
        catch (KrbException krbException) {
            if (krbException.returnCode() == 52) {
                krbAsReq.send(principalName.getRealmString(), string, true);
                krbAsRep = krbAsReq.getReply(encryptionKeyArray);
            }
            throw krbException;
        }
        return krbAsRep.getCreds();
    }

    public static synchronized Credentials acquireDefaultCreds() {
        Credentials credentials = null;
        if (m == null) {
            m = an.a();
        }
        if (m != null) {
            as as2;
            if (l) {
                System.out.println(">>> KrbCreds found the default ticket granting ticket in credential cache.");
            }
            if (sun.security.krb5.internal.crypto.k.b((as2 = m.c()).g())) {
                credentials = as2.c();
            } else if (l) {
                System.out.println(">>> unsupported key type found the default TGT: " + as2.g());
            }
        }
        if (credentials == null) {
            if (!o) {
                try {
                    Credentials.a();
                }
                catch (Exception exception) {
                    if (l) {
                        System.out.println("Can not load credentials cache");
                        exception.printStackTrace();
                    }
                    o = true;
                }
            }
            if (n) {
                if (l) {
                    System.out.println(">> Acquire default native Credentials");
                }
                credentials = Credentials.acquireDefaultNativeCreds();
            }
        }
        return credentials;
    }

    public static Credentials getServiceCreds(String string, File file) {
        Object object;
        EncryptionKey encryptionKey = null;
        PrincipalName principalName = null;
        Credentials credentials = null;
        try {
            principalName = new PrincipalName(string);
            if (principalName.getRealm() == null) {
                object = Config.getInstance().getDefaultRealm();
                if (object == null) {
                    return null;
                }
                principalName.setRealm((String)object);
            }
        }
        catch (RealmException realmException) {
            if (l) {
                realmException.printStackTrace();
            }
            return null;
        }
        catch (KrbException krbException) {
            if (l) {
                krbException.printStackTrace();
            }
            return null;
        }
        object = file == null ? ax.a() : ax.a(file);
        if (object != null && ((ax)object).c(principalName)) {
            encryptionKey = ((ax)object).a(principalName);
            credentials = new Credentials(null, principalName, null, null, null, null, null, null, null, null);
            credentials.k = encryptionKey;
        }
        return credentials;
    }

    public static Credentials acquireServiceCreds(String string, Credentials credentials) throws KrbException, IOException {
        return a1.a(string, credentials);
    }

    private static Credentials a(ServiceName serviceName, Credentials credentials) throws KrbException, IOException {
        KrbTgsReq krbTgsReq = new KrbTgsReq(new o(), credentials, serviceName, null, null, null, null, null, null, null, null);
        String string = null;
        KrbTgsRep krbTgsRep = null;
        try {
            string = krbTgsReq.send();
            krbTgsRep = krbTgsReq.getReply();
        }
        catch (KrbException krbException) {
            if (krbException.returnCode() == 52) {
                krbTgsReq.send(serviceName.getRealmString(), string, true);
                krbTgsRep = krbTgsReq.getReply();
            }
            throw krbException;
        }
        return krbTgsRep.getCreds();
    }

    public an getCache() {
        return m;
    }

    public EncryptionKey getServiceKey() {
        return this.k;
    }

    public static void printDebug(Credentials credentials) {
        System.out.println(">>> DEBUG: ----Credentials----");
        System.out.println("\tclient: " + credentials.b.toString());
        System.out.println("\tserver: " + credentials.c.toString());
        System.out.println("\tticket: realm: " + credentials.a.realm.toString());
        System.out.println("\t        sname: " + credentials.a.sname.toString());
        System.out.println("\tstartTime: " + credentials.g.getTime());
        System.out.println("\tendTime: " + credentials.h.getTime());
        System.out.println("        ----Credentials end----");
    }

    private static void a() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.loadLibrary("w2k_lsa_auth");
                return null;
            }
        });
        n = true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Credentials:");
        stringBuffer.append("\nclient=").append(this.b);
        stringBuffer.append("\nserver=").append(this.c);
        stringBuffer.append("\nauthTime=").append(this.f);
        stringBuffer.append("\nstartTime=").append(this.g);
        stringBuffer.append("\nendTime=").append(this.h);
        stringBuffer.append("\nrenewTill=").append(this.i);
        stringBuffer.append("\nflags: ").append(this.e);
        stringBuffer.append("\nEType (int): ").append(this.d.getEType());
        return stringBuffer.toString();
    }

    static {
        n = false;
        o = false;
    }
}

