/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import sun.font.CharToGlyphMapper;
import sun.font.NativeFont;
import sun.font.XMap;

public class NativeGlyphMapper
extends CharToGlyphMapper {
    NativeFont font;
    XMap xmapper;
    int numGlyphs;

    NativeGlyphMapper(NativeFont nativeFont) {
        this.font = nativeFont;
        this.xmapper = XMap.getXMapper(this.font.encoding);
        this.numGlyphs = nativeFont.getNumGlyphs();
        this.missingGlyph = 0;
    }

    public int getNumGlyphs() {
        return this.numGlyphs;
    }

    public int charToGlyph(char c2) {
        if (c2 >= this.xmapper.convertedGlyphs.length) {
            return 0;
        }
        return this.xmapper.convertedGlyphs[c2];
    }

    public int charToGlyph(int n2) {
        if (n2 >= this.xmapper.convertedGlyphs.length) {
            return 0;
        }
        return this.xmapper.convertedGlyphs[n2];
    }

    public void charsToGlyphs(int n2, char[] cArray, int[] nArray) {
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = cArray[i2];
            nArray[i2] = c2 >= this.xmapper.convertedGlyphs.length ? 0 : this.xmapper.convertedGlyphs[c2];
        }
    }

    public boolean charsToGlyphsNS(int n2, char[] cArray, int[] nArray) {
        this.charsToGlyphs(n2, cArray, nArray);
        return false;
    }

    public void charsToGlyphs(int n2, int[] nArray, int[] nArray2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = (char)nArray[i2];
            nArray2[i2] = c2 >= this.xmapper.convertedGlyphs.length ? 0 : this.xmapper.convertedGlyphs[c2];
        }
    }
}

