/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.ASCII;
import java.util.regex.Matcher;
import java.util.regex.PatternSyntaxException;
import sun.text.Normalizer;

public final class Pattern
implements Serializable {
    public static final int UNIX_LINES = 1;
    public static final int CASE_INSENSITIVE = 2;
    public static final int COMMENTS = 4;
    public static final int MULTILINE = 8;
    public static final int LITERAL = 16;
    public static final int DOTALL = 32;
    public static final int UNICODE_CASE = 64;
    public static final int CANON_EQ = 128;
    private static final long serialVersionUID = 5073258162644648461L;
    private String pattern;
    private int flags;
    private volatile transient boolean compiled = false;
    private transient String normalizedPattern;
    transient Node root;
    transient Node matchRoot;
    transient int[] buffer;
    transient GroupHead[] groupNodes;
    private transient int[] temp;
    transient int capturingGroupCount;
    transient int localCount;
    private transient int cursor;
    private transient int patternLength;
    static final int MAX_REPS = Integer.MAX_VALUE;
    static final int GREEDY = 0;
    static final int LAZY = 1;
    static final int POSSESSIVE = 2;
    static final int INDEPENDENT = 3;
    static Node accept = new Node();
    static Node lastAccept = new LastNode();

    public static Pattern compile(String string) {
        return new Pattern(string, 0);
    }

    public static Pattern compile(String string, int n2) {
        return new Pattern(string, n2);
    }

    public String pattern() {
        return this.pattern;
    }

    public String toString() {
        return this.pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Matcher matcher(CharSequence charSequence) {
        Object object = this;
        synchronized (object) {
            if (!this.compiled) {
                this.compile();
            }
        }
        object = new Matcher(this, charSequence);
        return object;
    }

    public int flags() {
        return this.flags;
    }

    public static boolean matches(String string, CharSequence charSequence) {
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = pattern.matcher(charSequence);
        return matcher.matches();
    }

    public String[] split(CharSequence charSequence, int n2) {
        int n3;
        int n4 = 0;
        boolean bl2 = n2 > 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        Matcher matcher = this.matcher(charSequence);
        while (matcher.find()) {
            String string;
            if (!bl2 || arrayList.size() < n2 - 1) {
                string = ((Object)charSequence.subSequence(n4, matcher.start())).toString();
                arrayList.add(string);
                n4 = matcher.end();
                continue;
            }
            if (arrayList.size() != n2 - 1) continue;
            string = ((Object)charSequence.subSequence(n4, charSequence.length())).toString();
            arrayList.add(string);
            n4 = matcher.end();
        }
        if (n4 == 0) {
            return new String[]{((Object)charSequence).toString()};
        }
        if (!bl2 || arrayList.size() < n2) {
            arrayList.add(((Object)charSequence.subSequence(n4, charSequence.length())).toString());
        }
        if (n2 == 0) {
            for (n3 = arrayList.size(); n3 > 0 && arrayList.get(n3 - 1).equals(""); --n3) {
            }
        }
        String[] stringArray = new String[n3];
        return arrayList.subList(0, n3).toArray(stringArray);
    }

    public String[] split(CharSequence charSequence) {
        return this.split(charSequence, 0);
    }

    public static String quote(String string) {
        int n2 = string.indexOf("\\E");
        if (n2 == -1) {
            return "\\Q" + string + "\\E";
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        stringBuilder.append("\\Q");
        n2 = 0;
        int n3 = 0;
        while ((n2 = string.indexOf("\\E", n3)) != -1) {
            stringBuilder.append(string.substring(n3, n2));
            n3 = n2 + 2;
            stringBuilder.append("\\E\\\\E\\Q");
        }
        stringBuilder.append(string.substring(n3, string.length()));
        stringBuilder.append("\\E");
        return stringBuilder.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.capturingGroupCount = 1;
        this.localCount = 0;
        this.compiled = false;
        if (this.pattern.length() == 0) {
            this.root = new Start(lastAccept);
            this.matchRoot = lastAccept;
            this.compiled = true;
        }
    }

    private Pattern(String string, int n2) {
        this.pattern = string;
        this.flags = n2;
        this.capturingGroupCount = 1;
        this.localCount = 0;
        if (this.pattern.length() > 0) {
            this.compile();
        } else {
            this.root = new Start(lastAccept);
            this.matchRoot = lastAccept;
        }
    }

    private void normalize() {
        int n2;
        boolean bl2 = false;
        int n3 = -1;
        this.normalizedPattern = Normalizer.decompose(this.pattern, false, 0);
        this.patternLength = this.normalizedPattern.length();
        StringBuilder stringBuilder = new StringBuilder(this.patternLength);
        for (int i2 = 0; i2 < this.patternLength; i2 += Character.charCount(n2)) {
            n2 = this.normalizedPattern.codePointAt(i2);
            if (Character.getType(n2) == 6 && n3 != -1) {
                StringBuilder stringBuilder2 = new StringBuilder();
                stringBuilder2.appendCodePoint(n3);
                stringBuilder2.appendCodePoint(n2);
                while (Character.getType(n2) == 6 && (i2 += Character.charCount(n2)) < this.patternLength) {
                    n2 = this.normalizedPattern.codePointAt(i2);
                    stringBuilder2.appendCodePoint(n2);
                }
                String string = this.produceEquivalentAlternation(stringBuilder2.toString());
                stringBuilder.setLength(stringBuilder.length() - Character.charCount(n3));
                stringBuilder.append("(?:").append(string).append(")");
            } else if (n2 == 91 && n3 != 92) {
                i2 = this.normalizeCharClass(stringBuilder, i2);
            } else {
                stringBuilder.appendCodePoint(n2);
            }
            n3 = n2;
        }
        this.normalizedPattern = stringBuilder.toString();
    }

    private int normalizeCharClass(StringBuilder stringBuilder, int n2) {
        int n3;
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = null;
        int n4 = -1;
        ++n2;
        stringBuilder2.append("[");
        while (true) {
            if ((n3 = this.normalizedPattern.codePointAt(n2)) == 93 && n4 != 92) break;
            if (Character.getType(n3) == 6) {
                StringBuilder stringBuilder4 = new StringBuilder();
                stringBuilder4.appendCodePoint(n4);
                while (Character.getType(n3) == 6) {
                    stringBuilder4.appendCodePoint(n3);
                    if ((n2 += Character.charCount(n3)) >= this.normalizedPattern.length()) break;
                    n3 = this.normalizedPattern.codePointAt(n2);
                }
                String string = this.produceEquivalentAlternation(stringBuilder4.toString());
                stringBuilder2.setLength(stringBuilder2.length() - Character.charCount(n4));
                if (stringBuilder3 == null) {
                    stringBuilder3 = new StringBuilder();
                }
                stringBuilder3.append('|');
                stringBuilder3.append(string);
            } else {
                stringBuilder2.appendCodePoint(n3);
                ++n2;
            }
            if (n2 == this.normalizedPattern.length()) {
                this.error("Unclosed character class");
            }
            n4 = n3;
        }
        stringBuilder2.append((char)n3);
        String string = stringBuilder3 != null ? new String("(?:" + stringBuilder2.toString() + stringBuilder3.toString() + ")") : stringBuilder2.toString();
        stringBuilder.append(string);
        return n2;
    }

    private String produceEquivalentAlternation(String string) {
        int n2 = Pattern.countChars(string, 0, 1);
        if (string.length() == n2) {
            return new String(string);
        }
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2);
        String[] stringArray = this.producePermutations(string3);
        StringBuilder stringBuilder = new StringBuilder(string);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string4 = string2 + stringArray[i2];
            if (i2 > 0) {
                stringBuilder.append("|" + string4);
            }
            if ((string4 = this.composeOneStep(string4)) == null) continue;
            stringBuilder.append("|" + this.produceEquivalentAlternation(string4));
        }
        return stringBuilder.toString();
    }

    private String[] producePermutations(String string) {
        int n2;
        int n3;
        if (string.length() == Pattern.countChars(string, 0, 1)) {
            return new String[]{string};
        }
        if (string.length() == Pattern.countChars(string, 0, 2)) {
            int n4 = Character.codePointAt(string, 0);
            int n5 = Character.codePointAt(string, Character.charCount(n4));
            if (this.getClass(n5) == this.getClass(n4)) {
                return new String[]{string};
            }
            String[] stringArray = new String[2];
            stringArray[0] = string;
            StringBuilder stringBuilder = new StringBuilder(2);
            stringBuilder.appendCodePoint(n5);
            stringBuilder.appendCodePoint(n4);
            stringArray[1] = stringBuilder.toString();
            return stringArray;
        }
        int n6 = 1;
        int n7 = Pattern.countCodePoints(string);
        for (int i2 = 1; i2 < n7; ++i2) {
            n6 *= i2 + 1;
        }
        String[] stringArray = new String[n6];
        int[] nArray = new int[n7];
        int n8 = 0;
        for (n3 = 0; n3 < n7; ++n3) {
            n2 = Character.codePointAt(string, n8);
            nArray[n3] = this.getClass(n2);
            n8 += Character.charCount(n2);
        }
        n3 = 0;
        n2 = 0;
        int n9 = 0;
        while (n2 < n7) {
            block10: {
                n8 = Pattern.countChars(string, n9, 1);
                boolean bl2 = false;
                for (int i3 = n2 - 1; i3 >= 0; --i3) {
                    if (nArray[i3] != nArray[n2]) {
                        continue;
                    }
                    break block10;
                }
                StringBuilder stringBuilder = new StringBuilder(string);
                String string2 = stringBuilder.delete(n9, n9 + n8).toString();
                String[] stringArray2 = this.producePermutations(string2);
                String string3 = string.substring(n9, n9 + n8);
                for (int i4 = 0; i4 < stringArray2.length; ++i4) {
                    stringArray[n3++] = string3 + stringArray2[i4];
                }
            }
            ++n2;
            n9 += n8;
        }
        String[] stringArray3 = new String[n3];
        for (n9 = 0; n9 < n3; ++n9) {
            stringArray3[n9] = stringArray[n9];
        }
        return stringArray3;
    }

    private int getClass(int n2) {
        return Normalizer.getClass(n2);
    }

    private String composeOneStep(String string) {
        int n2 = Pattern.countChars(string, 0, 2);
        String string2 = string.substring(0, n2);
        String string3 = Normalizer.compose(string2, false, 0);
        if (string3.equals(string2)) {
            return null;
        }
        String string4 = string.substring(n2);
        return string3 + string4;
    }

    private void compile() {
        int n2;
        if (this.has(128) && !this.has(16)) {
            this.normalize();
        } else {
            this.normalizedPattern = this.pattern;
        }
        this.patternLength = this.normalizedPattern.length();
        this.temp = new int[this.patternLength + 2];
        boolean bl2 = false;
        int n3 = 0;
        for (int i2 = 0; i2 < this.patternLength; i2 += Character.charCount(n2)) {
            n2 = this.normalizedPattern.codePointAt(i2);
            if (Pattern.isSupplementary(n2)) {
                bl2 = true;
            }
            this.temp[n3++] = n2;
        }
        this.patternLength = n3;
        this.temp[this.patternLength] = 0;
        this.temp[this.patternLength + 1] = 0;
        this.buffer = new int[32];
        this.groupNodes = new GroupHead[10];
        if (this.has(16)) {
            this.matchRoot = this.newSlice(this.temp, this.patternLength, bl2);
            this.matchRoot.next = lastAccept;
        } else {
            this.matchRoot = this.expr(lastAccept);
            if (this.patternLength != this.cursor) {
                if (this.peek() == 41) {
                    this.error("Unmatched closing ')'");
                } else {
                    this.error("Unexpected internal error");
                }
            }
        }
        if (this.matchRoot instanceof Slice) {
            this.root = BnM.optimize(this.matchRoot);
            if (this.root == this.matchRoot) {
                this.root = bl2 ? new StartS(this.matchRoot) : new Start(this.matchRoot);
            }
        } else {
            this.root = this.matchRoot instanceof Begin || this.matchRoot instanceof First ? this.matchRoot : (bl2 ? new StartS(this.matchRoot) : new Start(this.matchRoot));
        }
        this.temp = null;
        this.buffer = null;
        this.groupNodes = null;
        this.patternLength = 0;
        this.compiled = true;
    }

    private static void printObjectTree(Node node) {
        while (node != null) {
            if (node instanceof Prolog) {
                System.out.println(node);
                Pattern.printObjectTree(((Prolog)node).loop);
                System.out.println("**** end contents prolog loop");
            } else if (node instanceof Loop) {
                System.out.println(node);
                Pattern.printObjectTree(((Loop)node).body);
                System.out.println("**** end contents Loop body");
            } else if (node instanceof Curly) {
                System.out.println(node);
                Pattern.printObjectTree(((Curly)node).atom);
                System.out.println("**** end contents Curly body");
            } else if (node instanceof GroupCurly) {
                System.out.println(node);
                Pattern.printObjectTree(((GroupCurly)node).atom);
                System.out.println("**** end contents GroupCurly body");
            } else {
                if (node instanceof GroupTail) {
                    System.out.println(node);
                    System.out.println("Tail next is " + node.next);
                    return;
                }
                System.out.println(node);
            }
            node = node.next;
            if (node != null) {
                System.out.println("->next:");
            }
            if (node != accept) continue;
            System.out.println("Accept Node");
            node = null;
        }
    }

    private boolean has(int n2) {
        return (this.flags & n2) > 0;
    }

    private void accept(int n2, String string) {
        int n3 = this.temp[this.cursor++];
        if (this.has(4)) {
            n3 = this.parsePastWhitespace(n3);
        }
        if (n2 != n3) {
            this.error(string);
        }
    }

    private void mark(int n2) {
        this.temp[this.patternLength] = n2;
    }

    private int peek() {
        int n2 = this.temp[this.cursor];
        if (this.has(4)) {
            n2 = this.peekPastWhitespace(n2);
        }
        return n2;
    }

    private int read() {
        int n2 = this.temp[this.cursor++];
        if (this.has(4)) {
            n2 = this.parsePastWhitespace(n2);
        }
        return n2;
    }

    private int readEscaped() {
        int n2 = this.temp[this.cursor++];
        return n2;
    }

    private int next() {
        int n2 = this.temp[++this.cursor];
        if (this.has(4)) {
            n2 = this.peekPastWhitespace(n2);
        }
        return n2;
    }

    private int nextEscaped() {
        int n2 = this.temp[++this.cursor];
        return n2;
    }

    private int peekPastWhitespace(int n2) {
        while (ASCII.isSpace(n2) || n2 == 35) {
            while (ASCII.isSpace(n2)) {
                n2 = this.temp[++this.cursor];
            }
            if (n2 != 35) continue;
            n2 = this.peekPastLine();
        }
        return n2;
    }

    private int parsePastWhitespace(int n2) {
        while (ASCII.isSpace(n2) || n2 == 35) {
            while (ASCII.isSpace(n2)) {
                n2 = this.temp[this.cursor++];
            }
            if (n2 != 35) continue;
            n2 = this.parsePastLine();
        }
        return n2;
    }

    private int parsePastLine() {
        int n2 = this.temp[this.cursor++];
        while (n2 != 0 && !this.isLineSeparator(n2)) {
            n2 = this.temp[this.cursor++];
        }
        return n2;
    }

    private int peekPastLine() {
        int n2 = this.temp[++this.cursor];
        while (n2 != 0 && !this.isLineSeparator(n2)) {
            n2 = this.temp[++this.cursor];
        }
        return n2;
    }

    private boolean isLineSeparator(int n2) {
        if (this.has(1)) {
            return n2 == 10;
        }
        return n2 == 10 || n2 == 13 || (n2 | 1) == 8233 || n2 == 133;
    }

    private int skip() {
        int n2 = this.cursor;
        int n3 = this.temp[n2 + 1];
        this.cursor = n2 + 2;
        return n3;
    }

    private void unread() {
        --this.cursor;
    }

    private Node error(String string) {
        throw new PatternSyntaxException(string, this.normalizedPattern, this.cursor - 1);
    }

    private boolean findSupplementary(int n2, int n3) {
        for (int i2 = n2; i2 < n3; ++i2) {
            if (!Pattern.isSupplementary(this.temp[i2])) continue;
            return true;
        }
        return false;
    }

    private static final boolean isSupplementary(int n2) {
        return n2 >= 65536 || Pattern.isSurrogate(n2);
    }

    private Node expr(Node node) {
        Node node2 = null;
        while (true) {
            Node node3 = this.sequence(node);
            node2 = node2 == null ? node3 : new Branch(node2, node3);
            if (this.peek() != 124) {
                return node2;
            }
            this.next();
        }
    }

    private Node sequence(Node node) {
        Node node2 = null;
        Node node3 = null;
        Node node4 = null;
        block12: while (true) {
            int n2 = this.peek();
            switch (n2) {
                case 40: {
                    node4 = this.group0();
                    if (node4 == null) continue block12;
                    if (node2 == null) {
                        node2 = node4;
                    } else {
                        node3.next = node4;
                    }
                    node3 = this.root;
                    continue block12;
                }
                case 91: {
                    node4 = this.clazz(true);
                    break;
                }
                case 92: {
                    n2 = this.nextEscaped();
                    if (n2 == 112 || n2 == 80) {
                        boolean bl2 = n2 == 80;
                        boolean bl3 = true;
                        n2 = this.next();
                        if (n2 != 123) {
                            this.unread();
                        } else {
                            bl3 = false;
                        }
                        node4 = this.family(bl2, bl3);
                        break;
                    }
                    this.unread();
                    node4 = this.atom();
                    break;
                }
                case 94: {
                    this.next();
                    if (this.has(8)) {
                        if (this.has(1)) {
                            node4 = new UnixCaret();
                            break;
                        }
                        node4 = new Caret();
                        break;
                    }
                    node4 = new Begin();
                    break;
                }
                case 36: {
                    this.next();
                    if (this.has(1)) {
                        node4 = new UnixDollar(this.has(8));
                        break;
                    }
                    node4 = new Dollar(this.has(8));
                    break;
                }
                case 46: {
                    this.next();
                    if (this.has(32)) {
                        node4 = new All();
                        break;
                    }
                    if (this.has(1)) {
                        node4 = new UnixDot();
                        break;
                    }
                    node4 = new Dot();
                    break;
                }
                case 41: 
                case 124: {
                    break block12;
                }
                case 93: 
                case 125: {
                    node4 = this.atom();
                    break;
                }
                case 42: 
                case 43: 
                case 63: {
                    this.next();
                    return this.error("Dangling meta character '" + (char)n2 + "'");
                }
                case 0: {
                    if (this.cursor >= this.patternLength) break block12;
                }
                default: {
                    node4 = this.atom();
                }
            }
            node4 = this.closure(node4);
            if (node2 == null) {
                node2 = node3 = node4;
                continue;
            }
            node3.next = node4;
            node3 = node4;
        }
        if (node2 == null) {
            return node;
        }
        node3.next = node;
        return node2;
    }

    private Node atom() {
        int n2 = 0;
        int n3 = -1;
        boolean bl2 = false;
        int n4 = this.peek();
        block6: while (true) {
            switch (n4) {
                case 42: 
                case 43: 
                case 63: 
                case 123: {
                    if (n2 <= true) break block6;
                    this.cursor = n3;
                    --n2;
                    break block6;
                }
                case 36: 
                case 40: 
                case 41: 
                case 46: 
                case 91: 
                case 94: 
                case 124: {
                    break block6;
                }
                case 92: {
                    n4 = this.nextEscaped();
                    if (n4 == 112 || n4 == 80) {
                        if (n2 > 0) {
                            this.unread();
                            break block6;
                        }
                        if (n4 != 112 && n4 != 80) break block6;
                        boolean bl3 = n4 == 80;
                        boolean bl4 = true;
                        n4 = this.next();
                        if (n4 != 123) {
                            this.unread();
                        } else {
                            bl4 = false;
                        }
                        return this.family(bl3, bl4);
                    }
                    this.unread();
                    n3 = this.cursor;
                    n4 = this.escape(false, n2 == 0);
                    if (n4 >= 0) {
                        this.append(n4, n2);
                        ++n2;
                        if (Pattern.isSupplementary(n4)) {
                            bl2 = true;
                        }
                        n4 = this.peek();
                        continue block6;
                    }
                    if (n2 == 0) {
                        return this.root;
                    }
                    this.cursor = n3;
                    break block6;
                }
                case 0: {
                    if (this.cursor >= this.patternLength) break block6;
                }
                default: {
                    n3 = this.cursor;
                    this.append(n4, n2);
                    ++n2;
                    if (Pattern.isSupplementary(n4)) {
                        bl2 = true;
                    }
                    n4 = this.next();
                    continue block6;
                }
            }
            break;
        }
        if (n2 == 1) {
            return this.newSingle(this.buffer[0]);
        }
        return this.newSlice(this.buffer, n2, bl2);
    }

    private void append(int n2, int n3) {
        if (n3 >= this.buffer.length) {
            int[] nArray = new int[n3 + n3];
            System.arraycopy(this.buffer, 0, nArray, 0, n3);
            this.buffer = nArray;
        }
        this.buffer[n3] = n2;
    }

    private Node ref(int n2) {
        boolean bl2 = false;
        block3: while (!bl2) {
            int n3 = this.peek();
            switch (n3) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    int n4 = n2 * 10 + (n3 - 48);
                    if (this.capturingGroupCount - 1 < n4) {
                        bl2 = true;
                        continue block3;
                    }
                    n2 = n4;
                    this.read();
                    continue block3;
                }
            }
            bl2 = true;
        }
        if (this.has(2) || this.has(64)) {
            return new CIBackRef(n2);
        }
        return new BackRef(n2);
    }

    private int escape(boolean bl2, boolean bl3) {
        int n2 = this.skip();
        switch (n2) {
            case 48: {
                return this.o();
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                if (bl2) break;
                if (this.capturingGroupCount < n2 - 48) {
                    this.error("No such group yet exists at this point in the pattern");
                }
                if (bl3) {
                    this.root = this.ref(n2 - 48);
                }
                return -1;
            }
            case 65: {
                if (bl2) break;
                if (bl3) {
                    this.root = new Begin();
                }
                return -1;
            }
            case 66: {
                if (bl2) break;
                if (bl3) {
                    this.root = new Bound(Bound.NONE);
                }
                return -1;
            }
            case 67: {
                break;
            }
            case 68: {
                if (bl3) {
                    this.root = new NotCtype(1024);
                }
                return -1;
            }
            case 69: 
            case 70: {
                break;
            }
            case 71: {
                if (bl2) break;
                if (bl3) {
                    this.root = new LastMatch();
                }
                return -1;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: {
                break;
            }
            case 81: {
                if (bl3) {
                    int n3;
                    int n4 = this.cursor;
                    while ((n3 = this.readEscaped()) != 0) {
                        if (n3 != 92) continue;
                        n3 = this.readEscaped();
                        if (n3 == 69 || n3 == 0) break;
                        this.unread();
                    }
                    int n5 = this.cursor - 1;
                    if (n3 == 69) {
                        --n5;
                    } else {
                        this.unread();
                    }
                    boolean bl4 = false;
                    for (int i2 = n4; i2 < n5; ++i2) {
                        n3 = this.temp[i2];
                        this.append(n3, i2 - n4);
                        if (!Pattern.isSupplementary(n3)) continue;
                        bl4 = true;
                    }
                    this.root = this.newSlice(this.buffer, n5 - n4, bl4);
                }
                return -1;
            }
            case 82: {
                break;
            }
            case 83: {
                if (bl3) {
                    this.root = new NotCtype(2048);
                }
                return -1;
            }
            case 84: 
            case 85: 
            case 86: {
                break;
            }
            case 87: {
                if (bl3) {
                    this.root = new NotCtype(67328);
                }
                return -1;
            }
            case 88: 
            case 89: {
                break;
            }
            case 90: {
                if (bl2) break;
                if (bl3) {
                    this.root = this.has(1) ? new UnixDollar(false) : new Dollar(false);
                }
                return -1;
            }
            case 97: {
                return 7;
            }
            case 98: {
                if (bl2) break;
                if (bl3) {
                    this.root = new Bound(Bound.BOTH);
                }
                return -1;
            }
            case 99: {
                return this.c();
            }
            case 100: {
                if (bl3) {
                    this.root = new Ctype(1024);
                }
                return -1;
            }
            case 101: {
                return 27;
            }
            case 102: {
                return 12;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                break;
            }
            case 110: {
                return 10;
            }
            case 111: 
            case 112: 
            case 113: {
                break;
            }
            case 114: {
                return 13;
            }
            case 115: {
                if (bl3) {
                    this.root = new Ctype(2048);
                }
                return -1;
            }
            case 116: {
                return 9;
            }
            case 117: {
                return this.u();
            }
            case 118: {
                return 11;
            }
            case 119: {
                if (bl3) {
                    this.root = new Ctype(67328);
                }
                return -1;
            }
            case 120: {
                return this.x();
            }
            case 121: {
                break;
            }
            case 122: {
                if (bl2) break;
                if (bl3) {
                    this.root = new End();
                }
                return -1;
            }
            default: {
                return n2;
            }
        }
        this.error("Illegal/unsupported escape squence");
        return -2;
    }

    private Node clazz(boolean bl2) {
        Node node = null;
        Node node2 = null;
        BitClass bitClass = new BitClass(false);
        boolean bl3 = true;
        boolean bl4 = true;
        int n2 = this.next();
        block7: while (true) {
            switch (n2) {
                case 94: {
                    if (!bl4 || this.temp[this.cursor - 1] != 91) break;
                    n2 = this.next();
                    bl3 = !bl3;
                    continue block7;
                }
                case 91: {
                    bl4 = false;
                    node2 = this.clazz(true);
                    node = node == null ? node2 : new Add(node, node2);
                    n2 = this.peek();
                    continue block7;
                }
                case 38: {
                    bl4 = false;
                    n2 = this.next();
                    if (n2 == 38) {
                        n2 = this.next();
                        Node node3 = null;
                        while (n2 != 93 && n2 != 38) {
                            if (n2 == 91) {
                                node3 = node3 == null ? this.clazz(true) : new Add(node3, this.clazz(true));
                            } else {
                                this.unread();
                                node3 = this.clazz(false);
                            }
                            n2 = this.peek();
                        }
                        if (node3 != null) {
                            node2 = node3;
                        }
                        if (node == null) {
                            if (node3 == null) {
                                return this.error("Bad class syntax");
                            }
                            node = node3;
                            continue block7;
                        }
                        node = new Both(node, node2);
                        continue block7;
                    }
                    this.unread();
                    break;
                }
                case 0: {
                    bl4 = false;
                    if (this.cursor < this.patternLength) break;
                    return this.error("Unclosed character class");
                }
                case 93: {
                    bl4 = false;
                    if (node == null) break;
                    if (bl2) {
                        this.next();
                    }
                    return node;
                }
                default: {
                    bl4 = false;
                }
            }
            node2 = this.range(bitClass);
            if (bl3) {
                if (node == null) {
                    node = node2;
                } else if (node != node2) {
                    node = new Add(node, node2);
                }
            } else if (node == null) {
                node = node2.dup(true);
            } else if (node != node2) {
                node = new Sub(node, node2);
            }
            n2 = this.peek();
        }
    }

    private Node range(BitClass bitClass) {
        int n2 = this.peek();
        if (n2 == 92) {
            n2 = this.nextEscaped();
            if (n2 == 112 || n2 == 80) {
                boolean bl2 = n2 == 80;
                boolean bl3 = true;
                n2 = this.next();
                if (n2 != 123) {
                    this.unread();
                } else {
                    bl3 = false;
                }
                return this.family(bl2, bl3);
            }
            this.unread();
            n2 = this.escape(true, true);
            if (n2 == -1) {
                return this.root;
            }
        } else {
            n2 = this.single();
        }
        if (n2 >= 0) {
            if (this.peek() == 45) {
                int n3 = this.temp[this.cursor + 1];
                if (n3 == 91) {
                    if (n2 < 256) {
                        return bitClass.add(n2, this.flags());
                    }
                    return this.newSingle(n2);
                }
                if (n3 != 93) {
                    this.next();
                    int n4 = this.single();
                    if (n4 < n2) {
                        return this.error("Illegal character range");
                    }
                    if (this.has(2) || this.has(64)) {
                        return new CIRange(n2, n4);
                    }
                    return new Range(n2, n4);
                }
            }
            if (n2 < 256) {
                return bitClass.add(n2, this.flags());
            }
            return this.newSingle(n2);
        }
        return this.error("Unexpected character '" + (char)n2 + "'");
    }

    private int single() {
        int n2 = this.peek();
        switch (n2) {
            case 92: {
                return this.escape(true, false);
            }
        }
        this.next();
        return n2;
    }

    private Node family(boolean bl2, boolean bl3) {
        String string;
        this.next();
        if (bl3) {
            int n2 = this.temp[this.cursor];
            string = !Character.isSupplementaryCodePoint(n2) ? String.valueOf((char)n2) : new String(this.temp, this.cursor, 1);
            string = string.intern();
            this.read();
        } else {
            int n3 = this.cursor;
            this.mark(125);
            while (this.read() != 125) {
            }
            this.mark(0);
            int n4 = this.cursor;
            if (n4 > this.patternLength) {
                return this.error("Unclosed character family");
            }
            if (n3 + 1 >= n4) {
                return this.error("Empty character family");
            }
            string = new String(this.temp, n3, n4 - n3 - 1).intern();
        }
        if (string.startsWith("In")) {
            string = string.substring(2, string.length()).intern();
            return this.retrieveFamilyNode(string, bl2);
        }
        if (string.startsWith("Is")) {
            string = string.substring(2, string.length()).intern();
        }
        return this.retrieveCategoryNode(string).dup(bl2);
    }

    private Node retrieveFamilyNode(String string, boolean bl2) {
        if (string == null) {
            return this.familyError("", "Null character family.");
        }
        UBlock uBlock = null;
        try {
            Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.forName(string);
            uBlock = new UBlock(unicodeBlock, bl2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this.familyError(string, "Unknown character family {");
        }
        return uBlock;
    }

    private Node retrieveCategoryNode(String string) {
        Node node = (Node)categoryNames.cMap.get(string);
        if (node != null) {
            return node;
        }
        return this.familyError(string, "Unknown character category {");
    }

    private Node familyError(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append(string);
        stringBuilder.append("}");
        string = stringBuilder.toString();
        return this.error(string);
    }

    private Node group0() {
        Object object;
        boolean bl2 = false;
        Node node = null;
        Node node2 = null;
        int n2 = this.flags;
        this.root = null;
        int n3 = this.next();
        if (n3 == 63) {
            n3 = this.skip();
            switch (n3) {
                case 58: {
                    node = this.createGroup(true);
                    node2 = this.root;
                    node.next = this.expr(node2);
                    break;
                }
                case 33: 
                case 61: {
                    node = this.createGroup(true);
                    node2 = this.root;
                    node.next = this.expr(node2);
                    if (n3 == 61) {
                        node = node2 = new Pos(node);
                        break;
                    }
                    node = node2 = new Neg(node);
                    break;
                }
                case 62: {
                    node = this.createGroup(true);
                    node2 = this.root;
                    node.next = this.expr(node2);
                    node = node2 = new Ques(node, 3);
                    break;
                }
                case 60: {
                    n3 = this.read();
                    int n4 = this.cursor;
                    node = this.createGroup(true);
                    node2 = this.root;
                    node.next = this.expr(node2);
                    object = new TreeInfo();
                    node.study((TreeInfo)object);
                    if (!((TreeInfo)object).maxValid) {
                        return this.error("Look-behind group does not have an obvious maximum length");
                    }
                    boolean bl3 = this.findSupplementary(n4, this.patternLength);
                    if (n3 == 61) {
                        node2 = bl3 ? new BehindS(node, ((TreeInfo)object).maxLength, ((TreeInfo)object).minLength) : new Behind(node, ((TreeInfo)object).maxLength, ((TreeInfo)object).minLength);
                        node = node2;
                        break;
                    }
                    if (n3 == 33) {
                        node2 = bl3 ? new NotBehindS(node, ((TreeInfo)object).maxLength, ((TreeInfo)object).minLength) : new NotBehind(node, ((TreeInfo)object).maxLength, ((TreeInfo)object).minLength);
                        node = node2;
                        break;
                    }
                    this.error("Unknown look-behind group");
                    break;
                }
                case 36: 
                case 64: {
                    return this.error("Unknown group type");
                }
                default: {
                    this.unread();
                    this.addFlag();
                    n3 = this.read();
                    if (n3 == 41) {
                        return null;
                    }
                    if (n3 != 58) {
                        return this.error("Unknown inline modifier");
                    }
                    node = this.createGroup(true);
                    node2 = this.root;
                    node.next = this.expr(node2);
                    break;
                }
            }
        } else {
            bl2 = true;
            node = this.createGroup(false);
            node2 = this.root;
            node.next = this.expr(node2);
        }
        this.accept(41, "Unclosed group");
        this.flags = n2;
        Node node3 = this.closure(node);
        if (node3 == node) {
            this.root = node2;
            return node3;
        }
        if (node == node2) {
            this.root = node3;
            return node3;
        }
        if (node3 instanceof Ques) {
            object = (Ques)node3;
            if (((Ques)object).type == 2) {
                this.root = node3;
                return node3;
            }
            node2 = node2.next = new Dummy();
            node = ((Ques)object).type == 0 ? new Branch(node, node2) : new Branch(node2, node);
            this.root = node2;
            return node;
        }
        if (node3 instanceof Curly) {
            object = (Curly)node3;
            if (((Curly)object).type == 2) {
                this.root = node3;
                return node3;
            }
            TreeInfo treeInfo = new TreeInfo();
            if (node.study(treeInfo)) {
                GroupTail groupTail = (GroupTail)node2;
                node = this.root = new GroupCurly(node.next, ((Curly)object).cmin, ((Curly)object).cmax, ((Curly)object).type, ((GroupTail)node2).localIndex, ((GroupTail)node2).groupIndex, bl2);
                return node;
            }
            int n5 = ((GroupHead)node).localIndex;
            Loop loop = ((Curly)object).type == 0 ? new Loop(this.localCount, n5) : new LazyLoop(this.localCount, n5);
            Prolog prolog = new Prolog(loop);
            ++this.localCount;
            loop.cmin = ((Curly)object).cmin;
            loop.cmax = ((Curly)object).cmax;
            loop.body = node;
            node2.next = loop;
            this.root = loop;
            return prolog;
        }
        if (node3 instanceof First) {
            this.root = node3;
            return node3;
        }
        return this.error("Internal logic error");
    }

    private Node createGroup(boolean bl2) {
        int n2 = this.localCount++;
        int n3 = 0;
        if (!bl2) {
            n3 = this.capturingGroupCount++;
        }
        GroupHead groupHead = new GroupHead(n2);
        this.root = new GroupTail(n2, n3);
        if (!bl2 && n3 < 10) {
            this.groupNodes[n3] = groupHead;
        }
        return groupHead;
    }

    private void addFlag() {
        int n2 = this.peek();
        while (true) {
            switch (n2) {
                case 105: {
                    this.flags |= 2;
                    break;
                }
                case 109: {
                    this.flags |= 8;
                    break;
                }
                case 115: {
                    this.flags |= 0x20;
                    break;
                }
                case 100: {
                    this.flags |= 1;
                    break;
                }
                case 117: {
                    this.flags |= 0x40;
                    break;
                }
                case 99: {
                    this.flags |= 0x80;
                    break;
                }
                case 120: {
                    this.flags |= 4;
                    break;
                }
                case 45: {
                    n2 = this.next();
                    this.subFlag();
                }
                default: {
                    return;
                }
            }
            n2 = this.next();
        }
    }

    private void subFlag() {
        int n2 = this.peek();
        while (true) {
            switch (n2) {
                case 105: {
                    this.flags &= 0xFFFFFFFD;
                    break;
                }
                case 109: {
                    this.flags &= 0xFFFFFFF7;
                    break;
                }
                case 115: {
                    this.flags &= 0xFFFFFFDF;
                    break;
                }
                case 100: {
                    this.flags &= 0xFFFFFFFE;
                    break;
                }
                case 117: {
                    this.flags &= 0xFFFFFFBF;
                    break;
                }
                case 99: {
                    this.flags &= 0xFFFFFF7F;
                    break;
                }
                case 120: {
                    this.flags &= 0xFFFFFFFB;
                    break;
                }
                default: {
                    return;
                }
            }
            n2 = this.next();
        }
    }

    private Node closure(Node node) {
        int n2 = this.peek();
        switch (n2) {
            case 63: {
                n2 = this.next();
                if (n2 == 63) {
                    this.next();
                    return new Ques(node, 1);
                }
                if (n2 == 43) {
                    this.next();
                    return new Ques(node, 2);
                }
                return new Ques(node, 0);
            }
            case 42: {
                n2 = this.next();
                if (n2 == 63) {
                    this.next();
                    return new Curly(node, 0, Integer.MAX_VALUE, 1);
                }
                if (n2 == 43) {
                    this.next();
                    return new Curly(node, 0, Integer.MAX_VALUE, 2);
                }
                return new Curly(node, 0, Integer.MAX_VALUE, 0);
            }
            case 43: {
                n2 = this.next();
                if (n2 == 63) {
                    this.next();
                    return new Curly(node, 1, Integer.MAX_VALUE, 1);
                }
                if (n2 == 43) {
                    this.next();
                    return new Curly(node, 1, Integer.MAX_VALUE, 2);
                }
                return new Curly(node, 1, Integer.MAX_VALUE, 0);
            }
            case 123: {
                n2 = this.temp[this.cursor + 1];
                if (ASCII.isDigit(n2)) {
                    Curly curly;
                    this.skip();
                    int n3 = 0;
                    do {
                        n3 = n3 * 10 + (n2 - 48);
                    } while (ASCII.isDigit(n2 = this.read()));
                    int n4 = n3;
                    if (n2 == 44) {
                        n2 = this.read();
                        n4 = Integer.MAX_VALUE;
                        if (n2 != 125) {
                            n4 = 0;
                            while (ASCII.isDigit(n2)) {
                                n4 = n4 * 10 + (n2 - 48);
                                n2 = this.read();
                            }
                        }
                    }
                    if (n2 != 125) {
                        return this.error("Unclosed counted closure");
                    }
                    if ((n3 | n4 | n4 - n3) < 0) {
                        return this.error("Illegal repetition range");
                    }
                    n2 = this.peek();
                    if (n2 == 63) {
                        this.next();
                        curly = new Curly(node, n3, n4, 1);
                    } else if (n2 == 43) {
                        this.next();
                        curly = new Curly(node, n3, n4, 2);
                    } else {
                        curly = new Curly(node, n3, n4, 0);
                    }
                    return curly;
                }
                this.error("Illegal repetition");
                return node;
            }
        }
        return node;
    }

    private int c() {
        if (this.cursor < this.patternLength) {
            return this.read() ^ 0x40;
        }
        this.error("Illegal control escape sequence");
        return -1;
    }

    private int o() {
        int n2 = this.read();
        if ((n2 - 48 | 55 - n2) >= 0) {
            int n3 = this.read();
            if ((n3 - 48 | 55 - n3) >= 0) {
                int n4 = this.read();
                if ((n4 - 48 | 55 - n4) >= 0 && (n2 - 48 | 51 - n2) >= 0) {
                    return (n2 - 48) * 64 + (n3 - 48) * 8 + (n4 - 48);
                }
                this.unread();
                return (n2 - 48) * 8 + (n3 - 48);
            }
            this.unread();
            return n2 - 48;
        }
        this.error("Illegal octal escape sequence");
        return -1;
    }

    private int x() {
        int n2;
        int n3 = this.read();
        if (ASCII.isHexDigit(n3) && ASCII.isHexDigit(n2 = this.read())) {
            return ASCII.toDigit(n3) * 16 + ASCII.toDigit(n2);
        }
        this.error("Illegal hexadecimal escape sequence");
        return -1;
    }

    private int u() {
        int n2 = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            int n3 = this.read();
            if (!ASCII.isHexDigit(n3)) {
                this.error("Illegal Unicode escape sequence");
            }
            n2 = n2 * 16 + ASCII.toDigit(n3);
        }
        return n2;
    }

    private static final boolean isSurrogate(int n2) {
        return n2 >= 55296 && n2 <= 57343;
    }

    private static final int countChars(CharSequence charSequence, int n2, int n3) {
        if (n3 == 1 && !Character.isHighSurrogate(charSequence.charAt(n2))) {
            assert (n2 >= 0 && n2 < charSequence.length());
            return 1;
        }
        int n4 = charSequence.length();
        int n5 = n2;
        if (n3 >= 0) {
            assert (n2 >= 0 && n2 < n4);
            for (int i2 = 0; n5 < n4 && i2 < n3; ++i2) {
                if (!Character.isHighSurrogate(charSequence.charAt(n5++)) || n5 >= n4 || !Character.isLowSurrogate(charSequence.charAt(n5))) continue;
                ++n5;
            }
            return n5 - n2;
        }
        assert (n2 >= 0 && n2 <= n4);
        if (n2 == 0) {
            return 0;
        }
        int n6 = -n3;
        for (int i3 = 0; n5 > 0 && i3 < n6; ++i3) {
            if (!Character.isLowSurrogate(charSequence.charAt(--n5)) || n5 <= 0 || !Character.isHighSurrogate(charSequence.charAt(n5 - 1))) continue;
            --n5;
        }
        return n2 - n5;
    }

    private static final int countCodePoints(CharSequence charSequence) {
        int n2 = charSequence.length();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            ++n3;
            if (!Character.isHighSurrogate(charSequence.charAt(n4++)) || n4 >= n2 || !Character.isLowSurrogate(charSequence.charAt(n4))) continue;
            ++n4;
        }
        return n3;
    }

    private Node newSingle(int n2) {
        int n3 = this.flags;
        if ((n3 & 0x42) == 0) {
            return new Single(n2);
        }
        if ((n3 & 0x40) == 0) {
            return new SingleA(n2);
        }
        return new SingleU(n2);
    }

    private Node newSlice(int[] nArray, int n2, boolean bl2) {
        int[] nArray2 = new int[n2];
        int n3 = this.flags;
        if ((n3 & 0x42) == 0) {
            for (n3 = 0; n3 < n2; ++n3) {
                nArray2[n3] = nArray[n3];
            }
            return bl2 ? new SliceS(nArray2) : new Slice(nArray2);
        }
        if ((n3 & 0x40) == 0) {
            for (n3 = 0; n3 < n2; ++n3) {
                nArray2[n3] = (char)ASCII.toLower(nArray[n3]);
            }
            return new SliceA(nArray2);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            int n4 = nArray[n3];
            n4 = Character.toUpperCase(n4);
            nArray2[n3] = n4 = Character.toLowerCase(n4);
        }
        return new SliceU(nArray2);
    }

    private static boolean hasBaseCharacter(Matcher matcher, int n2, CharSequence charSequence) {
        int n3 = !matcher.transparentBounds ? matcher.from : 0;
        for (int i2 = n2; i2 >= n3; --i2) {
            int n4 = Character.codePointAt(charSequence, i2);
            if (Character.isLetterOrDigit(n4)) {
                return true;
            }
            if (Character.getType(n4) == 6) continue;
            return false;
        }
        return false;
    }

    static class Add
    extends Node {
        Node lhs;
        Node rhs;

        Add(Node node, Node node2) {
            this.lhs = node;
            this.rhs = node2;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 < matcher.to) {
                return (this.lhs.match(matcher, n2, charSequence) || this.rhs.match(matcher, n2, charSequence)) && this.next.match(matcher, matcher.last, charSequence);
            }
            matcher.hitEnd = true;
            return false;
        }

        boolean study(TreeInfo treeInfo) {
            boolean bl2 = treeInfo.maxValid;
            boolean bl3 = treeInfo.deterministic;
            int n2 = treeInfo.minLength;
            int n3 = treeInfo.maxLength;
            this.lhs.study(treeInfo);
            int n4 = treeInfo.minLength;
            int n5 = treeInfo.maxLength;
            treeInfo.minLength = n2;
            treeInfo.maxLength = n3;
            this.rhs.study(treeInfo);
            treeInfo.minLength = Math.min(n4, treeInfo.minLength);
            treeInfo.maxLength = Math.max(n5, treeInfo.maxLength);
            treeInfo.maxValid = bl2;
            treeInfo.deterministic = bl3;
            return this.next.study(treeInfo);
        }
    }

    static final class All
    extends Node {
        All() {
        }

        Node dup(boolean bl2) {
            if (bl2) {
                return new Single(-1);
            }
            return new All();
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 < matcher.to) {
                return this.next.match(matcher, n2 + Pattern.countChars(charSequence, n2, 1), charSequence);
            }
            matcher.hitEnd = true;
            return false;
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    static class BackRef
    extends Node {
        int groupIndex;

        BackRef(int n2) {
            this.groupIndex = n2 + n2;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3 = matcher.groups[this.groupIndex];
            int n4 = matcher.groups[this.groupIndex + 1];
            int n5 = n4 - n3;
            if (n3 < 0) {
                return false;
            }
            if (n2 + n5 > matcher.to) {
                matcher.hitEnd = true;
                return false;
            }
            for (int i2 = 0; i2 < n5; ++i2) {
                if (charSequence.charAt(n2 + i2) == charSequence.charAt(n3 + i2)) continue;
                return false;
            }
            return this.next.match(matcher, n2 + n5, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            treeInfo.maxValid = false;
            return this.next.study(treeInfo);
        }
    }

    static final class Begin
    extends Node {
        Begin() {
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3;
            int n4 = n3 = matcher.anchoringBounds ? matcher.from : 0;
            if (n2 == n3 && this.next.match(matcher, n2, charSequence)) {
                matcher.first = n2;
                matcher.groups[0] = n2;
                matcher.groups[1] = matcher.last;
                return true;
            }
            return false;
        }
    }

    static class Behind
    extends Node {
        Node cond;
        int rmax;
        int rmin;

        Behind(Node node, int n2, int n3) {
            this.cond = node;
            this.rmax = n2;
            this.rmin = n3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3 = matcher.from;
            boolean bl2 = false;
            int n4 = !matcher.transparentBounds ? matcher.from : 0;
            int n5 = Math.max(n2 - this.rmax, n4);
            for (int i2 = n2 - this.rmin; i2 >= n5; --i2) {
                if (matcher.transparentBounds) {
                    matcher.from = 0;
                }
                try {
                    bl2 = this.cond.match(matcher, i2, charSequence) && matcher.last == n2;
                }
                finally {
                    matcher.from = n3;
                }
                if (!bl2) continue;
                return this.next.match(matcher, n2, charSequence);
            }
            return false;
        }
    }

    static final class BehindS
    extends Behind {
        BehindS(Node node, int n2, int n3) {
            super(node, n2, n3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3 = Pattern.countChars(charSequence, n2, -this.rmax);
            int n4 = Pattern.countChars(charSequence, n2, -this.rmin);
            int n5 = matcher.from;
            int n6 = !matcher.transparentBounds ? matcher.from : 0;
            boolean bl2 = false;
            int n7 = Math.max(n2 - n3, n6);
            for (int i2 = n2 - n4; i2 >= n7; i2 -= i2 > n7 ? Pattern.countChars(charSequence, i2, -1) : 1) {
                if (matcher.transparentBounds) {
                    matcher.from = 0;
                }
                try {
                    bl2 = this.cond.match(matcher, i2, charSequence) && matcher.last == n2;
                }
                finally {
                    matcher.from = n5;
                }
                if (!bl2) continue;
                return this.next.match(matcher, n2, charSequence);
            }
            return false;
        }
    }

    static final class BitClass
    extends Node {
        boolean[] bits = new boolean[256];
        boolean complementMe = false;

        BitClass(boolean bl2) {
            this.complementMe = bl2;
        }

        BitClass(boolean[] blArray, boolean bl2) {
            this.complementMe = bl2;
            this.bits = blArray;
        }

        Node add(int n2, int n3) {
            if ((n3 & 2) == 0) {
                this.bits[n2] = true;
            } else if (ASCII.isAscii(n2)) {
                this.bits[ASCII.toUpper((int)n2)] = true;
                this.bits[ASCII.toLower((int)n2)] = true;
            } else {
                this.bits[Character.toLowerCase((char)((char)n2))] = true;
                this.bits[Character.toUpperCase((char)((char)n2))] = true;
            }
            return this;
        }

        Node dup(boolean bl2) {
            return new BitClass(this.bits, bl2);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 >= matcher.to) {
                matcher.hitEnd = true;
                return false;
            }
            int n3 = Character.codePointAt(charSequence, n2);
            boolean bl2 = n3 > 255 ? this.complementMe : this.bits[n3] ^ this.complementMe;
            return bl2 && this.next.match(matcher, n2 + Character.charCount(n3), charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    static class BnM
    extends Node {
        int[] buffer;
        int[] lastOcc;
        int[] optoSft;

        static Node optimize(Node node) {
            int n2;
            if (!(node instanceof Slice)) {
                return node;
            }
            int[] nArray = ((Slice)node).buffer;
            int n3 = nArray.length;
            if (n3 < 4) {
                return node;
            }
            int[] nArray2 = new int[128];
            int[] nArray3 = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                nArray2[nArray[n2] & 0x7F] = n2 + 1;
            }
            block1: for (n2 = n3; n2 > 0; --n2) {
                int n4;
                for (n4 = n3 - 1; n4 >= n2; --n4) {
                    if (nArray[n4] != nArray[n4 - n2]) continue block1;
                    nArray3[n4 - 1] = n2;
                }
                while (n4 > 0) {
                    nArray3[--n4] = n2;
                }
            }
            nArray3[n3 - 1] = 1;
            if (node instanceof SliceS) {
                return new BnMS(nArray, nArray2, nArray3, node.next);
            }
            return new BnM(nArray, nArray2, nArray3, node.next);
        }

        BnM(int[] nArray, int[] nArray2, int[] nArray3, Node node) {
            this.buffer = nArray;
            this.lastOcc = nArray2;
            this.optoSft = nArray3;
            this.next = node;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int[] nArray = this.buffer;
            int n3 = nArray.length;
            int n4 = matcher.to - n3;
            block0: while (n2 <= n4) {
                int n5;
                for (n5 = n3 - 1; n5 >= 0; --n5) {
                    char c2 = charSequence.charAt(n2 + n5);
                    if (c2 == nArray[n5]) continue;
                    n2 += Math.max(n5 + 1 - this.lastOcc[c2 & 0x7F], this.optoSft[n5]);
                    continue block0;
                }
                matcher.first = n2;
                n5 = this.next.match(matcher, n2 + n3, charSequence) ? 1 : 0;
                if (n5 != 0) {
                    matcher.groups[0] = matcher.first = n2;
                    matcher.groups[1] = matcher.last;
                    return true;
                }
                ++n2;
            }
            matcher.hitEnd = true;
            return false;
        }

        boolean study(TreeInfo treeInfo) {
            treeInfo.minLength += this.buffer.length;
            treeInfo.maxValid = false;
            return this.next.study(treeInfo);
        }
    }

    static final class BnMS
    extends BnM {
        int lengthInChars;

        BnMS(int[] nArray, int[] nArray2, int[] nArray3, Node node) {
            super(nArray, nArray2, nArray3, node);
            for (int i2 = 0; i2 < this.buffer.length; ++i2) {
                this.lengthInChars += Character.charCount(this.buffer[i2]);
            }
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int[] nArray = this.buffer;
            int n3 = nArray.length;
            int n4 = matcher.to - this.lengthInChars;
            block0: while (n2 <= n4) {
                int n5 = Pattern.countChars(charSequence, n2, n3);
                int n6 = n3 - 1;
                while (n5 > 0) {
                    int n7 = Character.codePointBefore(charSequence, n2 + n5);
                    if (n7 != nArray[n6]) {
                        int n8 = Math.max(n6 + 1 - this.lastOcc[n7 & 0x7F], this.optoSft[n6]);
                        n2 += Pattern.countChars(charSequence, n2, n8);
                        continue block0;
                    }
                    n5 -= Character.charCount(n7);
                    --n6;
                }
                matcher.first = n2;
                n5 = this.next.match(matcher, n2 + this.lengthInChars, charSequence) ? 1 : 0;
                if (n5 != 0) {
                    matcher.groups[0] = matcher.first = n2;
                    matcher.groups[1] = matcher.last;
                    return true;
                }
                n2 += Pattern.countChars(charSequence, n2, 1);
            }
            matcher.hitEnd = true;
            return false;
        }
    }

    static class Both
    extends Node {
        Node lhs;
        Node rhs;

        Both(Node node, Node node2) {
            this.lhs = node;
            this.rhs = node2;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 < matcher.to) {
                return this.lhs.match(matcher, n2, charSequence) && this.rhs.match(matcher, n2, charSequence) && this.next.match(matcher, matcher.last, charSequence);
            }
            matcher.hitEnd = true;
            return false;
        }

        boolean study(TreeInfo treeInfo) {
            boolean bl2 = treeInfo.maxValid;
            boolean bl3 = treeInfo.deterministic;
            int n2 = treeInfo.minLength;
            int n3 = treeInfo.maxLength;
            this.lhs.study(treeInfo);
            int n4 = treeInfo.minLength;
            int n5 = treeInfo.maxLength;
            treeInfo.minLength = n2;
            treeInfo.maxLength = n3;
            this.rhs.study(treeInfo);
            treeInfo.minLength = Math.min(n4, treeInfo.minLength);
            treeInfo.maxLength = Math.max(n5, treeInfo.maxLength);
            treeInfo.maxValid = bl2;
            treeInfo.deterministic = bl3;
            return this.next.study(treeInfo);
        }
    }

    static final class Bound
    extends Node {
        static int LEFT = 1;
        static int RIGHT = 2;
        static int BOTH = 3;
        static int NONE = 4;
        int type;

        Bound(int n2) {
            this.type = n2;
        }

        int check(Matcher matcher, int n2, CharSequence charSequence) {
            int n3;
            boolean bl2 = false;
            int n4 = matcher.from;
            int n5 = matcher.to;
            if (matcher.transparentBounds) {
                n4 = 0;
                n5 = matcher.getTextLength();
            }
            if (n2 > n4) {
                n3 = Character.codePointBefore(charSequence, n2);
                bl2 = n3 == 95 || Character.isLetterOrDigit(n3) || Character.getType(n3) == 6 && Pattern.hasBaseCharacter(matcher, n2 - 1, charSequence);
            }
            boolean bl3 = false;
            if (n2 < n5) {
                n3 = Character.codePointAt(charSequence, n2);
                bl3 = n3 == 95 || Character.isLetterOrDigit(n3) || Character.getType(n3) == 6 && Pattern.hasBaseCharacter(matcher, n2, charSequence);
            } else {
                matcher.hitEnd = true;
                matcher.requireEnd = true;
            }
            return bl2 ^ bl3 ? (bl3 ? LEFT : RIGHT) : NONE;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            return (this.check(matcher, n2, charSequence) & this.type) > 0 && this.next.match(matcher, n2, charSequence);
        }
    }

    static final class Branch
    extends Node {
        Node prev;

        Branch(Node node, Node node2) {
            this.prev = node;
            this.next = node2;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            return this.prev.match(matcher, n2, charSequence) || this.next.match(matcher, n2, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            int n2 = treeInfo.minLength;
            int n3 = treeInfo.maxLength;
            boolean bl2 = treeInfo.maxValid;
            treeInfo.reset();
            this.prev.study(treeInfo);
            int n4 = treeInfo.minLength;
            int n5 = treeInfo.maxLength;
            boolean bl3 = treeInfo.maxValid;
            treeInfo.reset();
            this.next.study(treeInfo);
            treeInfo.minLength = n2 + Math.min(n4, treeInfo.minLength);
            treeInfo.maxLength = n3 + Math.max(n5, treeInfo.maxLength);
            treeInfo.maxValid = bl2 & bl3 & treeInfo.maxValid;
            treeInfo.deterministic = false;
            return false;
        }
    }

    static class CIBackRef
    extends Node {
        int groupIndex;

        CIBackRef(int n2) {
            this.groupIndex = n2 + n2;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3 = matcher.groups[this.groupIndex];
            int n4 = matcher.groups[this.groupIndex + 1];
            int n5 = n4 - n3;
            if (n3 < 0) {
                return false;
            }
            if (n2 + n5 > matcher.to) {
                matcher.hitEnd = true;
                return false;
            }
            int n6 = n2;
            for (int i2 = 0; i2 < n5; ++i2) {
                int n7;
                int n8;
                int n9;
                int n10 = Character.codePointAt(charSequence, n6);
                if (n10 != (n9 = Character.codePointAt(charSequence, n3)) && (n8 = Character.toUpperCase(n10)) != (n7 = Character.toUpperCase(n9)) && (n8 = Character.toLowerCase(n8)) != (n7 = Character.toLowerCase(n7))) {
                    return false;
                }
                n6 += Character.charCount(n10);
                n3 += Character.charCount(n9);
            }
            return this.next.match(matcher, n2 + n5, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            treeInfo.maxValid = false;
            return this.next.study(treeInfo);
        }
    }

    static class CINotRange
    extends NotRange {
        int lower;
        int upper;

        CINotRange(int n2) {
            this.lower = n2 >>> 16;
            this.upper = n2 & 0xFFFF;
        }

        CINotRange(int n2, int n3) {
            super(n2, n3);
        }

        Node dup(boolean bl2) {
            if (bl2) {
                return new CIRange(this.lower, this.upper);
            }
            return new CINotRange(this.lower, this.upper);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 < matcher.to) {
                boolean bl2;
                int n3 = Character.codePointAt(charSequence, n2);
                boolean bl3 = bl2 = (n3 - this.lower | this.upper - n3) < 0;
                if (bl2) {
                    int n4 = Character.toUpperCase(n3);
                    boolean bl4 = bl2 = (n4 - this.lower | this.upper - n4) < 0;
                    if (bl2) {
                        bl2 = ((n4 = Character.toLowerCase(n4)) - this.lower | this.upper - n4) < 0;
                    }
                }
                return bl2 && this.next.match(matcher, n2 + Character.charCount(n3), charSequence);
            }
            matcher.hitEnd = true;
            return false;
        }
    }

    static final class CIRange
    extends Range {
        CIRange(int n2) {
            this.lower = n2 >>> 16;
            this.upper = n2 & 0xFFFF;
        }

        CIRange(int n2, int n3) {
            super(n2, n3);
        }

        Node dup(boolean bl2) {
            if (bl2) {
                return new CINotRange(this.lower, this.upper);
            }
            return new CIRange(this.lower, this.upper);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 < matcher.to) {
                boolean bl2;
                int n3 = Character.codePointAt(charSequence, n2);
                boolean bl3 = bl2 = (n3 - this.lower | this.upper - n3) >= 0;
                if (!bl2) {
                    int n4 = Character.toUpperCase(n3);
                    boolean bl4 = bl2 = (n4 - this.lower | this.upper - n4) >= 0;
                    if (!bl2) {
                        bl2 = ((n4 = Character.toLowerCase(n4)) - this.lower | this.upper - n4) >= 0;
                    }
                }
                return bl2 && this.next.match(matcher, n2 + Character.charCount(n3), charSequence);
            }
            matcher.hitEnd = true;
            return false;
        }
    }

    static final class Caret
    extends Node {
        Caret() {
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3 = matcher.from;
            int n4 = matcher.to;
            if (!matcher.anchoringBounds) {
                n3 = 0;
                n4 = matcher.getTextLength();
            }
            if (n2 == n4) {
                matcher.hitEnd = true;
                return false;
            }
            if (n2 > n3) {
                char c2 = charSequence.charAt(n2 - 1);
                if (c2 != '\n' && c2 != '\r' && (c2 | '\u0001') != 8233 && c2 != '\u0085') {
                    return false;
                }
                if (c2 == '\r' && charSequence.charAt(n2) == '\n') {
                    return false;
                }
            }
            return this.next.match(matcher, n2, charSequence);
        }
    }

    static final class Category
    extends Node {
        int atype;

        Category(int n2) {
            this.atype = n2;
        }

        Node dup(boolean bl2) {
            return new Category(bl2 ? ~this.atype : this.atype);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 >= matcher.to) {
                matcher.hitEnd = true;
                return false;
            }
            int n3 = Character.codePointAt(charSequence, n2);
            return (this.atype & 1 << Character.getType(n3)) != 0 && this.next.match(matcher, n2 + Character.charCount(n3), charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    static final class Conditional
    extends Node {
        Node cond;
        Node yes;
        Node not;

        Conditional(Node node, Node node2, Node node3) {
            this.cond = node;
            this.yes = node2;
            this.not = node3;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (this.cond.match(matcher, n2, charSequence)) {
                return this.yes.match(matcher, n2, charSequence);
            }
            return this.not.match(matcher, n2, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            int n2 = treeInfo.minLength;
            int n3 = treeInfo.maxLength;
            boolean bl2 = treeInfo.maxValid;
            treeInfo.reset();
            this.yes.study(treeInfo);
            int n4 = treeInfo.minLength;
            int n5 = treeInfo.maxLength;
            boolean bl3 = treeInfo.maxValid;
            treeInfo.reset();
            this.not.study(treeInfo);
            treeInfo.minLength = n2 + Math.min(n4, treeInfo.minLength);
            treeInfo.maxLength = n3 + Math.max(n5, treeInfo.maxLength);
            treeInfo.maxValid = bl2 & bl3 & treeInfo.maxValid;
            treeInfo.deterministic = false;
            return this.next.study(treeInfo);
        }
    }

    static final class Ctype
    extends Node {
        int ctype;

        Ctype(int n2) {
            this.ctype = n2;
        }

        Node dup(boolean bl2) {
            if (bl2) {
                return new NotCtype(this.ctype);
            }
            return new Ctype(this.ctype);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 >= matcher.to) {
                matcher.hitEnd = true;
                return false;
            }
            int n3 = Character.codePointAt(charSequence, n2);
            return n3 < 128 && ASCII.isType(n3, this.ctype) && this.next.match(matcher, n2 + 1, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    static final class Curly
    extends Node {
        Node atom;
        int type;
        int cmin;
        int cmax;

        Curly(Node node, int n2, int n3, int n4) {
            this.atom = node;
            this.type = n4;
            this.cmin = n2;
            this.cmax = n3;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3;
            for (n3 = 0; n3 < this.cmin; ++n3) {
                if (!this.atom.match(matcher, n2, charSequence)) {
                    return false;
                }
                n2 = matcher.last;
            }
            if (this.type == 0) {
                return this.match0(matcher, n2, n3, charSequence);
            }
            if (this.type == 1) {
                return this.match1(matcher, n2, n3, charSequence);
            }
            return this.match2(matcher, n2, n3, charSequence);
        }

        boolean match0(Matcher matcher, int n2, int n3, CharSequence charSequence) {
            int n4;
            if (n3 >= this.cmax) {
                return this.next.match(matcher, n2, charSequence);
            }
            int n5 = n3++;
            if (this.atom.match(matcher, n2, charSequence) && (n4 = matcher.last - n2) != 0) {
                n2 = matcher.last;
                while (n3 < this.cmax && this.atom.match(matcher, n2, charSequence)) {
                    if (n2 + n4 != matcher.last) {
                        if (!this.match0(matcher, matcher.last, n3 + 1, charSequence)) break;
                        return true;
                    }
                    n2 += n4;
                    ++n3;
                }
                while (n3 >= n5) {
                    if (this.next.match(matcher, n2, charSequence)) {
                        return true;
                    }
                    n2 -= n4;
                    --n3;
                }
                return false;
            }
            return this.next.match(matcher, n2, charSequence);
        }

        boolean match1(Matcher matcher, int n2, int n3, CharSequence charSequence) {
            while (!this.next.match(matcher, n2, charSequence)) {
                if (n3 >= this.cmax) {
                    return false;
                }
                if (!this.atom.match(matcher, n2, charSequence)) {
                    return false;
                }
                if (n2 == matcher.last) {
                    return false;
                }
                n2 = matcher.last;
                ++n3;
            }
            return true;
        }

        boolean match2(Matcher matcher, int n2, int n3, CharSequence charSequence) {
            while (n3 < this.cmax && this.atom.match(matcher, n2, charSequence) && n2 != matcher.last) {
                n2 = matcher.last;
                ++n3;
            }
            return this.next.match(matcher, n2, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            int n2 = treeInfo.minLength;
            int n3 = treeInfo.maxLength;
            boolean bl2 = treeInfo.maxValid;
            boolean bl3 = treeInfo.deterministic;
            treeInfo.reset();
            this.atom.study(treeInfo);
            int n4 = treeInfo.minLength * this.cmin + n2;
            if (n4 < n2) {
                n4 = 0xFFFFFFF;
            }
            treeInfo.minLength = n4;
            if (bl2 & treeInfo.maxValid) {
                treeInfo.maxLength = n4 = treeInfo.maxLength * this.cmax + n3;
                if (n4 < n3) {
                    treeInfo.maxValid = false;
                }
            } else {
                treeInfo.maxValid = false;
            }
            treeInfo.deterministic = treeInfo.deterministic && this.cmin == this.cmax ? bl3 : false;
            return this.next.study(treeInfo);
        }
    }

    static final class Dollar
    extends Node {
        boolean multiline;

        Dollar(boolean bl2) {
            this.multiline = bl2;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            char c2;
            int n3;
            int n4 = n3 = matcher.anchoringBounds ? matcher.to : matcher.getTextLength();
            if (!this.multiline) {
                if (n2 < n3 - 2) {
                    return false;
                }
                if (n2 == n3 - 2) {
                    c2 = charSequence.charAt(n2);
                    if (c2 != '\r') {
                        return false;
                    }
                    c2 = charSequence.charAt(n2 + 1);
                    if (c2 != '\n') {
                        return false;
                    }
                }
            }
            if (n2 < n3) {
                c2 = charSequence.charAt(n2);
                if (c2 == '\n') {
                    if (n2 > 0 && charSequence.charAt(n2 - 1) == '\r') {
                        return false;
                    }
                    if (this.multiline) {
                        return this.next.match(matcher, n2, charSequence);
                    }
                } else if (c2 == '\r' || c2 == '\u0085' || (c2 | '\u0001') == 8233) {
                    if (this.multiline) {
                        return this.next.match(matcher, n2, charSequence);
                    }
                } else {
                    return false;
                }
            }
            matcher.hitEnd = true;
            matcher.requireEnd = true;
            return this.next.match(matcher, n2, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            this.next.study(treeInfo);
            return treeInfo.deterministic;
        }
    }

    static final class Dot
    extends Node {
        Dot() {
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 < matcher.to) {
                int n3 = Character.codePointAt(charSequence, n2);
                return n3 != 10 && n3 != 13 && (n3 | 1) != 8233 && n3 != 133 && this.next.match(matcher, n2 + Character.charCount(n3), charSequence);
            }
            matcher.hitEnd = true;
            return false;
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    static class Dummy
    extends Node {
        Dummy() {
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            return this.next.match(matcher, n2, charSequence);
        }
    }

    static final class End
    extends Node {
        End() {
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3;
            int n4 = n3 = matcher.anchoringBounds ? matcher.to : matcher.getTextLength();
            if (n2 == n3) {
                matcher.hitEnd = true;
                return this.next.match(matcher, n2, charSequence);
            }
            return false;
        }
    }

    static final class First
    extends Node {
        Node atom;

        First(Node node) {
            this.atom = BnM.optimize(node);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (this.atom instanceof BnM) {
                return this.atom.match(matcher, n2, charSequence) && this.next.match(matcher, matcher.last, charSequence);
            }
            while (true) {
                if (n2 > matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                if (this.atom.match(matcher, n2, charSequence)) {
                    return this.next.match(matcher, matcher.last, charSequence);
                }
                n2 += Pattern.countChars(charSequence, n2, 1);
                ++matcher.first;
            }
        }

        boolean study(TreeInfo treeInfo) {
            this.atom.study(treeInfo);
            treeInfo.maxValid = false;
            treeInfo.deterministic = false;
            return this.next.study(treeInfo);
        }
    }

    static final class GroupCurly
    extends Node {
        Node atom;
        int type;
        int cmin;
        int cmax;
        int localIndex;
        int groupIndex;
        boolean capture;

        GroupCurly(Node node, int n2, int n3, int n4, int n5, int n6, boolean bl2) {
            this.atom = node;
            this.type = n4;
            this.cmin = n2;
            this.cmax = n3;
            this.localIndex = n5;
            this.groupIndex = n6;
            this.capture = bl2;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int[] nArray = matcher.groups;
            int[] nArray2 = matcher.locals;
            int n3 = nArray2[this.localIndex];
            int n4 = 0;
            int n5 = 0;
            if (this.capture) {
                n4 = nArray[this.groupIndex];
                n5 = nArray[this.groupIndex + 1];
            }
            nArray2[this.localIndex] = -1;
            boolean bl2 = true;
            for (int i2 = 0; i2 < this.cmin; ++i2) {
                if (this.atom.match(matcher, n2, charSequence)) {
                    if (this.capture) {
                        nArray[this.groupIndex] = n2;
                        nArray[this.groupIndex + 1] = matcher.last;
                    }
                } else {
                    bl2 = false;
                    break;
                }
                n2 = matcher.last;
            }
            if (!bl2) {
                nArray2[this.localIndex] = n3;
                if (this.capture) {
                    nArray[this.groupIndex] = n4;
                    nArray[this.groupIndex + 1] = n5;
                }
            } else {
                bl2 = this.type == 0 ? this.match0(matcher, n2, this.cmin, charSequence) : (this.type == 1 ? this.match1(matcher, n2, this.cmin, charSequence) : this.match2(matcher, n2, this.cmin, charSequence));
            }
            return bl2;
        }

        boolean match0(Matcher matcher, int n2, int n3, CharSequence charSequence) {
            int[] nArray = matcher.groups;
            int n4 = 0;
            int n5 = 0;
            if (this.capture) {
                n4 = nArray[this.groupIndex];
                n5 = nArray[this.groupIndex + 1];
            }
            if (n3 < this.cmax && this.atom.match(matcher, n2, charSequence)) {
                int n6 = matcher.last - n2;
                if (n6 <= 0) {
                    if (this.capture) {
                        nArray[this.groupIndex] = n2;
                        nArray[this.groupIndex + 1] = n2 + n6;
                    }
                    n2 += n6;
                } else {
                    block13: {
                        do {
                            if (this.capture) {
                                nArray[this.groupIndex] = n2;
                                nArray[this.groupIndex + 1] = n2 + n6;
                            }
                            if (++n3 >= this.cmax || !this.atom.match(matcher, n2 += n6, charSequence)) break block13;
                        } while (n2 + n6 == matcher.last);
                        if (this.match0(matcher, n2, n3, charSequence)) {
                            return true;
                        }
                    }
                    while (n3 > this.cmin) {
                        if (this.next.match(matcher, n2, charSequence)) {
                            if (this.capture) {
                                nArray[this.groupIndex + 1] = n2;
                                nArray[this.groupIndex] = n2 - n6;
                            }
                            n2 -= n6;
                            return true;
                        }
                        if (this.capture) {
                            nArray[this.groupIndex + 1] = n2;
                            nArray[this.groupIndex] = n2 - n6;
                        }
                        n2 -= n6;
                        --n3;
                    }
                }
            }
            if (this.capture) {
                nArray[this.groupIndex] = n4;
                nArray[this.groupIndex + 1] = n5;
            }
            return this.next.match(matcher, n2, charSequence);
        }

        boolean match1(Matcher matcher, int n2, int n3, CharSequence charSequence) {
            while (!this.next.match(matcher, n2, charSequence)) {
                if (n3 >= this.cmax) {
                    return false;
                }
                if (!this.atom.match(matcher, n2, charSequence)) {
                    return false;
                }
                if (n2 == matcher.last) {
                    return false;
                }
                if (this.capture) {
                    matcher.groups[this.groupIndex] = n2;
                    matcher.groups[this.groupIndex + 1] = matcher.last;
                }
                n2 = matcher.last;
                ++n3;
            }
            return true;
        }

        boolean match2(Matcher matcher, int n2, int n3, CharSequence charSequence) {
            while (n3 < this.cmax && this.atom.match(matcher, n2, charSequence)) {
                if (this.capture) {
                    matcher.groups[this.groupIndex] = n2;
                    matcher.groups[this.groupIndex + 1] = matcher.last;
                }
                if (n2 == matcher.last) break;
                n2 = matcher.last;
                ++n3;
            }
            return this.next.match(matcher, n2, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            int n2 = treeInfo.minLength;
            int n3 = treeInfo.maxLength;
            boolean bl2 = treeInfo.maxValid;
            boolean bl3 = treeInfo.deterministic;
            treeInfo.reset();
            this.atom.study(treeInfo);
            int n4 = treeInfo.minLength * this.cmin + n2;
            if (n4 < n2) {
                n4 = 0xFFFFFFF;
            }
            treeInfo.minLength = n4;
            if (bl2 & treeInfo.maxValid) {
                treeInfo.maxLength = n4 = treeInfo.maxLength * this.cmax + n3;
                if (n4 < n3) {
                    treeInfo.maxValid = false;
                }
            } else {
                treeInfo.maxValid = false;
            }
            treeInfo.deterministic = treeInfo.deterministic && this.cmin == this.cmax ? bl3 : false;
            return this.next.study(treeInfo);
        }
    }

    static final class GroupHead
    extends Node {
        int localIndex;

        GroupHead(int n2) {
            this.localIndex = n2;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3 = matcher.locals[this.localIndex];
            matcher.locals[this.localIndex] = n2;
            boolean bl2 = this.next.match(matcher, n2, charSequence);
            matcher.locals[this.localIndex] = n3;
            return bl2;
        }

        boolean matchRef(Matcher matcher, int n2, CharSequence charSequence) {
            int n3 = matcher.locals[this.localIndex];
            matcher.locals[this.localIndex] = ~n2;
            boolean bl2 = this.next.match(matcher, n2, charSequence);
            matcher.locals[this.localIndex] = n3;
            return bl2;
        }
    }

    static final class GroupRef
    extends Node {
        GroupHead head;

        GroupRef(GroupHead groupHead) {
            this.head = groupHead;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            return this.head.matchRef(matcher, n2, charSequence) && this.next.match(matcher, matcher.last, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            treeInfo.maxValid = false;
            treeInfo.deterministic = false;
            return this.next.study(treeInfo);
        }
    }

    static final class GroupTail
    extends Node {
        int localIndex;
        int groupIndex;

        GroupTail(int n2, int n3) {
            this.localIndex = n2;
            this.groupIndex = n3 + n3;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3 = matcher.locals[this.localIndex];
            if (n3 >= 0) {
                int n4 = matcher.groups[this.groupIndex];
                int n5 = matcher.groups[this.groupIndex + 1];
                matcher.groups[this.groupIndex] = n3;
                matcher.groups[this.groupIndex + 1] = n2;
                if (this.next.match(matcher, n2, charSequence)) {
                    return true;
                }
                matcher.groups[this.groupIndex] = n4;
                matcher.groups[this.groupIndex + 1] = n5;
                return false;
            }
            matcher.last = n2;
            return true;
        }
    }

    static final class JavaDefined
    extends JavaTypeClass {
        JavaDefined() {
        }

        boolean isProperty(int n2) {
            return Character.isDefined(n2);
        }
    }

    static final class JavaDigit
    extends JavaTypeClass {
        JavaDigit() {
        }

        boolean isProperty(int n2) {
            return Character.isDigit(n2);
        }
    }

    static final class JavaISOControl
    extends JavaTypeClass {
        JavaISOControl() {
        }

        boolean isProperty(int n2) {
            return Character.isISOControl(n2);
        }
    }

    static final class JavaIdentifierIgnorable
    extends JavaTypeClass {
        JavaIdentifierIgnorable() {
        }

        boolean isProperty(int n2) {
            return Character.isIdentifierIgnorable(n2);
        }
    }

    static final class JavaJavaIdentifierPart
    extends JavaTypeClass {
        JavaJavaIdentifierPart() {
        }

        boolean isProperty(int n2) {
            return Character.isJavaIdentifierPart(n2);
        }
    }

    static final class JavaJavaIdentifierStart
    extends JavaTypeClass {
        JavaJavaIdentifierStart() {
        }

        boolean isProperty(int n2) {
            return Character.isJavaIdentifierStart(n2);
        }
    }

    static final class JavaLetter
    extends JavaTypeClass {
        JavaLetter() {
        }

        boolean isProperty(int n2) {
            return Character.isLetter(n2);
        }
    }

    static final class JavaLetterOrDigit
    extends JavaTypeClass {
        JavaLetterOrDigit() {
        }

        boolean isProperty(int n2) {
            return Character.isLetterOrDigit(n2);
        }
    }

    static final class JavaLowerCase
    extends JavaTypeClass {
        JavaLowerCase() {
        }

        boolean isProperty(int n2) {
            return Character.isLowerCase(n2);
        }
    }

    static final class JavaMirrored
    extends JavaTypeClass {
        JavaMirrored() {
        }

        boolean isProperty(int n2) {
            return Character.isMirrored(n2);
        }
    }

    static final class JavaSpaceChar
    extends JavaTypeClass {
        JavaSpaceChar() {
        }

        boolean isProperty(int n2) {
            return Character.isSpaceChar(n2);
        }
    }

    static final class JavaTitleCase
    extends JavaTypeClass {
        JavaTitleCase() {
        }

        boolean isProperty(int n2) {
            return Character.isTitleCase(n2);
        }
    }

    static abstract class JavaTypeClass
    extends Node {
        JavaTypeClass() {
        }

        Node dup(boolean bl2) {
            Node node = null;
            try {
                node = (Node)this.getClass().newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new Error("Cannot instantiate node");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new Error("Cannot instantiate node");
            }
            if (bl2) {
                return new Not(node);
            }
            return node;
        }

        abstract boolean isProperty(int var1);

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 >= matcher.to) {
                matcher.hitEnd = true;
                return false;
            }
            int n3 = Character.codePointAt(charSequence, n2);
            return this.isProperty(n3) && this.next.match(matcher, n2 + Character.charCount(n3), charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    static final class JavaUnicodeIdentifierPart
    extends JavaTypeClass {
        JavaUnicodeIdentifierPart() {
        }

        boolean isProperty(int n2) {
            return Character.isUnicodeIdentifierPart(n2);
        }
    }

    static final class JavaUnicodeIdentifierStart
    extends JavaTypeClass {
        JavaUnicodeIdentifierStart() {
        }

        boolean isProperty(int n2) {
            return Character.isUnicodeIdentifierStart(n2);
        }
    }

    static final class JavaUpperCase
    extends JavaTypeClass {
        JavaUpperCase() {
        }

        boolean isProperty(int n2) {
            return Character.isUpperCase(n2);
        }
    }

    static final class JavaWhitespace
    extends JavaTypeClass {
        JavaWhitespace() {
        }

        boolean isProperty(int n2) {
            return Character.isWhitespace(n2);
        }
    }

    static final class LastMatch
    extends Node {
        LastMatch() {
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 != matcher.oldLast) {
                return false;
            }
            return this.next.match(matcher, n2, charSequence);
        }
    }

    static class LastNode
    extends Node {
        LastNode() {
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (matcher.acceptMode == 1 && n2 != matcher.to) {
                return false;
            }
            matcher.last = n2;
            matcher.groups[0] = matcher.first;
            matcher.groups[1] = matcher.last;
            return true;
        }
    }

    static final class LazyLoop
    extends Loop {
        LazyLoop(int n2, int n3) {
            super(n2, n3);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 > matcher.locals[this.beginIndex]) {
                int n3 = matcher.locals[this.countIndex];
                if (n3 < this.cmin) {
                    matcher.locals[this.countIndex] = n3 + 1;
                    boolean bl2 = this.body.match(matcher, n2, charSequence);
                    if (!bl2) {
                        matcher.locals[this.countIndex] = n3;
                    }
                    return bl2;
                }
                if (this.next.match(matcher, n2, charSequence)) {
                    return true;
                }
                if (n3 < this.cmax) {
                    matcher.locals[this.countIndex] = n3 + 1;
                    boolean bl3 = this.body.match(matcher, n2, charSequence);
                    if (!bl3) {
                        matcher.locals[this.countIndex] = n3;
                    }
                    return bl3;
                }
                return false;
            }
            return this.next.match(matcher, n2, charSequence);
        }

        boolean matchInit(Matcher matcher, int n2, CharSequence charSequence) {
            int n3 = matcher.locals[this.countIndex];
            boolean bl2 = false;
            if (0 < this.cmin) {
                matcher.locals[this.countIndex] = 1;
                bl2 = this.body.match(matcher, n2, charSequence);
            } else if (this.next.match(matcher, n2, charSequence)) {
                bl2 = true;
            } else if (0 < this.cmax) {
                matcher.locals[this.countIndex] = 1;
                bl2 = this.body.match(matcher, n2, charSequence);
            }
            matcher.locals[this.countIndex] = n3;
            return bl2;
        }

        boolean study(TreeInfo treeInfo) {
            treeInfo.maxValid = false;
            treeInfo.deterministic = false;
            return false;
        }
    }

    static class Loop
    extends Node {
        Node body;
        int countIndex;
        int beginIndex;
        int cmin;
        int cmax;

        Loop(int n2, int n3) {
            this.countIndex = n2;
            this.beginIndex = n3;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 > matcher.locals[this.beginIndex]) {
                int n3 = matcher.locals[this.countIndex];
                if (n3 < this.cmin) {
                    matcher.locals[this.countIndex] = n3 + 1;
                    boolean bl2 = this.body.match(matcher, n2, charSequence);
                    if (!bl2) {
                        matcher.locals[this.countIndex] = n3;
                    }
                    return bl2;
                }
                if (n3 < this.cmax) {
                    matcher.locals[this.countIndex] = n3 + 1;
                    boolean bl3 = this.body.match(matcher, n2, charSequence);
                    if (!bl3) {
                        matcher.locals[this.countIndex] = n3;
                    } else {
                        return true;
                    }
                }
            }
            return this.next.match(matcher, n2, charSequence);
        }

        boolean matchInit(Matcher matcher, int n2, CharSequence charSequence) {
            int n3 = matcher.locals[this.countIndex];
            boolean bl2 = false;
            if (0 < this.cmin) {
                matcher.locals[this.countIndex] = 1;
                bl2 = this.body.match(matcher, n2, charSequence);
            } else if (0 < this.cmax) {
                matcher.locals[this.countIndex] = 1;
                bl2 = this.body.match(matcher, n2, charSequence);
                if (!bl2) {
                    bl2 = this.next.match(matcher, n2, charSequence);
                }
            } else {
                bl2 = this.next.match(matcher, n2, charSequence);
            }
            matcher.locals[this.countIndex] = n3;
            return bl2;
        }

        boolean study(TreeInfo treeInfo) {
            treeInfo.maxValid = false;
            treeInfo.deterministic = false;
            return false;
        }
    }

    static final class Neg
    extends Node {
        Node cond;

        Neg(Node node) {
            this.cond = node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3 = matcher.to;
            boolean bl2 = false;
            if (matcher.transparentBounds) {
                matcher.to = matcher.getTextLength();
            }
            try {
                if (n2 < matcher.to) {
                    bl2 = !this.cond.match(matcher, n2, charSequence);
                } else {
                    matcher.requireEnd = true;
                    bl2 = !this.cond.match(matcher, n2, charSequence);
                }
            }
            finally {
                matcher.to = n3;
            }
            return bl2 && this.next.match(matcher, n2, charSequence);
        }
    }

    static class Node {
        Node next = accept;

        Node() {
        }

        Node dup(boolean bl2) {
            if (bl2) {
                return new Not(this);
            }
            throw new RuntimeException("internal error in Node dup()");
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            matcher.last = n2;
            matcher.groups[0] = matcher.first;
            matcher.groups[1] = matcher.last;
            return true;
        }

        boolean study(TreeInfo treeInfo) {
            if (this.next != null) {
                return this.next.study(treeInfo);
            }
            return treeInfo.deterministic;
        }
    }

    static final class Not
    extends Node {
        Node atom;

        Not(Node node) {
            this.atom = node;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            return !this.atom.match(matcher, n2, charSequence) && this.next.match(matcher, n2 + Pattern.countChars(charSequence, n2, 1), charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    static class NotBehind
    extends Node {
        Node cond;
        int rmax;
        int rmin;

        NotBehind(Node node, int n2, int n3) {
            this.cond = node;
            this.rmax = n2;
            this.rmin = n3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3 = matcher.from;
            boolean bl2 = false;
            int n4 = !matcher.transparentBounds ? matcher.from : 0;
            int n5 = Math.max(n2 - this.rmax, n4);
            for (int i2 = n2 - this.rmin; i2 >= n5; --i2) {
                if (matcher.transparentBounds) {
                    matcher.from = 0;
                }
                try {
                    bl2 = this.cond.match(matcher, i2, charSequence) && matcher.last == n2;
                }
                finally {
                    matcher.from = n3;
                }
                if (!bl2) continue;
                return false;
            }
            return this.next.match(matcher, n2, charSequence);
        }
    }

    static final class NotBehindS
    extends NotBehind {
        NotBehindS(Node node, int n2, int n3) {
            super(node, n2, n3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3 = Pattern.countChars(charSequence, n2, -this.rmax);
            int n4 = Pattern.countChars(charSequence, n2, -this.rmin);
            int n5 = matcher.from;
            boolean bl2 = false;
            int n6 = !matcher.transparentBounds ? matcher.from : 0;
            int n7 = Math.max(n2 - n3, n6);
            for (int i2 = n2 - n4; i2 >= n7; i2 -= i2 > n7 ? Pattern.countChars(charSequence, i2, -1) : 1) {
                if (matcher.transparentBounds) {
                    matcher.from = 0;
                }
                try {
                    bl2 = this.cond.match(matcher, i2, charSequence) && matcher.last == n2;
                }
                finally {
                    matcher.from = n5;
                }
                if (!bl2) continue;
                return false;
            }
            return this.next.match(matcher, n2, charSequence);
        }
    }

    static final class NotCtype
    extends Node {
        int ctype;

        NotCtype(int n2) {
            this.ctype = n2;
        }

        Node dup(boolean bl2) {
            if (bl2) {
                return new Ctype(this.ctype);
            }
            return new NotCtype(this.ctype);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 >= matcher.to) {
                matcher.hitEnd = true;
                return false;
            }
            int n3 = Character.codePointAt(charSequence, n2);
            return (n3 >= 128 || !ASCII.isType(n3, this.ctype)) && this.next.match(matcher, n2 + Character.charCount(n3), charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    static class NotRange
    extends Node {
        int lower;
        int upper;

        NotRange() {
        }

        NotRange(int n2) {
            this.lower = n2 >>> 16;
            this.upper = n2 & 0xFFFF;
        }

        NotRange(int n2, int n3) {
            this.lower = n2;
            this.upper = n3;
        }

        Node dup(boolean bl2) {
            if (bl2) {
                return new Range(this.lower, this.upper);
            }
            return new NotRange(this.lower, this.upper);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 < matcher.to) {
                int n3 = Character.codePointAt(charSequence, n2);
                return (n3 - this.lower | this.upper - n3) < 0 && this.next.match(matcher, n2 + Character.charCount(n3), charSequence);
            }
            matcher.hitEnd = true;
            return false;
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    static final class NotSingle
    extends Node {
        int ch;

        NotSingle(int n2) {
            this.ch = n2;
        }

        Node dup(boolean bl2) {
            if (bl2) {
                return new Single(this.ch);
            }
            return new NotSingle(this.ch);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 >= matcher.to) {
                matcher.hitEnd = true;
                return false;
            }
            int n3 = Character.codePointAt(charSequence, n2);
            return n3 != this.ch && this.next.match(matcher, n2 + Character.charCount(n3), charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    static final class NotSingleA
    extends Node {
        int ch;

        NotSingleA(int n2) {
            this.ch = ASCII.toLower(n2);
        }

        Node dup(boolean bl2) {
            if (bl2) {
                return new SingleA(this.ch);
            }
            return new NotSingleA(this.ch);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3;
            if (n2 < matcher.to && (n3 = Character.codePointAt(charSequence, n2)) != this.ch && ASCII.toLower(n3) != this.ch) {
                return this.next.match(matcher, n2 + Character.charCount(n3), charSequence);
            }
            matcher.hitEnd = true;
            return false;
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    static final class NotSingleU
    extends Node {
        int ch;

        NotSingleU(int n2) {
            this.ch = Character.toLowerCase(Character.toUpperCase((char)n2));
        }

        Node dup(boolean bl2) {
            if (bl2) {
                return new SingleU(this.ch);
            }
            return new NotSingleU(this.ch);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 < matcher.to) {
                int n3 = Character.codePointAt(charSequence, n2);
                if (n3 == this.ch) {
                    return false;
                }
                int n4 = Character.toUpperCase(n3);
                if ((n4 = Character.toLowerCase(n4)) != this.ch) {
                    return this.next.match(matcher, n2 + Character.charCount(n3), charSequence);
                }
            }
            matcher.hitEnd = true;
            return false;
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    static final class Pos
    extends Node {
        Node cond;

        Pos(Node node) {
            this.cond = node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3 = matcher.to;
            boolean bl2 = false;
            if (matcher.transparentBounds) {
                matcher.to = matcher.getTextLength();
            }
            try {
                bl2 = this.cond.match(matcher, n2, charSequence);
            }
            finally {
                matcher.to = n3;
            }
            return bl2 && this.next.match(matcher, n2, charSequence);
        }
    }

    static final class Prolog
    extends Node {
        Loop loop;

        Prolog(Loop loop) {
            this.loop = loop;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            return this.loop.matchInit(matcher, n2, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            return this.loop.study(treeInfo);
        }
    }

    static final class Ques
    extends Node {
        Node atom;
        int type;

        Ques(Node node, int n2) {
            this.atom = node;
            this.type = n2;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            switch (this.type) {
                case 0: {
                    return this.atom.match(matcher, n2, charSequence) && this.next.match(matcher, matcher.last, charSequence) || this.next.match(matcher, n2, charSequence);
                }
                case 1: {
                    return this.next.match(matcher, n2, charSequence) || this.atom.match(matcher, n2, charSequence) && this.next.match(matcher, matcher.last, charSequence);
                }
                case 2: {
                    if (this.atom.match(matcher, n2, charSequence)) {
                        n2 = matcher.last;
                    }
                    return this.next.match(matcher, n2, charSequence);
                }
            }
            return this.atom.match(matcher, n2, charSequence) && this.next.match(matcher, matcher.last, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            if (this.type != 3) {
                int n2 = treeInfo.minLength;
                this.atom.study(treeInfo);
                treeInfo.minLength = n2;
                treeInfo.deterministic = false;
                return this.next.study(treeInfo);
            }
            this.atom.study(treeInfo);
            return this.next.study(treeInfo);
        }
    }

    static class Range
    extends Node {
        int lower;
        int upper;

        Range() {
        }

        Range(int n2) {
            this.lower = n2 >>> 16;
            this.upper = n2 & 0xFFFF;
        }

        Range(int n2, int n3) {
            this.lower = n2;
            this.upper = n3;
        }

        Node dup(boolean bl2) {
            if (bl2) {
                return new NotRange(this.lower, this.upper);
            }
            return new Range(this.lower, this.upper);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 < matcher.to) {
                int n3 = Character.codePointAt(charSequence, n2);
                return (n3 - this.lower | this.upper - n3) >= 0 && this.next.match(matcher, n2 + Character.charCount(n3), charSequence);
            }
            matcher.hitEnd = true;
            return false;
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    static final class Single
    extends Node {
        int ch;
        int len;

        Single(int n2) {
            this.ch = n2;
            this.len = Character.charCount(this.ch);
        }

        Node dup(boolean bl2) {
            if (bl2) {
                return new NotSingle(this.ch);
            }
            return new Single(this.ch);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 >= matcher.to) {
                matcher.hitEnd = true;
                return false;
            }
            int n3 = Character.codePointAt(charSequence, n2);
            return n3 == this.ch && this.next.match(matcher, n2 + this.len, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    static final class SingleA
    extends Node {
        int ch;

        SingleA(int n2) {
            this.ch = ASCII.toLower(n2);
        }

        Node dup(boolean bl2) {
            if (bl2) {
                return new NotSingleA(this.ch);
            }
            return new SingleA(this.ch);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            char c2;
            if (n2 < matcher.to && ((c2 = charSequence.charAt(n2)) == this.ch || ASCII.toLower(c2) == this.ch)) {
                return this.next.match(matcher, n2 + 1, charSequence);
            }
            matcher.hitEnd = true;
            return false;
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    static final class SingleU
    extends Node {
        int ch;
        int len;

        SingleU(int n2) {
            this.ch = Character.toLowerCase(Character.toUpperCase(n2));
            this.len = Character.charCount(this.ch);
        }

        Node dup(boolean bl2) {
            if (bl2) {
                return new NotSingleU(this.ch);
            }
            return new SingleU(this.ch);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 < matcher.to) {
                int n3 = Character.codePointAt(charSequence, n2);
                if (n3 == this.ch) {
                    return this.next.match(matcher, n2 + this.len, charSequence);
                }
                int n4 = Character.toUpperCase(n3);
                if ((n4 = Character.toLowerCase(n4)) == this.ch) {
                    return this.next.match(matcher, n2 + Character.charCount(n3), charSequence);
                }
            }
            matcher.hitEnd = true;
            return false;
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    static class Slice
    extends Node {
        int[] buffer;

        Slice(int[] nArray) {
            this.buffer = nArray;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int[] nArray = this.buffer;
            int n3 = nArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                if (n2 + i2 >= matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                if (nArray[i2] == charSequence.charAt(n2 + i2)) continue;
                return false;
            }
            return this.next.match(matcher, n2 + n3, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            treeInfo.minLength += this.buffer.length;
            treeInfo.maxLength += this.buffer.length;
            return this.next.study(treeInfo);
        }
    }

    static final class SliceA
    extends Node {
        int[] buffer;

        SliceA(int[] nArray) {
            this.buffer = nArray;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int[] nArray = this.buffer;
            int n3 = nArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                if (n2 + i2 >= matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                int n4 = ASCII.toLower(charSequence.charAt(n2 + i2));
                if (nArray[i2] == n4) continue;
                return false;
            }
            return this.next.match(matcher, n2 + n3, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            treeInfo.minLength += this.buffer.length;
            treeInfo.maxLength += this.buffer.length;
            return this.next.study(treeInfo);
        }
    }

    static final class SliceS
    extends Slice {
        SliceS(int[] nArray) {
            super(nArray);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int[] nArray = this.buffer;
            int n3 = n2;
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (n3 >= matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                int n4 = Character.codePointAt(charSequence, n3);
                if (nArray[i2] != n4) {
                    return false;
                }
                if ((n3 += Character.charCount(n4)) <= matcher.to) continue;
                matcher.hitEnd = true;
                return false;
            }
            return this.next.match(matcher, n3, charSequence);
        }
    }

    static final class SliceU
    extends Node {
        int[] buffer;

        SliceU(int[] nArray) {
            this.buffer = nArray;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int[] nArray = this.buffer;
            int n3 = n2;
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (n3 >= matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                int n4 = Character.codePointAt(charSequence, n3);
                int n5 = Character.toUpperCase(n4);
                if (nArray[i2] != (n5 = Character.toLowerCase(n5))) {
                    return false;
                }
                if ((n3 += Character.charCount(n4)) <= matcher.to) continue;
                matcher.hitEnd = true;
                return false;
            }
            return this.next.match(matcher, n3, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            treeInfo.minLength += this.buffer.length;
            treeInfo.maxLength += this.buffer.length;
            return this.next.study(treeInfo);
        }
    }

    static final class Specials
    extends Node {
        Specials() {
        }

        Node dup(boolean bl2) {
            if (bl2) {
                return new Not(this);
            }
            return new Specials();
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 < matcher.to) {
                char c2 = charSequence.charAt(n2);
                return ((c2 - 65520 | 65533 - c2) >= 0 || c2 == '\ufeff') && this.next.match(matcher, n2 + 1, charSequence);
            }
            matcher.hitEnd = true;
            return false;
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    static class Start
    extends Node {
        int minLength;

        Start(Node node) {
            this.next = node;
            TreeInfo treeInfo = new TreeInfo();
            this.next.study(treeInfo);
            this.minLength = treeInfo.minLength;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 > matcher.to - this.minLength) {
                matcher.hitEnd = true;
                return false;
            }
            boolean bl2 = false;
            int n3 = matcher.to - this.minLength;
            while (n2 <= n3 && !(bl2 = this.next.match(matcher, n2, charSequence))) {
                if (n2 == n3) {
                    matcher.hitEnd = true;
                }
                ++n2;
            }
            if (bl2) {
                matcher.groups[0] = matcher.first = n2;
                matcher.groups[1] = matcher.last;
            }
            return bl2;
        }

        boolean study(TreeInfo treeInfo) {
            this.next.study(treeInfo);
            treeInfo.maxValid = false;
            treeInfo.deterministic = false;
            return false;
        }
    }

    static final class StartS
    extends Start {
        StartS(Node node) {
            super(node);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 > matcher.to - this.minLength) {
                matcher.hitEnd = true;
                return false;
            }
            boolean bl2 = false;
            int n3 = matcher.to - this.minLength;
            while (n2 <= n3 && !(bl2 = this.next.match(matcher, n2, charSequence)) && n2 != n3) {
                if (Character.isHighSurrogate(charSequence.charAt(n2++)) && n2 < charSequence.length() && Character.isLowSurrogate(charSequence.charAt(n2))) {
                    ++n2;
                }
                if (n2 != n3) continue;
                matcher.hitEnd = true;
            }
            if (bl2) {
                matcher.groups[0] = matcher.first = n2;
                matcher.groups[1] = matcher.last;
            }
            return bl2;
        }
    }

    static final class Sub
    extends Add {
        Sub(Node node, Node node2) {
            super(node, node2);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 < matcher.to) {
                return !this.rhs.match(matcher, n2, charSequence) && this.lhs.match(matcher, n2, charSequence) && this.next.match(matcher, matcher.last, charSequence);
            }
            matcher.hitEnd = true;
            return false;
        }

        boolean study(TreeInfo treeInfo) {
            this.lhs.study(treeInfo);
            return this.next.study(treeInfo);
        }
    }

    static final class TreeInfo {
        int minLength;
        int maxLength;
        boolean maxValid;
        boolean deterministic;

        TreeInfo() {
            this.reset();
        }

        void reset() {
            this.minLength = 0;
            this.maxLength = 0;
            this.maxValid = true;
            this.deterministic = true;
        }
    }

    static final class UBlock
    extends Node {
        Character.UnicodeBlock block;
        boolean complementMe = false;

        UBlock() {
        }

        UBlock(Character.UnicodeBlock unicodeBlock, boolean bl2) {
            this.block = unicodeBlock;
            this.complementMe = bl2;
        }

        Node dup(boolean bl2) {
            if (bl2) {
                return new UBlock(this.block, !this.complementMe);
            }
            return new UBlock(this.block, this.complementMe);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (this.complementMe) {
                return this.notMatch(matcher, n2, charSequence);
            }
            if (n2 < matcher.to) {
                int n3 = Character.codePointAt(charSequence, n2);
                return this.block == Character.UnicodeBlock.of(n3) && this.next.match(matcher, n2 + Character.charCount(n3), charSequence);
            }
            matcher.hitEnd = true;
            return false;
        }

        boolean notMatch(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 < matcher.to) {
                int n3 = Character.codePointAt(charSequence, n2);
                return this.block != Character.UnicodeBlock.of(n3) && this.next.match(matcher, n2 + Character.charCount(n3), charSequence);
            }
            matcher.hitEnd = true;
            return false;
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    static final class UnixCaret
    extends Node {
        UnixCaret() {
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            char c2;
            int n3 = matcher.from;
            int n4 = matcher.to;
            if (!matcher.anchoringBounds) {
                n3 = 0;
                n4 = matcher.getTextLength();
            }
            if (n2 == n4) {
                matcher.hitEnd = true;
                return false;
            }
            if (n2 > n3 && (c2 = charSequence.charAt(n2 - 1)) != '\n') {
                return false;
            }
            return this.next.match(matcher, n2, charSequence);
        }
    }

    static final class UnixDollar
    extends Node {
        boolean multiline;

        UnixDollar(boolean bl2) {
            this.multiline = bl2;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3;
            int n4 = n3 = matcher.anchoringBounds ? matcher.to : matcher.getTextLength();
            if (n2 < n3) {
                char c2 = charSequence.charAt(n2);
                if (c2 == '\n') {
                    if (!this.multiline && n2 != n3 - 1) {
                        return false;
                    }
                    if (this.multiline) {
                        return this.next.match(matcher, n2, charSequence);
                    }
                } else {
                    return false;
                }
            }
            matcher.hitEnd = true;
            matcher.requireEnd = true;
            return this.next.match(matcher, n2, charSequence);
        }

        boolean study(TreeInfo treeInfo) {
            this.next.study(treeInfo);
            return treeInfo.deterministic;
        }
    }

    static final class UnixDot
    extends Node {
        UnixDot() {
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 < matcher.to) {
                int n3 = Character.codePointAt(charSequence, n2);
                return n3 != 10 && this.next.match(matcher, n2 + Character.charCount(n3), charSequence);
            }
            matcher.hitEnd = true;
            return false;
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }
    }

    static class categoryNames {
        static HashMap cMap = new HashMap();

        categoryNames() {
        }

        static {
            cMap.put("Cn", new Category(1));
            cMap.put("Lu", new Category(2));
            cMap.put("Ll", new Category(4));
            cMap.put("Lt", new Category(8));
            cMap.put("Lm", new Category(16));
            cMap.put("Lo", new Category(32));
            cMap.put("Mn", new Category(64));
            cMap.put("Me", new Category(128));
            cMap.put("Mc", new Category(256));
            cMap.put("Nd", new Category(512));
            cMap.put("Nl", new Category(1024));
            cMap.put("No", new Category(2048));
            cMap.put("Zs", new Category(4096));
            cMap.put("Zl", new Category(8192));
            cMap.put("Zp", new Category(16384));
            cMap.put("Cc", new Category(32768));
            cMap.put("Cf", new Category(65536));
            cMap.put("Co", new Category(262144));
            cMap.put("Cs", new Category(524288));
            cMap.put("Pd", new Category(0x100000));
            cMap.put("Ps", new Category(0x200000));
            cMap.put("Pe", new Category(0x400000));
            cMap.put("Pc", new Category(0x800000));
            cMap.put("Po", new Category(0x1000000));
            cMap.put("Sm", new Category(0x2000000));
            cMap.put("Sc", new Category(0x4000000));
            cMap.put("Sk", new Category(0x8000000));
            cMap.put("So", new Category(0x10000000));
            cMap.put("L", new Category(62));
            cMap.put("M", new Category(448));
            cMap.put("N", new Category(3584));
            cMap.put("Z", new Category(28672));
            cMap.put("C", new Category(884736));
            cMap.put("P", new Category(0x1F00000));
            cMap.put("S", new Category(0x1E000000));
            cMap.put("LD", new Category(574));
            cMap.put("L1", new Range(255));
            cMap.put("all", new All());
            cMap.put("ASCII", new Range(127));
            cMap.put("Alnum", new Ctype(1792));
            cMap.put("Alpha", new Ctype(768));
            cMap.put("Blank", new Ctype(16384));
            cMap.put("Cntrl", new Ctype(8192));
            cMap.put("Digit", new Range(0x300039));
            cMap.put("Graph", new Ctype(5888));
            cMap.put("Lower", new Range(6357114));
            cMap.put("Print", new Range(2097278));
            cMap.put("Punct", new Ctype(4096));
            cMap.put("Space", new Ctype(2048));
            cMap.put("Upper", new Range(4259930));
            cMap.put("XDigit", new Ctype(32768));
            cMap.put("javaLowerCase", new JavaLowerCase());
            cMap.put("javaUpperCase", new JavaUpperCase());
            cMap.put("javaTitleCase", new JavaTitleCase());
            cMap.put("javaDigit", new JavaDigit());
            cMap.put("javaDefined", new JavaDefined());
            cMap.put("javaLetter", new JavaLetter());
            cMap.put("javaLetterOrDigit", new JavaLetterOrDigit());
            cMap.put("javaJavaIdentifierStart", new JavaJavaIdentifierStart());
            cMap.put("javaJavaIdentifierPart", new JavaJavaIdentifierPart());
            cMap.put("javaUnicodeIdentifierStart", new JavaUnicodeIdentifierStart());
            cMap.put("javaUnicodeIdentifierPart", new JavaUnicodeIdentifierPart());
            cMap.put("javaIdentifierIgnorable", new JavaIdentifierIgnorable());
            cMap.put("javaSpaceChar", new JavaSpaceChar());
            cMap.put("javaWhitespace", new JavaWhitespace());
            cMap.put("javaISOControl", new JavaISOControl());
            cMap.put("javaMirrored", new JavaMirrored());
        }
    }
}

