/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import com.sun.jndi.dns.DnsName;
import com.sun.jndi.dns.Header;
import com.sun.jndi.dns.Packet;
import com.sun.jndi.dns.ResourceRecords;
import com.sun.jndi.dns.Tcp;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.CommunicationException;
import javax.naming.ConfigurationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.ServiceUnavailableException;

public class DnsClient {
    private static final int IDENT_OFFSET = 0;
    private static final int FLAGS_OFFSET = 2;
    private static final int NUMQ_OFFSET = 4;
    private static final int NUMANS_OFFSET = 6;
    private static final int NUMAUTH_OFFSET = 8;
    private static final int NUMADD_OFFSET = 10;
    private static final int DNS_HDR_SIZE = 12;
    private static final int NO_ERROR = 0;
    private static final int FORMAT_ERROR = 1;
    private static final int SERVER_FAILURE = 2;
    private static final int NAME_ERROR = 3;
    private static final int NOT_IMPL = 4;
    private static final int REFUSED = 5;
    private static final String[] rcodeDescription = new String[]{"No error", "DNS format error", "DNS server failure", "DNS name not found", "DNS operation not supported", "DNS service refused"};
    private static final int DEFAULT_PORT = 53;
    private InetAddress[] servers;
    private int[] serverPorts;
    private int timeout;
    private int retries;
    private DatagramSocket udpSocket;
    private Set<Integer> reqs;
    private Map<Integer, byte[]> resps;
    private Object queuesLock = new Object();
    private short ident = 0;
    private Object identLock = new Object();
    private static boolean debug = false;

    public DnsClient(String[] stringArray, int n2, int n3) throws NamingException {
        this.timeout = n2;
        this.retries = n3;
        try {
            this.udpSocket = new DatagramSocket();
        }
        catch (SocketException socketException) {
            ConfigurationException configurationException = new ConfigurationException();
            configurationException.setRootCause(socketException);
            throw configurationException;
        }
        this.servers = new InetAddress[stringArray.length];
        this.serverPorts = new int[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            int n4 = stringArray[i2].indexOf(58, stringArray[i2].indexOf(93) + 1);
            this.serverPorts[i2] = n4 < 0 ? 53 : Integer.parseInt(stringArray[i2].substring(n4 + 1));
            String string = n4 < 0 ? stringArray[i2] : stringArray[i2].substring(0, n4);
            try {
                this.servers[i2] = InetAddress.getByName(string);
                continue;
            }
            catch (UnknownHostException unknownHostException) {
                ConfigurationException configurationException = new ConfigurationException("Unknown DNS server: " + string);
                configurationException.setRootCause(unknownHostException);
                throw configurationException;
            }
        }
        this.reqs = Collections.synchronizedSet(new HashSet());
        this.resps = Collections.synchronizedMap(new HashMap());
    }

    protected void finalize() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.udpSocket.close();
        Object object = this.queuesLock;
        synchronized (object) {
            this.reqs.clear();
            this.resps.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResourceRecords query(DnsName dnsName, int n2, int n3, boolean bl2, boolean bl3) throws NamingException {
        short s2;
        Object object = this.identLock;
        synchronized (object) {
            s2 = this.ident = (short)(this.ident + 1);
        }
        this.reqs.add(Integer.valueOf(s2));
        object = this.makeQueryPacket(dnsName, s2, n2, n3, bl2);
        Exception exception = null;
        boolean[] blArray = new boolean[this.servers.length];
        for (int i2 = 0; i2 < this.retries; ++i2) {
            for (int i3 = 0; i3 < this.servers.length; ++i3) {
                if (blArray[i3]) continue;
                try {
                    if (debug) {
                        DnsClient.dprint("SEND ID (" + (i2 + 1) + "): " + s2);
                    }
                    byte[] byArray = null;
                    byArray = this.doUdpQuery((Packet)object, this.servers[i3], this.serverPorts[i3], i2, s2);
                    if (byArray == null) {
                        if (this.resps.size() > 0) {
                            byArray = this.lookupResponse(Integer.valueOf(s2));
                        }
                        if (byArray == null) continue;
                    }
                    Header header = new Header(byArray, byArray.length);
                    if (bl3 && !header.authoritative) {
                        exception = new NameNotFoundException("DNS response not authoritative");
                        blArray[i3] = true;
                        continue;
                    }
                    if (header.truncated) {
                        for (int i4 = 0; i4 < this.servers.length; ++i4) {
                            int n4 = (i3 + i4) % this.servers.length;
                            if (blArray[n4]) continue;
                            try {
                                byte[] byArray2;
                                Tcp tcp = new Tcp(this.servers[n4], this.serverPorts[n4]);
                                try {
                                    byArray2 = this.doTcpQuery(tcp, (Packet)object);
                                }
                                finally {
                                    tcp.close();
                                }
                                Header header2 = new Header(byArray2, byArray2.length);
                                if (header2.query) {
                                    throw new CommunicationException("DNS error: expecting response");
                                }
                                this.checkResponseCode(header2);
                                if (!bl3 || header2.authoritative) {
                                    header = header2;
                                    byArray = byArray2;
                                    break;
                                }
                                blArray[n4] = true;
                                continue;
                            }
                            catch (Exception exception2) {
                                // empty catch block
                            }
                        }
                    }
                    return new ResourceRecords(byArray, byArray.length, header, false);
                }
                catch (IOException iOException) {
                    if (debug) {
                        DnsClient.dprint("Caught IOException:" + iOException);
                    }
                    if (exception == null) {
                        exception = iOException;
                    }
                    if (!iOException.getClass().getName().equals("java.net.PortUnreachableException")) continue;
                    blArray[i3] = true;
                    continue;
                }
                catch (NameNotFoundException nameNotFoundException) {
                    throw nameNotFoundException;
                }
                catch (CommunicationException communicationException) {
                    if (exception != null) continue;
                    exception = communicationException;
                    continue;
                }
                catch (NamingException namingException) {
                    if (exception == null) {
                        exception = namingException;
                    }
                    blArray[i3] = true;
                }
            }
        }
        this.reqs.remove(s2);
        if (exception instanceof NamingException) {
            throw (NamingException)exception;
        }
        CommunicationException communicationException = new CommunicationException("DNS error");
        communicationException.setRootCause(exception);
        throw communicationException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResourceRecords queryZone(DnsName dnsName, int n2, boolean bl2) throws NamingException {
        short s2;
        Object object = this.identLock;
        synchronized (object) {
            s2 = this.ident = (short)(this.ident + 1);
        }
        object = this.makeQueryPacket(dnsName, s2, n2, 252, bl2);
        Exception exception = null;
        for (int i2 = 0; i2 < this.servers.length; ++i2) {
            ResourceRecords resourceRecords;
            Tcp tcp = new Tcp(this.servers[i2], this.serverPorts[i2]);
            try {
                byte[] byArray = this.doTcpQuery(tcp, (Packet)object);
                Header header = new Header(byArray, byArray.length);
                this.checkResponseCode(header);
                ResourceRecords resourceRecords2 = new ResourceRecords(byArray, byArray.length, header, true);
                if (resourceRecords2.getFirstAnsType() != 6) {
                    throw new CommunicationException("DNS error: zone xfer doesn't begin with SOA");
                }
                if (resourceRecords2.answer.size() == 1 || resourceRecords2.getLastAnsType() != 6) {
                    do {
                        if ((byArray = this.continueTcpQuery(tcp)) == null) {
                            throw new CommunicationException("DNS error: incomplete zone transfer");
                        }
                        header = new Header(byArray, byArray.length);
                        this.checkResponseCode(header);
                        resourceRecords2.add(byArray, byArray.length, header);
                    } while (resourceRecords2.getLastAnsType() != 6);
                }
                resourceRecords2.answer.removeElementAt(resourceRecords2.answer.size() - 1);
                resourceRecords = resourceRecords2;
            }
            catch (Throwable throwable) {
                try {
                    tcp.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    exception = iOException;
                    continue;
                }
                catch (NameNotFoundException nameNotFoundException) {
                    throw nameNotFoundException;
                }
                catch (NamingException namingException) {
                    exception = namingException;
                }
            }
            tcp.close();
            return resourceRecords;
        }
        if (exception instanceof NamingException) {
            throw (NamingException)exception;
        }
        CommunicationException communicationException = new CommunicationException("DNS error during zone transfer");
        communicationException.setRootCause(exception);
        throw communicationException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] doUdpQuery(Packet packet, InetAddress inetAddress, int n2, int n3, int n4) throws IOException, NamingException {
        int n5 = 50;
        DatagramSocket datagramSocket = this.udpSocket;
        synchronized (datagramSocket) {
            DatagramPacket datagramPacket = new DatagramPacket(packet.getData(), packet.length(), inetAddress, n2);
            DatagramPacket datagramPacket2 = new DatagramPacket(new byte[8000], 8000);
            this.udpSocket.connect(inetAddress, n2);
            int n6 = this.timeout * (1 << n3);
            try {
                long l2;
                long l3;
                this.udpSocket.send(datagramPacket);
                int n7 = n6;
                int n8 = 0;
                do {
                    if (debug) {
                        DnsClient.dprint("Trying RECEIVE(" + ++n8 + ") retry(" + (n3 + 1) + ") for:" + n4 + "    sock-timeout:" + n7 + " ms.");
                    }
                    this.udpSocket.setSoTimeout(n7);
                    l2 = System.currentTimeMillis();
                    this.udpSocket.receive(datagramPacket2);
                    l3 = System.currentTimeMillis();
                    byte[] byArray = new byte[datagramPacket2.getLength()];
                    byArray = datagramPacket2.getData();
                    if (!this.isMatchResponse(byArray, n4)) continue;
                    byte[] byArray2 = byArray;
                    return byArray2;
                } while ((n7 = n6 - (int)(l3 - l2)) > n5);
            }
            finally {
                this.udpSocket.disconnect();
            }
            return null;
        }
    }

    private byte[] doTcpQuery(Tcp tcp, Packet packet) throws IOException {
        int n2 = packet.length();
        tcp.out.write(n2 >> 8);
        tcp.out.write(n2);
        tcp.out.write(packet.getData(), 0, n2);
        tcp.out.flush();
        byte[] byArray = this.continueTcpQuery(tcp);
        if (byArray == null) {
            throw new IOException("DNS error: no response");
        }
        return byArray;
    }

    private byte[] continueTcpQuery(Tcp tcp) throws IOException {
        int n2 = tcp.in.read();
        if (n2 == -1) {
            return null;
        }
        int n3 = tcp.in.read();
        if (n3 == -1) {
            throw new IOException("Corrupted DNS response: bad length");
        }
        int n4 = n2 << 8 | n3;
        byte[] byArray = new byte[n4];
        int n5 = 0;
        while (n4 > 0) {
            int n6 = tcp.in.read(byArray, n5, n4);
            if (n6 == -1) {
                throw new IOException("Corrupted DNS response: too little data");
            }
            n4 -= n6;
            n5 += n6;
        }
        return byArray;
    }

    private Packet makeQueryPacket(DnsName dnsName, int n2, int n3, int n4, boolean bl2) {
        short s2 = dnsName.getOctets();
        int n5 = 12 + s2 + 4;
        Packet packet = new Packet(n5);
        int n6 = bl2 ? 256 : 0;
        packet.putShort(n2, 0);
        packet.putShort(n6, 2);
        packet.putShort(1, 4);
        packet.putShort(0, 6);
        packet.putInt(0, 8);
        this.makeQueryName(dnsName, packet, 12);
        packet.putShort(n4, 12 + s2);
        packet.putShort(n3, 12 + s2 + 2);
        return packet;
    }

    private void makeQueryName(DnsName dnsName, Packet packet, int n2) {
        for (int i2 = dnsName.size() - 1; i2 >= 0; --i2) {
            String string = dnsName.get(i2);
            int n3 = string.length();
            packet.putByte(n3, n2++);
            for (int i3 = 0; i3 < n3; ++i3) {
                packet.putByte(string.charAt(i3), n2++);
            }
        }
        if (!dnsName.hasRootLabel()) {
            packet.putByte(0, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] lookupResponse(Integer n2) throws NamingException {
        byte[] byArray;
        if (debug) {
            DnsClient.dprint("LOOKUP for: " + n2 + "\tResponse Q:" + this.resps);
        }
        if ((byArray = this.resps.get(n2)) != null) {
            Object object = this.queuesLock;
            synchronized (object) {
                this.resps.remove(n2);
                this.reqs.remove(n2);
            }
            this.checkResponseCode(new Header(byArray, byArray.length));
            if (debug) {
                DnsClient.dprint("FOUND (" + Thread.currentThread() + ") for:" + n2);
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMatchResponse(byte[] byArray, int n2) throws NamingException {
        Header header = new Header(byArray, byArray.length);
        if (header.query) {
            throw new CommunicationException("DNS error: expecting response");
        }
        if (!this.reqs.contains(n2)) {
            return false;
        }
        if (header.xid == n2) {
            if (debug) {
                DnsClient.dprint("XID MATCH:" + n2);
            }
            Object object = this.queuesLock;
            synchronized (object) {
                this.resps.remove(n2);
                this.reqs.remove(n2);
            }
            this.checkResponseCode(header);
            return true;
        }
        Object object = this.queuesLock;
        synchronized (object) {
            if (this.reqs.contains(n2)) {
                this.resps.put(n2, byArray);
            }
        }
        if (debug) {
            DnsClient.dprint("NO-MATCH SEND ID:" + n2 + " RECVD ID:" + header.xid + "    Response Q:" + this.resps + "    Reqs size:" + this.reqs.size());
        }
        return false;
    }

    private void checkResponseCode(Header header) throws NamingException {
        int n2 = header.rcode;
        if (n2 == 0) {
            return;
        }
        String string = n2 < rcodeDescription.length ? rcodeDescription[n2] : "DNS error";
        string = string + " [response code " + n2 + "]";
        switch (n2) {
            case 2: {
                throw new ServiceUnavailableException(string);
            }
            case 3: {
                throw new NameNotFoundException(string);
            }
            case 4: 
            case 5: {
                throw new OperationNotSupportedException(string);
            }
        }
        throw new NamingException(string);
    }

    public static void setDebug(boolean bl2) {
        debug = bl2;
    }

    private static void dprint(String string) {
        if (debug) {
            System.err.println("DNS: " + string);
        }
    }
}

