/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Clipping;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java2d.AnimatingControlsSurface;
import java2d.CustomControls;
import javax.swing.AbstractButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class Intersection
extends AnimatingControlsSurface {
    private static final int HEIGHTDECREASE = 0;
    private static final int HEIGHTINCREASE = 1;
    private static final int WIDTHDECREASE = 2;
    private static final int WIDTHINCREASE = 3;
    private int xx;
    private int yy;
    private int ww;
    private int hh;
    private int direction = 0;
    private int angdeg;
    private Shape textshape;
    private double sw;
    private double sh;
    private GeneralPath ovals;
    private Rectangle2D rectshape;
    private DemoControls controls;
    protected boolean doIntersection = true;
    protected boolean doOvals = true;
    protected boolean doText;
    protected boolean threeSixty;

    public Intersection() {
        this.setBackground(Color.white);
        this.setControls(new Component[]{new DemoControls(this)});
    }

    public void reset(int n, int n2) {
        this.yy = 0;
        this.xx = 0;
        this.ww = n - 1;
        this.hh = n2;
        this.direction = 0;
        this.angdeg = 0;
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, false);
        Font font = new Font("serif", 1, 32);
        TextLayout textLayout = new TextLayout("J2D", font, fontRenderContext);
        this.sw = textLayout.getBounds().getWidth();
        this.sh = textLayout.getBounds().getHeight();
        int n3 = Math.min(n, n2);
        double d = (double)(n3 - 40) / this.sw;
        double d2 = (double)(n3 - 100) / this.sh;
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d2);
        this.textshape = textLayout.getOutline(affineTransform);
        this.rectshape = this.textshape.getBounds();
        this.sw = this.rectshape.getWidth();
        this.sh = this.rectshape.getHeight();
        this.ovals = new GeneralPath();
        this.ovals.append(new Ellipse2D.Double(10.0, 10.0, 20.0, 20.0), false);
        this.ovals.append(new Ellipse2D.Double(n - 30, 10.0, 20.0, 20.0), false);
        this.ovals.append(new Ellipse2D.Double(10.0, n2 - 30, 20.0, 20.0), false);
        this.ovals.append(new Ellipse2D.Double(n - 30, n2 - 30, 20.0, 20.0), false);
    }

    public void step(int n, int n2) {
        if (this.direction == 0) {
            this.yy += 2;
            this.hh -= 4;
            if (this.yy >= n2 / 2) {
                this.direction = 1;
            }
        } else if (this.direction == 1) {
            this.yy -= 2;
            this.hh += 4;
            if (this.yy <= 0) {
                this.direction = 2;
                this.hh = n2 - 1;
                this.yy = 0;
            }
        }
        if (this.direction == 2) {
            this.xx += 2;
            this.ww -= 4;
            if (this.xx >= n / 2) {
                this.direction = 3;
            }
        } else if (this.direction == 3) {
            this.xx -= 2;
            this.ww += 4;
            if (this.xx <= 0) {
                this.direction = 0;
                this.ww = n - 1;
                this.xx = 0;
            }
        }
        if ((this.angdeg += 5) == 360) {
            this.angdeg = 0;
            this.threeSixty = true;
        }
    }

    public void render(int n, int n2, Graphics2D graphics2D) {
        Rectangle rectangle = new Rectangle(this.xx, this.yy, this.ww, this.hh);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(Math.toRadians(this.angdeg), n / 2, n2 / 2);
        affineTransform.translate((double)(n / 2) - this.sw / 2.0, this.sh + ((double)n2 - this.sh) / 2.0);
        GeneralPath generalPath = new GeneralPath();
        if (this.doOvals) {
            generalPath.append(this.ovals, false);
        }
        if (this.doText) {
            generalPath.append(affineTransform.createTransformedShape(this.textshape), false);
        } else {
            generalPath.append(affineTransform.createTransformedShape(this.rectshape), false);
        }
        if (this.doIntersection) {
            graphics2D.clip(rectangle);
            graphics2D.clip(generalPath);
        }
        graphics2D.setColor(Color.green);
        graphics2D.fill(rectangle);
        graphics2D.setClip(new Rectangle(0, 0, n, n2));
        graphics2D.setColor(Color.lightGray);
        graphics2D.draw(rectangle);
        graphics2D.setColor(Color.black);
        graphics2D.draw(generalPath);
    }

    public static void main(String[] stringArray) {
        Intersection.createDemoFrame(new Intersection());
    }

    static class DemoControls
    extends CustomControls
    implements ActionListener {
        Intersection demo;
        JToolBar toolbar;

        public DemoControls(Intersection intersection) {
            super(intersection.name);
            this.demo = intersection;
            this.toolbar = new JToolBar();
            this.add(this.toolbar);
            this.toolbar.setFloatable(false);
            this.addTool("Intersect", true);
            this.addTool("Text", false);
            this.addTool("Ovals", true);
        }

        public void addTool(String string, boolean bl) {
            JToggleButton jToggleButton = (JToggleButton)this.toolbar.add(new JToggleButton(string));
            jToggleButton.setFocusPainted(false);
            jToggleButton.setSelected(bl);
            jToggleButton.addActionListener(this);
            int n = jToggleButton.getPreferredSize().width;
            Dimension dimension = new Dimension(n, 21);
            jToggleButton.setPreferredSize(dimension);
            jToggleButton.setMaximumSize(dimension);
            jToggleButton.setMinimumSize(dimension);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
            if (jToggleButton.getText().equals("Intersect")) {
                this.demo.doIntersection = jToggleButton.isSelected();
            } else if (jToggleButton.getText().equals("Ovals")) {
                this.demo.doOvals = jToggleButton.isSelected();
            } else if (jToggleButton.getText().equals("Text")) {
                this.demo.doText = jToggleButton.isSelected();
            }
            if (this.demo.animating.thread == null) {
                this.demo.repaint();
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(200, 40);
        }

        public void run() {
            Thread thread = Thread.currentThread();
            while (this.thread == thread) {
                if (this.demo.threeSixty) {
                    ((AbstractButton)this.toolbar.getComponentAtIndex(1)).doClick();
                    this.demo.threeSixty = false;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
            this.thread = null;
        }
    }
}

