/* 
 * Copyright (C) 2003 the xine project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: script_engine.h,v 1.3 2003/03/14 20:47:04 guenter Exp $
 *
 * gate to the spider monkey javascript interpreter
 *
 * provides functions to generate interpreter instances
 * customized for controlling the xine engine and the gxine
 * frontend. this is done by defining a set of global objects
 * and functions so any xine and gxine function can be invoked from
 * (java)scripts.
 *
 *
 * the following functions are defined at this point:
 *
 */

#ifndef HAVE_SCRIPT_ENGINE_H
#define HAVE_SCRIPT_ENGINE_H

#include <glib.h>

typedef struct se_s se_t; /* se: _s_cript _e_ngine */

typedef void (*se_print_cb_t) (void *user_data, char *str);

typedef int (*se_view_cb_t) (void *user_data, char *property);

/*
 * create a javascript engine with predefined xine functions 
 * and objects
 */
se_t *se_new (void);

int se_eval (se_t *se, const gchar *script, se_print_cb_t print_cb,
	     void *print_cb_data);

int se_eval_view (se_t *se, const gchar *script, 
		  se_view_cb_t view_cb, void *user_data);

gchar *se_result_str (se_t *se) ;

int se_result_num (se_t *se, int *num);

#endif
