namespace Binge.Bits
{
	using System;
	using System.Collections;
	using Binge;

	public abstract class MethodBase: MemberBase, ICloneable
	{
		public ReturnType Returns;
		public ArrayList Parameters, Glue, SupportGlue, CallParameters, Overloads;

		public MethodBase (bool init): base (init)
		{
			if (! init) return;

			Returns = new ReturnType ();
			Parameters = new ArrayList ();
			Glue = new ArrayList ();
			SupportGlue = new ArrayList ();
			CallParameters = new ArrayList ();
			Overloads = new ArrayList ();
		}

		public MethodBase (): this (true) {}

		public object Clone ()
		{
			MethodBase clone = MemberwiseClone () as MethodBase;
			
			// MemberBase
			clone.Parent = Parent;
			clone.Attributes = Attributes.Clone () as ArrayList;

			// MethodBase
			clone.Parameters = Parameters.Clone () as ArrayList;
			clone.Glue = Glue.Clone () as ArrayList;
			clone.SupportGlue = SupportGlue.Clone () as ArrayList;
			clone.CallParameters = CallParameters.Clone () as ArrayList;
			clone.Overloads = Overloads.Clone () as ArrayList;

			return clone as object;
		}
	}
}
