/**********************************/
/* This file is part of QtC 0.0.2 */
/* (c) 1997 Roberto Alsina        */
/* Licensed under the GPL v2      */
/* Read file COPYING for details  */
/**********************************/

extern "C" {
#include "qt_Slot.h"
}

#include "Slot.moc"


Slot::Slot()
{
}
Slot::~Slot()
{
}
Slot *Slot::new_IntSlot(qt_intCallback cb)
{
    Slot *s=new Slot();
    s->intf=cb;
    return s;
}
Slot *Slot::new_VoidSlot(qt_voidCallback cb)
{
    Slot *s=new Slot();
    s->voidf=cb;
    return s;
}
Slot *Slot::new_FloatSlot(qt_floatCallback cb)
{
    Slot *s=new Slot();
    s->floatf=cb;
    return s;
}

Slot *Slot::new_QRectSlot(qt_QRectCallback cb)
{
    Slot *s=new Slot();
    s->qrectf=cb;
    return s;
}

Slot *Slot::new_QSizeSlot(qt_QSizeCallback cb)
{
    Slot *s=new Slot();
    s->qsizef=cb;
    return s;
}

Slot *Slot::new_QStringSlot(qt_QStringCallback cb)
{
    Slot *s=new Slot();
    s->qss=cb;
    return s;
}

Slot *Slot::new_UserDataSlot(qt_UserDataCallback cb, void * data)
{
    Slot *s=new Slot();
    s->userdataf=cb;
    s->userData=data;

    return s;
}

void Slot::intSlot(int i)
{
    intf(i);
}
void Slot::voidSlot()
{
    voidf();
}
void Slot::floatSlot(float f)
{
    floatf(f);
}
void Slot::QRectSlot(QRect f)
{
    qrectf((qt_QRect *)&f);
}
void Slot::QSizeSlot(QSize f)
{
    qsizef((qt_QSize *)&f);
}

void Slot::QStringSlot(const QString &s)
{
    qss((qt_QString *)&s);
}

void Slot::UserDataSlot()
{
    userdataf(userData, 0);
}
void Slot::UserDataSlot(int v)
{
    userdataf(userData, &v);
}
void Slot::UserDataSlot(void * v)
{
    userdataf(userData, &v);
}

/*
bool Slot::map(Slot *slt, QObject *snd, const char *sig)
{
	if (intf)
		return connect(snd, sig, slt, "intSlot(int)");
        if (voidf)
		return connect(snd, sig, slt, "voidSlot()");
        if (floatf)
		return connect(snd, sig, slt, "floatSlot(float)");
        if (qrectf)
		return connect(snd, sig, slt, "QRectSlot(QRect)");
        if (qsizef)
		return connect(snd, sig, slt, "QSizeSlot(QSize)");

	return false;
}
*/
qt_Slot *qt_new_IntSlot(qt_intCallback cb)
{
    return (qt_Slot *)Slot::new_IntSlot(cb);
}
qt_Slot *qt_new_VoidSlot(qt_voidCallback cb)
{
    return (qt_Slot *)Slot::new_VoidSlot(cb);
}
qt_Slot *qt_new_FloatSlot(qt_floatCallback cb)
{
    return (qt_Slot *)Slot::new_FloatSlot(cb);
}
qt_Slot *qt_new_QRectSlot(qt_QRectCallback cb)
{
    return (qt_Slot *)Slot::new_QRectSlot(cb);
}
qt_Slot *qt_new_QSizeSlot(qt_QSizeCallback cb)
{
    return (qt_Slot *)Slot::new_QSizeSlot(cb);
}
qt_Slot *qt_new_QStringSlot(qt_QStringCallback cb)
{
    return (qt_Slot *)Slot::new_QStringSlot(cb);
}
qt_Slot *qt_new_UserDataSlot(qt_UserDataCallback cb, void * userData)
{
    return (qt_Slot *)Slot::new_UserDataSlot(cb, userData);
}

/*
bool qt_Slot_connect(qt_Slot* slot, qt_QObject *sender, const char *signal)
{
	Slot *slt = (Slot *)slot;
	QObject *snd = (QObject *)sender;
	Slot::map(slt, sender, signal);
}
*/

Signal::Signal()
{
}

Signal::~Signal()
{
}


void Signal::emitInt(int i)
{
    emit intSignal(i);
}
void Signal::emitVoid()
{
    emit voidSignal();
}

void Signal::emitFloat(float f)
{
    emit floatSignal(f);
}

void Signal::emitPointer(void * v)
{
    emit pointerSignal(v);
}

qt_Signal *qt_new_Signal()
{
    return (qt_Signal *)new Signal();
}

void qt_emitInt(qt_Signal *s,int i)
{
    ((Signal *)s)->emitInt(i);
}
void qt_emitVoid(qt_Signal *s)
{
    ((Signal *)s)->emitVoid();
}
void qt_emitFloat(qt_Signal *s,float f)
{
    ((Signal *)s)->emitFloat(f);
}
void qt_emitPointer(qt_Signal *s,void * v)
{
    ((Signal *)s)->emitPointer(v);
}

void qt_del_Slot(qt_Slot *s)
{
    delete (Slot *)s;
}

void qt_del_Signal(qt_Signal *s)
{
    delete (Signal *)s;
}
