/***************************************************************************
                            GUSOut.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef GUSOUT_H
#define GUSOUT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/MidiOut.h>

/**

 Gravis Ultrasound synthesizer output class . This class is used to send midi
 events to synthesizers on GUS cards.

 GUSOut inherits @ref MidiOut and supports the same simple API.

 The recommended way to use this class is by using a @ref DeviceManager
 object, and use the @ref -[DeviceManager setPatchesToUse] member which will
 call the @ref  #--setPatchesToUse member in this class.

 @author Antonio Larrosa Jimenez <larrosa@kde.org>
 
 @version 0.9.5 17/01/2000

 @short Sends MIDI events to GUS synths.
*/
@interface GUSOut : MidiOut 

/** 
 Constructor. See @ref -[MidiOut MidiOut] for more information.
     
*/
- initWithInt: (int)d total: (int)total;
- init;

/** 
 Destructor.
     
*/
- (void) dealloc;

/** 
 See @ref -[MidiOut openDev]
     
*/
- openDev: (int)sqfd;

/** 
 See @ref -[MidiOut closeDev]
     
*/
- closeDev;

/** 
 See @ref -[MidiOut initDev]
     
*/
- initDev;

/** 
 See @ref -[MidiOut noteOn]
     
*/
- noteOn: (unsigned char)chn note: (unsigned char)note vel: (unsigned char)vel;

/** 
 See @ref -[MidiOut noteOff]
     
*/
- noteOff: (unsigned char)chn note: (unsigned char)note vel: (unsigned char)vel;

/** 
 See @ref -[MidiOut keyPressure]
     
*/
- keyPressure: (unsigned char)chn note: (unsigned char)note vel: (unsigned char)vel;

/** 
 See @ref -[MidiOut chnPatchChange]
     
*/
- chnPatchChange: (unsigned char)chn patch: (unsigned char)patch;

/** 
 See @ref -[MidiOut chnPressure]
     
*/
- chnPressure: (unsigned char)chn vel: (unsigned char)vel;

/** 
 See @ref -[MidiOut chnPitchBender]
     
*/
- chnPitchBender: (unsigned char)chn lsb: (unsigned char)lsb msb: (unsigned char)msb;

/** 
 See @ref -[MidiOut chnController]
     
*/
- chnController: (unsigned char)chn ctl: (unsigned char)ctl v: (unsigned char)v;

/** 
 It's an empty function, as GUS synths don't support System Exclusive
 messages
     
*/
- sysex: (unsigned char*)data size: (unsigned long)size;

/** 
 See @ref -[DeviceManager setPatchesToUse] . All the information about this
 member is explained there because it's (for now) just a simple call to this
 function when the device used is a GUS device, and you're supposed to use
 a DeviceManager object instead of a GUSOut object except in rare ocassions.

*/
- setPatchesToUse: (int*)patchesused;

/** 
 Loads a single patch on the synthesizer memory.

*/
- (int) loadPatch: (int)pgm;

/** 
 Returns p if the patch with number p has been correctly loaded.
 In the case it hasn't been loaded, it returns the number of another patch
 that is loaded and that should be used instead.

*/
- (int) patch: (int)p;

/** 
 Sets the directory where the GUS patches are stored, that is, where the
 acpiano.pat, ... files can be found.

 It will store a copy of the parameter, so you should delete the memory
 used by the parameter you passed.
     
*/
+ setGUSPatchesDirectory: (NSString *)dir;
@end

#endif
