/***************************************************************************
                            kde_NodeFilter.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_NODEFILTER
#define KDE_NODEFILTER

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Filters are objects that know how to "filter out" nodes. If an
 Iterator or <code> TreeWalker </code> is given a filter, before it
 returns the next node, it applies the filter. If the filter says to
 accept the node, the Iterator returns it; otherwise, the Iterator
 looks for the next node and pretends that the node that was
 rejected was not there.

  The DOM does not provide any filters. Filter is just an interface
 that users can implement to provide their own filters.

  Filters do not need to know how to iterate, nor do they need to
 know anything about the data structure that is being iterated. This
 makes it very easy to write filters, since the only thing they have
 to know how to do is evaluate a single node. One filter may be used
 with a number of different kinds of Iterators, encouraging code
 reuse.

 To create your own cutsom NodeFilter, define a subclass of
 CustomNodeFilter which overrides the acceptNode() method and assign
 an instance of it to the NodeFilter. For more details see the
 CustomNodeFilter class
 
 @short *
 Filters are objects that know how to "filter out" nodes.
*/
#define NODEFILTER_FILTER_ACCEPT	1
#define NODEFILTER_FILTER_REJECT	2
#define NODEFILTER_FILTER_SKIP	3
#define NODEFILTER_SHOW_ALL	0xFFFFFFFF
#define NODEFILTER_SHOW_ELEMENT	0x00000001
#define NODEFILTER_SHOW_ATTRIBUTE	0x00000002
#define NODEFILTER_SHOW_TEXT	0x00000004
#define NODEFILTER_SHOW_CDATA_SECTION	0x00000008
#define NODEFILTER_SHOW_ENTITY_REFERENCE	0x00000010
#define NODEFILTER_SHOW_ENTITY	0x00000020
#define NODEFILTER_SHOW_PROCESSING_INSTRUCTION	0x00000040
#define NODEFILTER_SHOW_COMMENT	0x00000080
#define NODEFILTER_SHOW_DOCUMENT	0x00000100
#define NODEFILTER_SHOW_DOCUMENT_TYPE	0x00000200
#define NODEFILTER_SHOW_DOCUMENT_FRAGMENT	0x00000400
#define NODEFILTER_SHOW_NOTATION	0x00000800
#ifdef __cplusplus
extern   "C" {
#endif
kde_NodeFilter * kde_new_NodeFilter();
kde_NodeFilter * kde_new_NodeFilter1(kde_NodeFilter* other);
void kde_del_NodeFilter( kde_NodeFilter* p );

/** *
 Test whether a specified node is visible in the logical view of
 a TreeWalker or NodeIterator. This function will be called by
 the implementation of TreeWalker and NodeIterator; it is not
 intended to be called directly from user code.

     
*/
short kde_NodeFilter_acceptNode(kde_NodeFilter* instPointer,kde_DOMNode* n);

/** *

 not part of the DOM
     
*/
int kde_NodeFilter_isNull(kde_NodeFilter* instPointer);
void kde_NodeFilter_setCustomNodeFilter(kde_NodeFilter* instPointer,kde_CustomNodeFilter* custom);
kde_CustomNodeFilter* kde_NodeFilter_customNodeFilter(kde_NodeFilter* instPointer);
kde_NodeFilter* kde_NodeFilter_createCustom( kde_CustomNodeFilter* custom);

#ifdef __cplusplus
}
#endif
#endif
