/***************************************************************************
                            kde_KPanelApplet.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KPANELAPPLET
#define KDE_KPANELAPPLET

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Implement a panel applet.

 Panel applets

 Note: For security and stability reasons the panel won't load
 untrusted third party applets directly into its namespace but via an
 external wrapper process.

 The panel locates available applets by searching for applet desktop
 files in (ALL_KDEDIRS)/share/apps/kicker/applets. Every panel applet should
 install a desktop file there to be recognised by the panel.

 Besides standard keys like "Name", "Comment" and "Icon" there are
 two panel applet specific keys:

 Used by the panel to locate the applet DSO (Dynamic Shared Object)
 Example: X-KDE-Library=libexampleapplet

 Similar to @ref KApplication and @ref KUniqueApplication there are
 two types of panel applets. Use unique applets when it makes no
 sence to run more than one instance of a applet in the panel. A
 good example for unique applets is the taskbar applet.  Use normal
 applets when you need instance specific configuration. An example
 is the koolclock applet where you might want to run two instances
 in your panel, one configured as analog clock, the other one as
 digital clock. X-KDE-UniqueApplet is a boolean key which defaults
 to "false".  Example: X-KDE-UniqueApplet=true

 Back to panel applet DSOs, the following conventions are used for KDE:
 Name:    lib<appletname>applet.la
 LDFLAGS: -module -no-undefined

 To implement a panel applet it is not enough to write a class
 inheriting from KPanelApplet but you also have to provide a
 factory function in your DSO.  A sample factory function could look
 like this:

 <pre>

 extern "C"
 {
     KPanelApplet* init(QWidget *parent, const QString& configFile)
     {
         KGlobal::locale()->insertCatalogue("exampleapplet");
         return new ExampleApplet(configFile, KPanelApplet::Normal,
                       KPanelApplet::About | KPanelApplet::Help | KPanelApplet::Preferences,
                       parent, "exampleapplet");
     }
 }

 </pre>

 Note: Don't change the factory function signature or the panel will
 fail to load your applet.

 @author Matthias Elter <elter@kde.org>

 @short KDE Panel Applet class.
*/
#define KPANELAPPLET_Normal	0
#define KPANELAPPLET_Stretch	0
#define KPANELAPPLET_About	1
#define KPANELAPPLET_Help	2
#define KPANELAPPLET_Preferences	4
#define KPANELAPPLET_ReportBug	8
#define KPANELAPPLET_pLeft	0
#define KPANELAPPLET_pRight	0
#define KPANELAPPLET_pTop	1
#define KPANELAPPLET_pBottom	2
#define KPANELAPPLET_LeftTop	0
#define KPANELAPPLET_Center	0
#define KPANELAPPLET_RightBottom	1
#define KPANELAPPLET_Up	0
#define KPANELAPPLET_Down	0
#define KPANELAPPLET_Left	1
#define KPANELAPPLET_Right	2

/** *
 Constructs a KPanelApplet just like any other widget.

*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KPanelApplet * kde_new_KPanelApplet(qt_QString * configFile, int t, int actions, qt_QWidget * parent, char* name, int f);

/** *
 Destructor.

*/
void kde_del_KPanelApplet( kde_KPanelApplet* p );

/** *
 Returns a suggested width for a given height.

 Every applet should reimplement this function.

 Depending on the panel orientation the height (horizontal panel) or the
 width (vertical panel) of the applets is fixed.
 The exact values of the fixed size component depend on the panel size.

 On a horizontal panel the applet height is fixed, the panel will
 call @ref widthForHeight(int height) with @p height
 equal to 'the fixed applet height'
 when laying out the applets.

 The applet can now choose the other size component (width)
 based on the given height.

 The width you return is granted.

*/
int kde_KPanelApplet_widthForHeight(kde_KPanelApplet* instPointer,int height);

/** *

 Every applet should reimplement this function.

 Depending on the panel orientation the height (horizontal panel) or the
 width (vertical panel) of the applets is fixed.
 The exact values of the fixed size component depend on the panel size.

 On a vertical panel the applet width is fixed, the panel will
 call @ref heightForWidth(int width) with @p width
 equal to 'the fixed applet width'
 when layint out the applets.

 The applet can now choose the other size component (height)
 based on the given width.

 The height you return is granted.

*/
int kde_KPanelApplet_heightForWidth(kde_KPanelApplet* instPointer,int width);

/** *
 Always use this @ref KConfig object to save/load your applets configuration.

 For unique applets this config object will write to a config file called
 <appletname>rc in the users local KDE directory.

 For normal applets this config object will write to a instance specific config file
 called <appletname><instanceid>rc in the users local KDE directory.

*/
kde_KConfig* kde_KPanelApplet_config(kde_KPanelApplet* instPointer);

/** *

*/
int kde_KPanelApplet_type(kde_KPanelApplet* instPointer);

/** *

*/
int kde_KPanelApplet_actions(kde_KPanelApplet* instPointer);

/** *
 Generic action dispatcher. Called  when the user selects an item
 from the applets RMB menu.

 Reimplement this function to handle actions.

 For About, Help, Preferences and ReportBug, use the convenience handlers
 ref about(), help(), preferences(), reportBug()

*/
void kde_KPanelApplet_action(kde_KPanelApplet* instPointer,int a);

/** *

*/
void kde_KPanelApplet_setPosition(kde_KPanelApplet* instPointer,int p);

/** *

*/
void kde_KPanelApplet_setAlignment(kde_KPanelApplet* instPointer,int a);

/** *
 Is called when the user selects "About" from the applet's RMB menu.
 Reimplement this function to launch a about dialog.

 Note that this is called only when your applet supports the About action.
 See @ref Action and KPanelApplet().

*/
void kde_KPanelApplet_about(kde_KPanelApplet* instPointer);

/** *
 Is called when the user selects "Help" from the applet's RMB menu.
 Reimplement this function to launch a manual or help page.

 Note that this is called only when your applet supports the Help action.
 See @ref Action and KPanelApplet().

*/
void kde_KPanelApplet_help(kde_KPanelApplet* instPointer);

/** *
 Is called when the user selects "Preferences" from the applet's RMB menu.
 Reimplement this function to launch a preferences dialog or kcontrol module.

 Note that this is called only when your applet supports the preferences action.
 See @ref Action and KPanelApplet().

*/
void kde_KPanelApplet_preferences(kde_KPanelApplet* instPointer);

/** *
 Is called when the user selects "Report bug" from the applet's RMB menu.
 Reimplement this function to launch a bug reporting dialog.

 Note that this is called only when your applet supports the ReportBug
 action.
 See @ref Action and KPanelApplet()

*/
void kde_KPanelApplet_reportBug(kde_KPanelApplet* instPointer);

/** *

*/
int kde_KPanelApplet_orientation(kde_KPanelApplet* instPointer);

/** *

*/
int kde_KPanelApplet_position(kde_KPanelApplet* instPointer);

/** *

*/
int kde_KPanelApplet_alignment(kde_KPanelApplet* instPointer);

/** *
 The panel on which this applet resides has changed its position.
 Reimplement this change handler in order to adjust the look of your
 applet.

*/
void kde_KPanelApplet_positionChange(kde_KPanelApplet* instPointer,int p);

/** *
 The panel on which this applet resides has changed its alignment.
 Reimplement this change handler in order to adjust the look of your
 applet.

*/
void kde_KPanelApplet_alignmentChange(kde_KPanelApplet* instPointer,int arg1);

/** *
 The orientation changed to @p orientation. Reimplement this
 change handler in order to adjust the look of your applet.

*/
void kde_KPanelApplet_orientationChange(kde_KPanelApplet* instPointer,int arg1);

/** *
 You may need this if you want to popup menus at the right position.

 See @ref  popupDirectionChange()

*/
int kde_KPanelApplet_popupDirection(kde_KPanelApplet* instPointer);

/** *
 The popup direction changed to @p direction. Reimplement this
 change handler in order to adjust the look of your applet.

*/
void kde_KPanelApplet_popupDirectionChange(kde_KPanelApplet* instPointer,int arg1);
void kde_KPanelApplet_virtual_hook(kde_KPanelApplet* instPointer,int identifier, void* data);

#ifdef __cplusplus
}
#endif
#endif
