#ifndef __RULES_H__
#define __RULES_H__


#include <qstring.h>
#include <qdict.h>
#include <qmap.h>

class KeyRules
{
public:

  KeyRules(QString rule="xfree86");

  const QDict<char> &models() const { return m_models; };
  const QDict<char> &layouts() const { return m_layouts; };
  const QDict<char> &options() const { return m_options; };

  void parseVariants(const QStringList& vars, QDict<char>& variants, bool chkVars=true);
  static QStringList rules(QString path = QString::null);

  QStringList getVariants(const QString& layout);
  unsigned int getGroup(const QString& layout, const char* baseGr);

  bool isXFree_v43() { return m_xfree43; }
  bool isSingleGroup(const QString& layout) { return m_xfree43 && !m_oldLayouts.contains(layout)
			     && !m_nonLatinLayouts.contains(layout); } 

protected:

  void loadRules(QString filename);
  void loadGroups(QString filename);
  void loadOldLayouts(QString filename);

private:

  QDict<char> m_models;
  QDict<char> m_layouts;
  QDict<char> m_options;
  QMap<QString, unsigned int> m_initialGroups;
  QDict<QStringList> m_varLists;
  QStringList m_oldLayouts;
  QStringList m_nonLatinLayouts;
  bool m_xfree43;
};


#endif
