/*****************************************************************

Copyright (c) 2001 Matthias Elter <elter@kde.org>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <klocale.h>
#include <kglobal.h>

#include "kicker.h"
#include "extensionmanager.h"
#include "pluginmanager.h"
#include "pluginloader.h"

#include "panelmenuiteminfo.h"
#include "removeextension_mnu.h"
#include "removeextension_mnu.moc"

PanelRemoveExtensionMenu::PanelRemoveExtensionMenu( QWidget *parent, const char *name )
    : QPopupMenu( parent, name )
{
    connect(this, SIGNAL(activated(int)), SLOT(slotExec(int)));
    connect(this, SIGNAL(aboutToShow()), SLOT(slotAboutToShow()));

    containers.setAutoDelete( FALSE );
}

void PanelRemoveExtensionMenu::slotAboutToShow()
{
    int id = 0;

    clear();
    containers = ExtensionManager::the()->containers();
    QValueList<PanelMenuItemInfo> items;

    for( QPtrListIterator<ExtensionContainer> it( containers ); it.current() ; ++it ) {
        const AppletInfo info = it.current()->info();
        QString name = info.name().replace( "&", "&&" );
        switch (it.current()->position())
        {
            case Top:
                name = i18n("%1 (Top)").arg(name);
            break;
            case Right:
                name = i18n("%1 (Right)").arg(name);
            break;
            case Bottom:
                name = i18n("%1 (Bottom)").arg(name);
            break;
            case Left:
                name = i18n("%1 (Left)").arg(name);
            break;
        }
        items.append(PanelMenuItemInfo(QString::null, name, id ));
        id++;
    }

    qHeapSort(items);
    QValueList<PanelMenuItemInfo>::iterator it = items.begin();
    for (; it != items.end(); ++it)
    {
        (*it).plug(this);
    }

    if ( containers.count() > 1 ) {
        insertSeparator();
        insertItem( i18n( "All" ), this, SLOT( slotRemoveAll() ) );
    }
}

void PanelRemoveExtensionMenu::slotExec( int id )
{
    if ( containers.at( id ) )
	ExtensionManager::the()->removeContainer( containers.at( id ) );
}

PanelRemoveExtensionMenu::PanelRemoveExtensionMenu()
{

}

void PanelRemoveExtensionMenu::slotRemoveAll()
{
    for( QPtrListIterator<ExtensionContainer> it( containers ); it.current() ; ++it )
	ExtensionManager::the()->removeContainer( it.current() );
}
