/***************************************************************************
                          preferencesdialog.cpp  -  description
                             -------------------
    begin                : mer ao 6 2003
    copyright            : (C) 2003 by ervin
    email                : ervin at tuxfamily dot org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "preferencesdialog.h"

#include <klocale.h>
#include <kmimetype.h>
#include <qlayout.h>
#include <qwhatsthis.h>
#include <klistview.h>

class DeviceItem : public QCheckListItem
{
public:
	DeviceItem(QListView *parent, const QString name,
	           const QString mimetype)
		: QCheckListItem(parent, name, CheckBox),
		  mMimeType(mimetype) { }

	const QString &mimeType() const { return mMimeType; }

private:
	QString mMimeType;
};


PreferencesDialog::PreferencesDialog(QWidget *parent, const char *name)
	: KDialogBase(Plain, i18n("Devices Applet Preferences"), Ok|Cancel|Default,
	              Ok, parent, name, true)
{
	QVBoxLayout* layout = new QVBoxLayout(plainPage());
	mpDevicesListView = new KListView(plainPage());
	layout->addWidget(mpDevicesListView);

	mpDevicesListView->setFullWidth(true);
	mpDevicesListView->addColumn( i18n("Types to Display") );
	QWhatsThis::add(mpDevicesListView, i18n("Deselect the device types which you do not want to see on the desktop"));
	
	slotDefault();
}

PreferencesDialog::~PreferencesDialog()
{
}

void PreferencesDialog::slotDefault()
{
	QStringList defaultExclude;

	defaultExclude << "kdedevice/hdd_mounted";
	defaultExclude << "kdedevice/hdd_unmounted";
	defaultExclude << "kdedevice/cdrom_unmounted";
	defaultExclude << "kdedevice/cdwriter_unmounted";
	
	setExcludedDevices(defaultExclude);
}

QStringList PreferencesDialog::excludedDevices()
{
	QStringList exclude;

	for(DeviceItem *it=static_cast<DeviceItem *>(mpDevicesListView->firstChild());
	    it; it=static_cast<DeviceItem *>(it->nextSibling()))
	{
		if(!it->isOn()) exclude << it->mimeType();
	}

	return exclude;
}

void PreferencesDialog::setExcludedDevices(QStringList excludedList)
{
	mpDevicesListView->clear();
	mpDevicesListView->setRootIsDecorated(false);
	KMimeType::List mimetypes = KMimeType::allMimeTypes();

	QValueListIterator<KMimeType::Ptr> it2(mimetypes.begin());

	for(; it2 != mimetypes.end(); ++it2)
	{
		if ((*it2)->name().startsWith("kdedevice/"))
		{
                        bool ok=excludedList.contains((*it2)->name())==0;
			DeviceItem *item = new DeviceItem(mpDevicesListView, (*it2)->comment(), (*it2)->name());
			item->setOn(ok);
		}
	}
}

#include "preferencesdialog.moc"
