/*
 *  Copyright (C) 2002  Ricardo Fernndez Pascual
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _GUL_GOBJECT_MISC_H_
#define _GUL_GOBJECT_MISC_H_

#include <glib-object.h>

#define MAKE_GET_TYPE(l,str,t,ci,i,parent) \
GType l##_get_type(void)\
{\
	static GType type = 0;				\
	if (!type) {					\
		static GTypeInfo const object_info = {	\
			sizeof (t##Class),		\
							\
			(GBaseInitFunc) NULL,		\
			(GBaseFinalizeFunc) NULL,	\
							\
			(GClassInitFunc) ci,		\
			(GClassFinalizeFunc) NULL,	\
			NULL,	/* class_data */	\
							\
			sizeof (t),			\
			0,	/* n_preallocs */	\
			(GInstanceInitFunc) i,		\
		};					\
		type = g_type_register_static (parent, str, &object_info, (GTypeFlags)0);	\
	}						\
	return type;					\
}

#define MAKE_GET_TYPE_IFACE(l,str,t,ci,i,parent,ii,iparent) \
GType l##_get_type(void)\
{\
	static GType type = 0;				\
	if (!type) {					\
		static GTypeInfo const object_info = {	\
			sizeof (t##Class),		\
							\
			(GBaseInitFunc) NULL,		\
			(GBaseFinalizeFunc) NULL,	\
							\
			(GClassInitFunc) ci,		\
			(GClassFinalizeFunc) NULL,	\
			NULL,	/* class_data */	\
							\
			sizeof (t),			\
			0,	/* n_preallocs */	\
			(GInstanceInitFunc) i,		\
		};					\
							\
		static const GInterfaceInfo iface_info = {	\
			(GInterfaceInitFunc) ii,	\
			NULL,				\
			NULL				\
		};					\
							\
		type = g_type_register_static (parent, str, &object_info, (GTypeFlags)0);	\
							\
		g_type_add_interface_static (type,	\
					     iparent,	\
					     &iface_info);	\
	}						\
	return type;					\
}

#define GUL_TYPE_FUNC(prefix, class_name, parent)	\
MAKE_GET_TYPE(prefix, #class_name, class_name,		\
	      prefix##_class_init, prefix##_init,	\
	      parent)



gboolean	gul_boolean_handled_accumulator		(GSignalInvocationHint *ihint,
							 GValue                *return_accu,
							 const GValue          *handler_return,
							 gpointer               dummy);

#endif
