#!/bin/sh -
#
# Copyright (c) 1983 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms are permitted
# provided that the above copyright notice and this paragraph are
# duplicated in all such forms and that any documentation,
# advertising materials, and other materials related to such
# distribution and use acknowledge that the software was developed
# by the University of California, Berkeley.  The name of the
# University may not be used to endorse or promote products derived
# from this software without specific prior written permission.
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#
#	@(#)newvers.sh	5.4 (Berkeley) 12/7/88
#	$Header: /usr/src/local/icsi/pmake/etc/RCS/newvers.sh,v 1.3 1996/04/19 06:27:17 stolcke Exp $
#
if [ ! -r version ]; then echo 0 > version; fi
touch version

awk '	{	version = $1 + 1; }\
END	{	printf "#define BUILDNO	%d\n", version > "version.h";\
		printf "%d\n", version > "version"; }' < version

HOST=`hostname`
case $HOST in
*.*)	DOMAINHOST=$HOST
	;;
*)	if [ -f /etc/resolv.conf ]; then
		DOMAIN=`awk '$1 == "domain" { domain = $2 } 
			     END { print domain }' /etc/resolv.conf`
		DOMAINHOST=$HOST.$DOMAIN
	else
		DOMAINHOST=$HOST
	fi
	;;
esac

echo "#define BUILDER	\"${USER-${LOGNAME-root}}@$DOMAINHOST\"" >> version.h
echo "#define BUILDDATE	\"`date`\"" >> version.h

