/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2001-2002 by Luis Carvalho
    email                : lpassos@mail.telepac.pt
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#include "pmtexture.h"
#include "pmxmlhelper.h"
#include "pmmemento.h"
#include "pmtextureedit.h"

#include <klocale.h>

PMMetaObject* PMTexture::s_pMetaObject = 0;
PMObject* createNewTexture( PMPart* part )
{
   return new PMTexture( part );
}

PMTexture::PMTexture( PMPart* part )
      : Base( part )
{
}

PMTexture::PMTexture( const PMTexture& t )
      : Base( t )
{
}

PMTexture::~PMTexture( )
{
}

PMMetaObject* PMTexture::metaObject( ) const
{
   if( !s_pMetaObject )
   {
      s_pMetaObject = new PMMetaObject( "Texture", Base::metaObject( ),
                                        createNewTexture );
   }
   return s_pMetaObject;
}

void PMTexture::cleanUp( ) const
{
   if( s_pMetaObject )
   {
      delete s_pMetaObject;
      s_pMetaObject = 0;
   }
   Base::cleanUp( );
}

QString PMTexture::description( ) const
{
   return i18n( "texture" );
}

PMDialogEditBase* PMTexture::editWidget( QWidget* parent ) const
{
   return new PMTextureEdit( parent );
}

