/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2003 by Luis Carvalho
    email                : lpassos@oninetspeed.pt
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#include "pmlibraryhandleedit.h"

#include <qpushbutton.h>
#include <qlineedit.h>
#include <qtextedit.h>
#include <qvbox.h>
#include <qlayout.h>
#include <qlabel.h>

#include <klocale.h>
#include <kconfig.h>
#include <kmessagebox.h>
#include <kfiledialog.h>

#include "pmlineedits.h"
#include "pmdialogeditbase.h"
#include "pmlibraryhandle.h"

QSize PMLibraryHandleEdit::s_size = QSize( 600, 400 );

PMLibraryHandleEdit::PMLibraryHandleEdit( PMLibraryHandle* lib, QWidget* parent, const char* name )
      : KDialogBase( parent, name, true, i18n( "Create Library" ),
                     Ok | Cancel, Ok )
{
   m_pLibrary = lib;

   resize( s_size );
   QWidget* page = new QWidget( this );
   setMainWidget( page );
   QVBoxLayout* vl = new QVBoxLayout( page, KDialog::spacingHint( ) );

   QGridLayout* grid = new QGridLayout( vl, 4, 2 );
   QLabel* lbl = new QLabel( i18n( "Name: " ), page );
   m_pNameEdit = new QLineEdit( page );
   grid->addWidget( lbl, 0, 0 );
   grid->addWidget( m_pNameEdit, 0, 1 );

   lbl = new QLabel( i18n( "Author: " ), page );
   m_pAuthorEdit = new QLineEdit( page );
   grid->addWidget( lbl, 1, 0 );
   grid->addWidget( m_pAuthorEdit, 1, 1 );

   lbl = new QLabel( i18n( "Description: " ), page );
   m_pDescriptionEdit = new QTextEdit( page );
   m_pDescriptionEdit->setMaximumHeight( 120 );
   grid->addWidget( lbl, 2, 0 );
   grid->addMultiCellWidget( m_pDescriptionEdit, 2, 3, 1, 1 );
   grid->setRowStretch( 3, 1 );

   connect( m_pNameEdit, SIGNAL( textChanged( const QString& ) ), SLOT( slotEditsChanged( const QString& ) ) );
   connect( m_pAuthorEdit, SIGNAL( textChanged( const QString& ) ), SLOT( slotEditsChanged( const QString& ) ) );
   connect( m_pDescriptionEdit, SIGNAL( textChanged( ) ), SLOT( slotDescriptionChanged( ) ) );

   enableButtonOK( false );
}

void PMLibraryHandleEdit::slotEditsChanged( const QString& /*str*/ )
{
   enableButtonOK( true );
}

void PMLibraryHandleEdit::slotDescriptionChanged( )
{
   enableButtonOK( true );
}

void PMLibraryHandleEdit::saveConfig( KConfig* cfg )
{
   cfg->setGroup( "Appearance" );
   cfg->writeEntry( "LibraryHandleEditSize", s_size );
}

void PMLibraryHandleEdit::restoreConfig( KConfig* cfg )
{
   cfg->setGroup( "Appearance" );

   QSize defaultSize( 300, 200 );
   s_size = cfg->readSizeEntry( "LibraryHandleEditSize", &defaultSize );
}

void PMLibraryHandleEdit::resizeEvent( QResizeEvent* ev )
{
   s_size = ev->size( );
}

void PMLibraryHandleEdit::slotOk( )
{
   m_pLibrary->setName( m_pNameEdit->text( ) );
   m_pLibrary->setAuthor( m_pAuthorEdit->text( ) );
   m_pLibrary->setDescription( m_pDescriptionEdit->text( ) );

   accept( );
}

#include "pmlibraryhandleedit.moc"
